/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.api.config.StateTransitionThrottleConfig;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.common.PartitionStateMap;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.stages.IntermediateStateOutput;
import org.apache.helix.controller.stages.MessageOutput;
import org.apache.helix.controller.stages.StateTransitionThrottleController;
import org.apache.helix.model.BuiltInStateModelDefinitions;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.monitoring.mbeans.ResourceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateStateCalcStage
extends AbstractBaseStage {
    private static final Logger logger = LoggerFactory.getLogger((String)IntermediateStateCalcStage.class.getName());

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        BestPossibleStateOutput bestPossibleStateOutput = (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
        Map resourceToRebalance = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        MessageOutput messageOutput = (MessageOutput)event.getAttribute(AttributeName.MESSAGES_SELECTED.name());
        if (currentStateOutput == null || bestPossibleStateOutput == null || resourceToRebalance == null || cache == null || messageOutput == null) {
            throw new StageException(String.format("Missing attributes in event: %s. Requires CURRENT_STATE (%s) |BEST_POSSIBLE_STATE (%s) |RESOURCES (%s) |MESSAGE_SELECT (%s) |DataCache (%s)", event, currentStateOutput, bestPossibleStateOutput, resourceToRebalance, messageOutput, cache));
        }
        IntermediateStateOutput intermediateStateOutput = this.compute(event, resourceToRebalance, currentStateOutput, bestPossibleStateOutput, messageOutput);
        event.addAttribute(AttributeName.INTERMEDIATE_STATE.name(), intermediateStateOutput);
        int maxPartitionPerInstance = cache.getClusterConfig().getMaxPartitionsPerInstance();
        if (maxPartitionPerInstance > 0) {
            this.validateMaxPartitionsPerInstance(event, cache, intermediateStateOutput, maxPartitionPerInstance);
        }
    }

    private IntermediateStateOutput compute(ClusterEvent event, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput, BestPossibleStateOutput bestPossibleStateOutput, MessageOutput messageOutput) {
        IntermediateStateOutput output = new IntermediateStateOutput();
        ResourceControllerDataProvider dataCache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        StateTransitionThrottleController throttleController = new StateTransitionThrottleController(resourceMap.keySet(), dataCache.getClusterConfig(), dataCache.getLiveInstances().keySet());
        ArrayList<ResourcePriority> prioritizedResourceList = new ArrayList<ResourcePriority>();
        for (String string : resourceMap.keySet()) {
            prioritizedResourceList.add(new ResourcePriority(string));
        }
        if (dataCache.getClusterConfig().getResourcePriorityField() != null) {
            String priorityField = dataCache.getClusterConfig().getResourcePriorityField();
            for (ResourcePriority resourcePriority : prioritizedResourceList) {
                String resourceName = resourcePriority.getResourceName();
                if (dataCache.getResourceConfig(resourceName) != null && dataCache.getResourceConfig(resourceName).getSimpleConfig(priorityField) != null) {
                    resourcePriority.setPriority(dataCache.getResourceConfig(resourceName).getSimpleConfig(priorityField));
                    continue;
                }
                if (dataCache.getIdealState(resourceName) == null || dataCache.getIdealState(resourceName).getRecord().getSimpleField(priorityField) == null) continue;
                resourcePriority.setPriority(dataCache.getIdealState(resourceName).getRecord().getSimpleField(priorityField));
            }
            Collections.sort(prioritizedResourceList);
        }
        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ResourcePriority resourcePriority : prioritizedResourceList) {
            String resourceName = resourcePriority.getResourceName();
            if (!bestPossibleStateOutput.containsResource(resourceName)) {
                LogUtil.logInfo(logger, this._eventId, String.format("Skip calculating intermediate state for resource %s because the best possible state is not available.", resourceName));
                continue;
            }
            Resource resource = resourceMap.get(resourceName);
            IdealState idealState = dataCache.getIdealState(resourceName);
            if (idealState == null) {
                LogUtil.logInfo(logger, this._eventId, String.format("IdealState for resource %s does not exist; resource may not exist anymore", resourceName));
                idealState = new IdealState(resourceName);
                idealState.setStateModelDefRef(resource.getStateModelDefRef());
            }
            try {
                output.setState(resourceName, this.computeIntermediatePartitionState(dataCache, clusterStatusMonitor, idealState, resourceMap.get(resourceName), currentStateOutput, bestPossibleStateOutput.getPartitionStateMap(resourceName), bestPossibleStateOutput.getPreferenceLists(resourceName), throttleController, messageOutput.getResourceMessageMap(resourceName)));
            }
            catch (HelixException ex) {
                LogUtil.logInfo(logger, this._eventId, "Failed to calculate intermediate partition states for resource " + resourceName, ex);
                arrayList.add(resourceName);
            }
        }
        if (clusterStatusMonitor != null) {
            clusterStatusMonitor.setResourceRebalanceStates(arrayList, ResourceMonitor.RebalanceStatus.INTERMEDIATE_STATE_CAL_FAILED);
            clusterStatusMonitor.setResourceRebalanceStates(output.resourceSet(), ResourceMonitor.RebalanceStatus.NORMAL);
        }
        return output;
    }

    private void validateMaxPartitionsPerInstance(ClusterEvent event, ResourceControllerDataProvider cache, IntermediateStateOutput intermediateStateOutput, int maxPartitionPerInstance) {
        Map<String, PartitionStateMap> resourceStatesMap = intermediateStateOutput.getResourceStatesMap();
        HashMap<String, Integer> instancePartitionCounts = new HashMap<String, Integer>();
        for (String resource : resourceStatesMap.keySet()) {
            IdealState idealState = cache.getIdealState(resource);
            if (idealState != null && idealState.getStateModelDefRef().equals(BuiltInStateModelDefinitions.Task.name())) continue;
            PartitionStateMap partitionStateMap = resourceStatesMap.get(resource);
            Map<Partition, Map<String, String>> stateMaps = partitionStateMap.getStateMap();
            for (Partition p : stateMaps.keySet()) {
                Map<String, String> stateMap = stateMaps.get(p);
                for (String instance : stateMap.keySet()) {
                    String state = stateMap.get(instance);
                    if (state.equals(HelixDefinedState.DROPPED.name())) continue;
                    if (!instancePartitionCounts.containsKey(instance)) {
                        instancePartitionCounts.put(instance, 0);
                    }
                    int partitionCount = (Integer)instancePartitionCounts.get(instance);
                    if (++partitionCount > maxPartitionPerInstance) {
                        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
                        String errMsg = String.format("Problem: according to this assignment, instance %s contains more replicas/partitions than the maximum number allowed (%d). Pipeline will stop the rebalance and put the cluster %s into maintenance mode", instance, maxPartitionPerInstance, cache.getClusterName());
                        if (manager != null) {
                            if (manager.getHelixDataAccessor().getProperty(manager.getHelixDataAccessor().keyBuilder().maintenance()) == null) {
                                manager.getClusterManagmentTool().autoEnableMaintenanceMode(manager.getClusterName(), true, errMsg, MaintenanceSignal.AutoTriggerReason.MAX_PARTITION_PER_INSTANCE_EXCEEDED);
                            }
                            LogUtil.logWarn(logger, this._eventId, errMsg);
                        } else {
                            LogUtil.logError(logger, this._eventId, "HelixManager is not set/null! Failed to pause this cluster/enable maintenance mode due to an instance being assigned more replicas/partitions than the limit.");
                        }
                        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
                        if (clusterStatusMonitor != null) {
                            clusterStatusMonitor.setResourceRebalanceStates(Collections.singletonList(resource), ResourceMonitor.RebalanceStatus.INTERMEDIATE_STATE_CAL_FAILED);
                        }
                        throw new HelixException(errMsg);
                    }
                    instancePartitionCounts.put(instance, partitionCount);
                }
            }
        }
    }

    private PartitionStateMap computeIntermediatePartitionState(ResourceControllerDataProvider cache, ClusterStatusMonitor clusterStatusMonitor, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput, PartitionStateMap bestPossiblePartitionStateMap, Map<String, List<String>> preferenceLists, StateTransitionThrottleController throttleController, Map<Partition, List<Message>> resourceMessageMap) {
        String resourceName = resource.getResourceName();
        LogUtil.logDebug(logger, this._eventId, String.format("Processing resource: %s", resourceName));
        if (!IdealState.RebalanceMode.FULL_AUTO.equals((Object)idealState.getRebalanceMode()) || resourceMessageMap.isEmpty()) {
            return bestPossiblePartitionStateMap;
        }
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        HashSet<Partition> partitionsWithErrorStateReplica = new HashSet<Partition>();
        HashSet<String> messagesForRecovery = new HashSet<String>();
        HashSet<String> messagesForLoad = new HashSet<String>();
        HashSet<String> messagesThrottledForRecovery = new HashSet<String>();
        HashSet<String> messagesThrottledForLoad = new HashSet<String>();
        ClusterConfig clusterConfig = cache.getClusterConfig();
        int threshold = 1;
        for (Partition partition : currentStateOutput.getCurrentStateMap(resourceName).keySet()) {
            Map<String, String> entry = currentStateOutput.getCurrentStateMap(resourceName).get(partition);
            if (!entry.values().stream().anyMatch(x -> x.contains(HelixDefinedState.ERROR.name()))) continue;
            partitionsWithErrorStateReplica.add(partition);
        }
        int numPartitionsWithErrorReplica = partitionsWithErrorStateReplica.size();
        if (clusterConfig.getErrorOrRecoveryPartitionThresholdForLoadBalance() != -1) {
            threshold = clusterConfig.getErrorOrRecoveryPartitionThresholdForLoadBalance();
        } else if (clusterConfig.getErrorPartitionThresholdForLoadBalance() != 0) {
            threshold = clusterConfig.getErrorPartitionThresholdForLoadBalance();
        }
        boolean onlyDownwardLoadBalance = numPartitionsWithErrorReplica > threshold;
        this.chargePendingTransition(resource, currentStateOutput, throttleController, cache, preferenceLists, stateModelDef);
        ArrayList<Partition> partitions = new ArrayList<Partition>(resource.getPartitions());
        partitions.sort(new PartitionPriorityComparator(bestPossiblePartitionStateMap.getStateMap(), currentStateOutput.getCurrentStateMap(resourceName), stateModelDef.getTopState()));
        for (Partition partition : partitions) {
            if (resourceMessageMap.get(partition) == null || resourceMessageMap.get(partition).isEmpty()) continue;
            ArrayList<Message> messagesToThrottle = new ArrayList<Message>((Collection)resourceMessageMap.get(partition));
            Map<String, String> derivedCurrentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<String> preferenceList = preferenceLists.get(partition.getPartitionName());
            Map<String, Integer> requiredState = this.getRequiredStates(resourceName, cache, preferenceList);
            if (preferenceList != null && !preferenceList.isEmpty()) {
                messagesToThrottle.sort(new MessagePriorityComparator(preferenceList, stateModelDef.getStatePriorityMap()));
            }
            for (Message message : messagesToThrottle) {
                StateTransitionThrottleConfig.RebalanceType rebalanceType = this.getRebalanceTypePerMessage(requiredState, message, derivedCurrentStateMap);
                if (rebalanceType.equals((Object)StateTransitionThrottleConfig.RebalanceType.RECOVERY_BALANCE)) {
                    message.setSTRebalanceType(Message.STRebalanceType.RECOVERY_REBALANCE);
                    messagesForRecovery.add(message.getId());
                    this.recoveryRebalance(resource, partition, throttleController, message, cache, messagesThrottledForRecovery, resourceMessageMap);
                } else if (rebalanceType.equals((Object)StateTransitionThrottleConfig.RebalanceType.LOAD_BALANCE)) {
                    message.setSTRebalanceType(Message.STRebalanceType.LOAD_REBALANCE);
                    messagesForLoad.add(message.getId());
                    this.loadRebalance(resource, partition, throttleController, message, cache, onlyDownwardLoadBalance, stateModelDef, messagesThrottledForLoad, resourceMessageMap);
                }
                if (messagesThrottledForRecovery.contains(message.getId()) || messagesThrottledForLoad.contains(message.getId())) continue;
                derivedCurrentStateMap.put(message.getTgtName(), message.getToState());
            }
        }
        PartitionStateMap intermediatePartitionStateMap = new PartitionStateMap(resourceName, currentStateOutput.getCurrentStateMap(resourceName));
        this.computeIntermediateMap(intermediatePartitionStateMap, currentStateOutput.getPendingMessageMap(resourceName), resourceMessageMap);
        if (!messagesForRecovery.isEmpty()) {
            LogUtil.logInfo(logger, this._eventId, String.format("Recovery balance needed for %s with messages: %s", resourceName, messagesForRecovery));
        }
        if (!messagesForLoad.isEmpty()) {
            LogUtil.logInfo(logger, this._eventId, String.format("Load balance needed for %s with messages: %s", resourceName, messagesForLoad));
        }
        if (!partitionsWithErrorStateReplica.isEmpty()) {
            LogUtil.logInfo(logger, this._eventId, String.format("Partition currently has an ERROR replica in %s partitions: %s", resourceName, partitionsWithErrorStateReplica));
        }
        if (clusterStatusMonitor != null) {
            clusterStatusMonitor.updateRebalancerStats(resourceName, messagesForRecovery.size(), messagesForLoad.size(), messagesThrottledForRecovery.size(), messagesThrottledForLoad.size(), onlyDownwardLoadBalance);
        }
        if (logger.isDebugEnabled()) {
            this.logPartitionMapState(resourceName, new HashSet<Partition>(resource.getPartitions()), messagesForRecovery, messagesThrottledForRecovery, messagesForLoad, messagesThrottledForLoad, currentStateOutput, bestPossiblePartitionStateMap, intermediatePartitionStateMap);
        }
        LogUtil.logDebug(logger, this._eventId, String.format("End processing resource: %s", resourceName));
        return intermediatePartitionStateMap;
    }

    private boolean isLoadBalanceDownwardStateTransition(Message message, StateModelDefinition stateModelDefinition) {
        if (stateModelDefinition == null) {
            return false;
        }
        Map<String, Integer> statePriorityMap = stateModelDefinition.getStatePriorityMap();
        return statePriorityMap.containsKey(message.getFromState()) && statePriorityMap.containsKey(message.getToState()) && statePriorityMap.get(message.getFromState()) < statePriorityMap.get(message.getToState());
    }

    private void chargePendingTransition(Resource resource, CurrentStateOutput currentStateOutput, StateTransitionThrottleController throttleController, ResourceControllerDataProvider cache, Map<String, List<String>> preferenceLists, StateModelDefinition stateModelDefinition) {
        String resourceName = resource.getResourceName();
        for (Partition partition : resource.getPartitions()) {
            Map<String, Integer> requiredStates = this.getRequiredStates(resourceName, cache, preferenceLists.get(partition.getPartitionName()));
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
            ArrayList<Message> pendingMessages = new ArrayList<Message>(currentStateOutput.getPendingMessageMap(resourceName, partition).values());
            List<String> preferenceList = preferenceLists.get(partition.getPartitionName());
            if (preferenceList != null && !preferenceList.isEmpty()) {
                pendingMessages.sort(new MessagePriorityComparator(preferenceList, stateModelDefinition.getStatePriorityMap()));
            }
            for (Message message : pendingMessages) {
                StateTransitionThrottleConfig.RebalanceType rebalanceType = this.getRebalanceTypePerMessage(requiredStates, message, currentStateMap);
                String currentState = currentStateMap.get(message.getTgtName());
                if (currentState == null) {
                    currentState = stateModelDefinition.getInitialState();
                }
                if (message.getToState().equals(currentState) || !message.getFromState().equals(currentState) || cache.getDisabledInstancesForPartition(resourceName, partition.getPartitionName()).contains(message.getTgtName())) continue;
                throttleController.chargeInstance(rebalanceType, message.getTgtName());
                throttleController.chargeResource(rebalanceType, resourceName);
                throttleController.chargeCluster(rebalanceType);
            }
        }
    }

    private void recoveryRebalance(Resource resource, Partition partition, StateTransitionThrottleController throttleController, Message messageToThrottle, ResourceControllerDataProvider cache, Set<String> messagesThrottled, Map<Partition, List<Message>> resourceMessageMap) {
        this.throttleStateTransitionsForReplica(throttleController, resource.getResourceName(), partition, messageToThrottle, messagesThrottled, StateTransitionThrottleConfig.RebalanceType.RECOVERY_BALANCE, cache, resourceMessageMap);
    }

    private void loadRebalance(Resource resource, Partition partition, StateTransitionThrottleController throttleController, Message messageToThrottle, ResourceControllerDataProvider cache, boolean onlyDownwardLoadBalance, StateModelDefinition stateModelDefinition, Set<String> messagesThrottled, Map<Partition, List<Message>> resourceMessageMap) {
        if (onlyDownwardLoadBalance && !this.isLoadBalanceDownwardStateTransition(messageToThrottle, stateModelDefinition)) {
            resourceMessageMap.get(partition).remove(messageToThrottle);
            messagesThrottled.add(messageToThrottle.getId());
            return;
        }
        this.throttleStateTransitionsForReplica(throttleController, resource.getResourceName(), partition, messageToThrottle, messagesThrottled, StateTransitionThrottleConfig.RebalanceType.LOAD_BALANCE, cache, resourceMessageMap);
    }

    private void throttleStateTransitionsForReplica(StateTransitionThrottleController throttleController, String resourceName, Partition partition, Message messageToThrottle, Set<String> messagesThrottled, StateTransitionThrottleConfig.RebalanceType rebalanceType, ResourceControllerDataProvider cache, Map<Partition, List<Message>> resourceMessageMap) {
        boolean hasReachedThrottlingLimit = false;
        if (throttleController.shouldThrottleForResource(rebalanceType, resourceName)) {
            hasReachedThrottlingLimit = true;
            if (logger.isDebugEnabled()) {
                LogUtil.logDebug(logger, this._eventId, String.format("Throttled because of cluster/resource quota is full for message {%s} on partition {%s} in resource {%s}", messageToThrottle.getId(), partition.getPartitionName(), resourceName));
            }
        } else if (!cache.getDisabledInstancesForPartition(resourceName, partition.getPartitionName()).contains(messageToThrottle.getTgtName()) && throttleController.shouldThrottleForInstance(rebalanceType, messageToThrottle.getTgtName())) {
            hasReachedThrottlingLimit = true;
            if (logger.isDebugEnabled()) {
                LogUtil.logDebug(logger, this._eventId, String.format("Throttled because of instance level quota is full on instance {%s} for message {%s} of partition {%s} in resource {%s}", messageToThrottle.getId(), messageToThrottle.getTgtName(), partition.getPartitionName(), resourceName));
            }
        }
        if (!hasReachedThrottlingLimit) {
            throttleController.chargeCluster(rebalanceType);
            throttleController.chargeResource(rebalanceType, resourceName);
            throttleController.chargeInstance(rebalanceType, messageToThrottle.getTgtName());
        } else {
            resourceMessageMap.get(partition).remove(messageToThrottle);
            messagesThrottled.add(messageToThrottle.getId());
        }
    }

    private StateTransitionThrottleConfig.RebalanceType getRebalanceTypePerMessage(Map<String, Integer> desiredStates, Message message, Map<String, String> derivedCurrentStates) {
        HashMap<String, Integer> desiredStatesSnapshot = new HashMap<String, Integer>(desiredStates);
        for (String state : derivedCurrentStates.values()) {
            if (!desiredStatesSnapshot.containsKey(state)) continue;
            if ((Integer)desiredStatesSnapshot.get(state) == 1) {
                desiredStatesSnapshot.remove(state);
                continue;
            }
            desiredStatesSnapshot.put(state, (Integer)desiredStatesSnapshot.get(state) - 1);
        }
        return desiredStatesSnapshot.containsKey(message.getToState()) ? StateTransitionThrottleConfig.RebalanceType.RECOVERY_BALANCE : StateTransitionThrottleConfig.RebalanceType.LOAD_BALANCE;
    }

    private Map<String, Integer> getRequiredStates(String resourceName, ResourceControllerDataProvider resourceControllerDataProvider, List<String> preferenceList) {
        int requiredNumReplica;
        IdealState idealState = resourceControllerDataProvider.getIdealState(resourceName);
        StateModelDefinition stateModelDefinition = resourceControllerDataProvider.getStateModelDef(idealState.getStateModelDefRef());
        int n = idealState.getMinActiveReplicas() == -1 ? idealState.getReplicaCount(preferenceList == null ? 0 : preferenceList.size()) : (requiredNumReplica = idealState.getMinActiveReplicas());
        if (preferenceList != null) {
            return stateModelDefinition.getStateCountMap((int)preferenceList.stream().filter(i -> resourceControllerDataProvider.getEnabledLiveInstances().contains(i)).count(), requiredNumReplica);
        }
        return stateModelDefinition.getStateCountMap(resourceControllerDataProvider.getEnabledLiveInstances().size(), requiredNumReplica);
    }

    private void logPartitionMapState(String resource, Set<Partition> allPartitions, Set<String> recoveryPartitions, Set<String> recoveryThrottledPartitions, Set<String> loadbalancePartitions, Set<String> loadbalanceThrottledPartitions, CurrentStateOutput currentStateOutput, PartitionStateMap bestPossibleStateMap, PartitionStateMap intermediateStateMap) {
        if (logger.isDebugEnabled()) {
            LogUtil.logDebug(logger, this._eventId, String.format("Partitions need recovery: %s\nPartitions get throttled on recovery: %s", recoveryPartitions, recoveryThrottledPartitions));
            LogUtil.logDebug(logger, this._eventId, String.format("Partitions need loadbalance: %s\nPartitions get throttled on load-balance: %s", loadbalancePartitions, loadbalanceThrottledPartitions));
        }
        for (Partition partition : allPartitions) {
            if (!logger.isDebugEnabled()) continue;
            LogUtil.logDebug(logger, this._eventId, String.format("%s : Best possible map: %s", partition, bestPossibleStateMap.getPartitionMap(partition)));
            LogUtil.logDebug(logger, this._eventId, String.format("%s : Current State: %s", partition, currentStateOutput.getCurrentStateMap(resource, partition)));
            LogUtil.logDebug(logger, this._eventId, String.format("%s: Pending state: %s", partition, currentStateOutput.getPendingMessageMap(resource, partition)));
            LogUtil.logDebug(logger, this._eventId, String.format("%s: Intermediate state: %s", partition, intermediateStateMap.getPartitionMap(partition)));
        }
    }

    private void computeIntermediateMap(PartitionStateMap intermediateStateMap, Map<Partition, Map<String, Message>> pendingMessageMap, Map<Partition, List<Message>> resourceMessageMap) {
        for (Map.Entry<Partition, Map<String, Message>> entry : pendingMessageMap.entrySet()) {
            entry.getValue().forEach((key, value) -> {
                if (!value.getToState().equals(HelixDefinedState.DROPPED.name())) {
                    intermediateStateMap.setState((Partition)entry.getKey(), value.getTgtName(), value.getToState());
                } else if (intermediateStateMap.getStateMap().containsKey(entry.getKey())) {
                    intermediateStateMap.getStateMap().get(entry.getKey()).remove(value.getTgtName());
                }
            });
        }
        for (Map.Entry<Partition, Object> entry : resourceMessageMap.entrySet()) {
            ((List)entry.getValue()).forEach(e -> {
                if (!e.getToState().equals(HelixDefinedState.DROPPED.name())) {
                    intermediateStateMap.setState((Partition)entry.getKey(), e.getTgtName(), e.getToState());
                } else {
                    intermediateStateMap.getStateMap().get(entry.getKey()).remove(e.getTgtName());
                }
            });
        }
    }

    private static class PartitionPriorityComparator
    implements Comparator<Partition> {
        private final Map<Partition, Map<String, String>> _bestPossibleMap;
        private final Map<Partition, Map<String, String>> _currentStateMap;
        private final String _topState;

        PartitionPriorityComparator(Map<Partition, Map<String, String>> bestPossibleMap, Map<Partition, Map<String, String>> currentStateMap, String topState) {
            this._bestPossibleMap = bestPossibleMap;
            this._currentStateMap = currentStateMap;
            this._topState = topState;
        }

        @Override
        public int compare(Partition p1, Partition p2) {
            int idealStateMatched2;
            int currentActiveReplicas2;
            int missTopState2;
            int missTopState1 = this.getMissTopStateIndex(p1);
            if (missTopState1 != (missTopState2 = this.getMissTopStateIndex(p2))) {
                return Integer.compare(missTopState1, missTopState2);
            }
            int currentActiveReplicas1 = this.getCurrentActiveReplicas(p1);
            if (currentActiveReplicas1 != (currentActiveReplicas2 = this.getCurrentActiveReplicas(p2))) {
                return Integer.compare(currentActiveReplicas1, currentActiveReplicas2);
            }
            int idealStateMatched1 = this.getIdealStateMatched(p1);
            if (idealStateMatched1 != (idealStateMatched2 = this.getIdealStateMatched(p2))) {
                return Integer.compare(idealStateMatched1, idealStateMatched2);
            }
            return p1.getPartitionName().compareTo(p2.getPartitionName());
        }

        private int getMissTopStateIndex(Partition partition) {
            if (!this._currentStateMap.containsKey(partition) || !this._currentStateMap.get(partition).containsValue(this._topState)) {
                return 0;
            }
            return 1;
        }

        private int getCurrentActiveReplicas(Partition partition) {
            int currentActiveReplicas = 0;
            if (!this._currentStateMap.containsKey(partition)) {
                return currentActiveReplicas;
            }
            HashMap<String, Integer> stateCountMap = new HashMap<String, Integer>();
            for (String state : this._bestPossibleMap.get(partition).values()) {
                if (!stateCountMap.containsKey(state)) {
                    stateCountMap.put(state, 0);
                }
                stateCountMap.put(state, (Integer)stateCountMap.get(state) + 1);
            }
            for (String state : this._currentStateMap.get(partition).values()) {
                if (!stateCountMap.containsKey(state) || (Integer)stateCountMap.get(state) <= 0) continue;
                ++currentActiveReplicas;
                stateCountMap.put(state, (Integer)stateCountMap.get(state) - 1);
            }
            return currentActiveReplicas;
        }

        private int getIdealStateMatched(Partition partition) {
            int matchedState = 0;
            if (!this._currentStateMap.containsKey(partition)) {
                return matchedState;
            }
            for (String instance : this._bestPossibleMap.get(partition).keySet()) {
                if (!this._bestPossibleMap.get(partition).get(instance).equals(this._currentStateMap.get(partition).get(instance))) continue;
                ++matchedState;
            }
            return matchedState;
        }
    }

    private static class MessagePriorityComparator
    implements Comparator<Message> {
        private final Map<String, Integer> _preferenceInstanceMap;
        private final Map<String, Integer> _statePriorityMap;

        MessagePriorityComparator(List<String> preferenceList, Map<String, Integer> statePriorityMap) {
            this._preferenceInstanceMap = IntStream.range(0, preferenceList.size()).boxed().collect(Collectors.toMap(preferenceList::get, index -> index));
            this._statePriorityMap = statePriorityMap;
        }

        @Override
        public int compare(Message m1, Message m2) {
            if (m1.getToState().equals(m2.getToState()) && this._preferenceInstanceMap.containsKey(m1.getTgtName()) && this._preferenceInstanceMap.containsKey(m2.getTgtName())) {
                return this._preferenceInstanceMap.get(m1.getTgtName()).compareTo(this._preferenceInstanceMap.get(m2.getTgtName()));
            }
            if (!m1.getToState().equals(m2.getToState())) {
                return this._statePriorityMap.get(m1.getToState()).compareTo(this._statePriorityMap.get(m2.getToState()));
            }
            return m1.getTgtName().compareTo(m2.getTgtName());
        }
    }

    private static class ResourcePriority
    implements Comparable<ResourcePriority> {
        private final String _resourceName;
        private int _priority = Integer.MIN_VALUE;

        ResourcePriority(String resourceName) {
            this._resourceName = resourceName;
        }

        @Override
        public int compareTo(ResourcePriority resourcePriority) {
            return Integer.compare(resourcePriority._priority, this._priority);
        }

        public String getResourceName() {
            return this._resourceName;
        }

        public void setPriority(String priority) {
            try {
                this._priority = Integer.parseInt(priority);
            }
            catch (Exception e) {
                logger.warn(String.format("Invalid priority field %s for resource %s", priority, this._resourceName));
            }
        }
    }
}

