/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.spectator;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.management.JMException;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.api.listeners.ConfigChangeListener;
import org.apache.helix.api.listeners.CurrentStateChangeListener;
import org.apache.helix.api.listeners.CustomizedViewChangeListener;
import org.apache.helix.api.listeners.CustomizedViewRootChangeListener;
import org.apache.helix.api.listeners.ExternalViewChangeListener;
import org.apache.helix.api.listeners.InstanceConfigChangeListener;
import org.apache.helix.api.listeners.LiveInstanceChangeListener;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.api.listeners.RoutingTableChangeListener;
import org.apache.helix.common.ClusterEventProcessor;
import org.apache.helix.common.caches.CurrentStateSnapshot;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.ClusterEventType;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.CustomizedView;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.monitoring.mbeans.RoutingTableProviderMonitor;
import org.apache.helix.spectator.CustomizedViewRoutingTable;
import org.apache.helix.spectator.RoutingDataCache;
import org.apache.helix.spectator.RoutingTable;
import org.apache.helix.spectator.RoutingTableSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingTableProvider
implements ExternalViewChangeListener,
InstanceConfigChangeListener,
ConfigChangeListener,
LiveInstanceChangeListener,
CurrentStateChangeListener,
CustomizedViewChangeListener,
CustomizedViewRootChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(RoutingTableProvider.class);
    private static final long DEFAULT_PERIODIC_REFRESH_INTERVAL = 300000L;
    private final Map<String, AtomicReference<RoutingTable>> _routingTableRefMap;
    private final HelixManager _helixManager;
    private final RouterUpdater _routerUpdater;
    private final Map<PropertyType, List<String>> _sourceDataTypeMap;
    private final Map<RoutingTableChangeListener, ListenerContext> _routingTableChangeListenerMap;
    private final Map<PropertyType, RoutingTableProviderMonitor> _monitorMap;
    private long _lastRefreshTimestamp;
    private boolean _isPeriodicRefreshEnabled = true;
    private long _periodRefreshInterval;
    private ScheduledThreadPoolExecutor _periodicRefreshExecutor;
    private ExecutorService _reportExecutor;
    private Future _reportingTask = null;
    protected static final String DEFAULT_PROPERTY_TYPE = "HELIX_DEFAULT_PROPERTY";
    protected static final String DEFAULT_STATE_TYPE = "HELIX_DEFAULT";
    final AtomicReference<Map<String, LiveInstance>> _lastSeenSessions = new AtomicReference();

    public RoutingTableProvider() {
        this(null);
    }

    public RoutingTableProvider(HelixManager helixManager) throws HelixException {
        this(helixManager, (Map<PropertyType, List<String>>)ImmutableMap.of((Object)((Object)PropertyType.EXTERNALVIEW), Collections.emptyList()), true, 300000L);
    }

    public RoutingTableProvider(HelixManager helixManager, PropertyType sourceDataType) throws HelixException {
        this(helixManager, (Map<PropertyType, List<String>>)ImmutableMap.of((Object)((Object)sourceDataType), Collections.emptyList()), true, 300000L);
    }

    public RoutingTableProvider(HelixManager helixManager, Map<PropertyType, List<String>> sourceDataTypeMap) {
        this(helixManager, sourceDataTypeMap, true, 300000L);
    }

    public RoutingTableProvider(HelixManager helixManager, PropertyType sourceDataType, boolean isPeriodicRefreshEnabled, long periodRefreshInterval) throws HelixException {
        this(helixManager, (Map<PropertyType, List<String>>)ImmutableMap.of((Object)((Object)sourceDataType), Collections.emptyList()), isPeriodicRefreshEnabled, periodRefreshInterval);
    }

    public RoutingTableProvider(HelixManager helixManager, Map<PropertyType, List<String>> sourceDataTypeMap, boolean isPeriodicRefreshEnabled, long periodRefreshInterval) throws HelixException {
        this.validateSourceDataTypeMap(sourceDataTypeMap);
        this._routingTableRefMap = new HashMap<String, AtomicReference<RoutingTable>>();
        this._helixManager = helixManager;
        this._sourceDataTypeMap = sourceDataTypeMap;
        this._routingTableChangeListenerMap = new ConcurrentHashMap<RoutingTableChangeListener, ListenerContext>();
        String clusterName = this._helixManager != null ? this._helixManager.getClusterName() : null;
        for (PropertyType propertyType : this._sourceDataTypeMap.keySet()) {
            if (this._sourceDataTypeMap.get((Object)propertyType).size() == 0) {
                if (propertyType.equals((Object)PropertyType.CUSTOMIZEDVIEW)) {
                    throw new HelixException("CustomizedView has been used without any aggregation type!");
                }
                String key = this.generateReferenceKey(propertyType.name(), DEFAULT_STATE_TYPE);
                if (this._routingTableRefMap.get(key) != null) continue;
                this._routingTableRefMap.put(key, new AtomicReference<RoutingTable>(new RoutingTable(propertyType)));
                continue;
            }
            if (!propertyType.equals((Object)PropertyType.CUSTOMIZEDVIEW)) {
                throw new HelixException(String.format("Type %s has been used in addition to the propertyType %s !", sourceDataTypeMap.get((Object)propertyType), propertyType.name()));
            }
            for (String customizedStateType : this._sourceDataTypeMap.get((Object)propertyType)) {
                String key = this.generateReferenceKey(propertyType.name(), customizedStateType);
                if (this._routingTableRefMap.get(key) != null) continue;
                this._routingTableRefMap.put(key, new AtomicReference<CustomizedViewRoutingTable>(new CustomizedViewRoutingTable(propertyType, customizedStateType)));
            }
        }
        this._monitorMap = new HashMap<PropertyType, RoutingTableProviderMonitor>();
        for (PropertyType propertyType : this._sourceDataTypeMap.keySet()) {
            this._monitorMap.put(propertyType, new RoutingTableProviderMonitor(propertyType, clusterName));
            try {
                this._monitorMap.get((Object)propertyType).register();
            }
            catch (JMException e) {
                logger.error("Failed to register RoutingTableProvider monitor MBean.", (Throwable)e);
            }
        }
        this._reportExecutor = Executors.newSingleThreadExecutor();
        this._routerUpdater = new RouterUpdater(clusterName, sourceDataTypeMap);
        this._routerUpdater.start();
        this.addListeners();
        if (isPeriodicRefreshEnabled && this._helixManager != null) {
            this._lastRefreshTimestamp = System.currentTimeMillis();
            this._periodRefreshInterval = periodRefreshInterval;
            final NotificationContext periodicRefreshContext = new NotificationContext(this._helixManager);
            periodicRefreshContext.setType(NotificationContext.Type.PERIODIC_REFRESH);
            this._periodicRefreshExecutor = new ScheduledThreadPoolExecutor(1);
            this._periodicRefreshExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (RoutingTableProvider.this._lastRefreshTimestamp + RoutingTableProvider.this._periodRefreshInterval < System.currentTimeMillis()) {
                        RoutingTableProvider.this._routerUpdater.queueEvent(periodicRefreshContext, ClusterEventType.PeriodicalRebalance, null);
                    }
                }
            }, this._periodRefreshInterval, this._periodRefreshInterval, TimeUnit.MILLISECONDS);
        } else {
            this._isPeriodicRefreshEnabled = false;
        }
    }

    private void addListeners() {
        if (this._helixManager != null) {
            block16: for (PropertyType propertyType : this._sourceDataTypeMap.keySet()) {
                switch (propertyType) {
                    case EXTERNALVIEW: {
                        try {
                            this._helixManager.addExternalViewChangeListener(this);
                            break;
                        }
                        catch (Exception e) {
                            this.shutdown();
                            throw new HelixException("Failed to attach ExternalView Listener to HelixManager!", e);
                        }
                    }
                    case CUSTOMIZEDVIEW: {
                        try {
                            this._helixManager.addCustomizedViewRootChangeListener(this);
                        }
                        catch (Exception e) {
                            this.shutdown();
                            throw new HelixException("Failed to attach CustomizedView Root Listener to HelixManager!", e);
                        }
                        List<String> customizedStateTypes = this._sourceDataTypeMap.get((Object)propertyType);
                        for (String customizedStateType : customizedStateTypes) {
                            try {
                                this._helixManager.addCustomizedViewChangeListener(this, customizedStateType);
                            }
                            catch (Exception e) {
                                this.shutdown();
                                throw new HelixException(String.format("Failed to attach CustomizedView Listener to HelixManager for type %s!", customizedStateType), e);
                            }
                        }
                        continue block16;
                    }
                    case TARGETEXTERNALVIEW: {
                        if (!this._helixManager.getHelixDataAccessor().getBaseDataAccessor().exists(this._helixManager.getHelixDataAccessor().keyBuilder().targetExternalViews().getPath(), 0)) {
                            this.shutdown();
                            throw new HelixException("Target External View is not enabled!");
                        }
                        try {
                            this._helixManager.addTargetExternalViewChangeListener(this);
                            break;
                        }
                        catch (Exception e) {
                            this.shutdown();
                            throw new HelixException("Failed to attach TargetExternalView Listener to HelixManager!", e);
                        }
                    }
                    case CURRENTSTATES: {
                        break;
                    }
                    default: {
                        throw new HelixException(String.format("Unsupported source data type: %s", new Object[]{propertyType}));
                    }
                }
            }
            try {
                this._helixManager.addInstanceConfigChangeListener(this);
                this._helixManager.addLiveInstanceChangeListener(this);
            }
            catch (Exception e) {
                this.shutdown();
                throw new HelixException("Failed to attach InstanceConfig and LiveInstance Change listeners to HelixManager!", e);
            }
        }
    }

    private void validateSourceDataTypeMap(Map<PropertyType, List<String>> sourceDataTypeMap) {
        if (sourceDataTypeMap == null) {
            throw new IllegalArgumentException("The sourceDataTypeMap of Routing Table Provider should not be null");
        }
        for (PropertyType propertyType : sourceDataTypeMap.keySet()) {
            if (propertyType.equals((Object)PropertyType.CUSTOMIZEDVIEW) && sourceDataTypeMap.get((Object)propertyType).size() == 0) {
                logger.error("CustomizedView has been used without any aggregation type!");
                throw new HelixException("CustomizedView has been used without any aggregation type!");
            }
            if (propertyType.equals((Object)PropertyType.CUSTOMIZEDVIEW) || sourceDataTypeMap.get((Object)propertyType).size() == 0) continue;
            logger.error("Type has been used in addition to the propertyType {} !", (Object)propertyType.name());
            throw new HelixException(String.format("Type %s has been used in addition to the propertyType %s !", sourceDataTypeMap.get((Object)propertyType), propertyType.name()));
        }
    }

    public void shutdown() {
        if (this._periodicRefreshExecutor != null) {
            this._periodicRefreshExecutor.purge();
            this._periodicRefreshExecutor.shutdown();
        }
        this._routerUpdater.shutdown();
        for (PropertyType propertyType : this._monitorMap.keySet()) {
            this._monitorMap.get((Object)propertyType).unregister();
        }
        if (this._helixManager != null) {
            PropertyKey.Builder keyBuilder = this._helixManager.getHelixDataAccessor().keyBuilder();
            this._helixManager.removeListener(keyBuilder.liveInstances(), this);
            this._helixManager.removeListener(keyBuilder.instanceConfigs(), this);
            block7: for (PropertyType propertyType : this._sourceDataTypeMap.keySet()) {
                switch (propertyType) {
                    case EXTERNALVIEW: {
                        this._helixManager.removeListener(keyBuilder.externalViews(), this);
                        break;
                    }
                    case CUSTOMIZEDVIEW: {
                        List<String> customizedStateTypes = this._sourceDataTypeMap.get((Object)propertyType);
                        for (String customizedStateType : customizedStateTypes) {
                            this._helixManager.removeListener(keyBuilder.customizedView(customizedStateType), this);
                        }
                        continue block7;
                    }
                    case TARGETEXTERNALVIEW: {
                        this._helixManager.removeListener(keyBuilder.targetExternalViews(), this);
                        break;
                    }
                    case CURRENTSTATES: {
                        NotificationContext context = new NotificationContext(this._helixManager);
                        context.setType(NotificationContext.Type.FINALIZE);
                        this.updateCurrentStatesListeners(Collections.emptyList(), context);
                        break;
                    }
                }
            }
        }
    }

    public RoutingTableSnapshot getRoutingTableSnapshot() {
        return new RoutingTableSnapshot(this.getRoutingTableRef(DEFAULT_PROPERTY_TYPE, DEFAULT_STATE_TYPE));
    }

    public RoutingTableSnapshot getRoutingTableSnapshot(PropertyType propertyType) {
        return new RoutingTableSnapshot(this.getRoutingTableRef(propertyType.name(), DEFAULT_STATE_TYPE));
    }

    public RoutingTableSnapshot getRoutingTableSnapshot(PropertyType propertyType, String stateType) {
        return new RoutingTableSnapshot(this.getRoutingTableRef(propertyType.name(), stateType));
    }

    public Map<String, Map<String, RoutingTableSnapshot>> getRoutingTableSnapshots() {
        HashMap<String, Map<String, RoutingTableSnapshot>> snapshots = new HashMap<String, Map<String, RoutingTableSnapshot>>();
        for (String key : this._routingTableRefMap.keySet()) {
            RoutingTable routingTable = this._routingTableRefMap.get(key).get();
            String propertyTypeName = routingTable.getPropertyType().name();
            String customizedStateType = routingTable.getStateType();
            if (!snapshots.containsKey(propertyTypeName)) {
                snapshots.put(propertyTypeName, new HashMap());
            }
            ((Map)snapshots.get(propertyTypeName)).put(customizedStateType, new RoutingTableSnapshot(routingTable));
        }
        return snapshots;
    }

    public void addRoutingTableChangeListener(RoutingTableChangeListener routingTableChangeListener, Object context) {
        this.addRoutingTableChangeListener(routingTableChangeListener, context, false);
    }

    public void addRoutingTableChangeListener(RoutingTableChangeListener routingTableChangeListener, Object context, boolean isTriggerCallback) {
        this._routingTableChangeListenerMap.put(routingTableChangeListener, new ListenerContext(context));
        logger.info("Attach RoutingTableProviderChangeListener {}.", (Object)routingTableChangeListener.getClass().getName());
        if (isTriggerCallback) {
            logger.info("Force triggering a callback for the new listener in routing table provider");
            NotificationContext periodicRefreshContext = new NotificationContext(this._helixManager);
            periodicRefreshContext.setType(NotificationContext.Type.PERIODIC_REFRESH);
            this._routerUpdater.queueEvent(periodicRefreshContext, ClusterEventType.PeriodicalRebalance, null);
        }
    }

    public Object removeRoutingTableChangeListener(RoutingTableChangeListener routingTableChangeListener) {
        logger.info("Detach RoutingTableProviderChangeListener {}", (Object)routingTableChangeListener.getClass().getName());
        return this._routingTableChangeListenerMap.remove(routingTableChangeListener);
    }

    public List<InstanceConfig> getInstances(String resourceName, String partitionName, String state) {
        return this.getInstancesForResource(resourceName, partitionName, state);
    }

    public List<InstanceConfig> getInstancesForResource(String resourceName, String partitionName, String state) {
        return this.getRoutingTableRef(DEFAULT_PROPERTY_TYPE, DEFAULT_STATE_TYPE).getInstancesForResource(resourceName, partitionName, state);
    }

    public List<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String partitionName, String state) {
        return this.getRoutingTableRef(DEFAULT_PROPERTY_TYPE, DEFAULT_STATE_TYPE).getInstancesForResourceGroup(resourceGroupName, partitionName, state);
    }

    public List<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String partitionName, String state, List<String> resourceTags) {
        return this.getRoutingTableRef(DEFAULT_PROPERTY_TYPE, DEFAULT_STATE_TYPE).getInstancesForResourceGroup(resourceGroupName, partitionName, state, resourceTags);
    }

    public Set<InstanceConfig> getInstances(String resourceName, String state) {
        return this.getInstancesForResource(resourceName, state);
    }

    public Set<InstanceConfig> getInstancesForResource(String resourceName, String state) {
        return this.getRoutingTableRef(DEFAULT_PROPERTY_TYPE, DEFAULT_STATE_TYPE).getInstancesForResource(resourceName, state);
    }

    public Set<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String state) {
        return this.getRoutingTableRef(DEFAULT_PROPERTY_TYPE, DEFAULT_STATE_TYPE).getInstancesForResourceGroup(resourceGroupName, state);
    }

    public Set<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String state, List<String> resourceTags) {
        return this.getRoutingTableRef(DEFAULT_PROPERTY_TYPE, DEFAULT_STATE_TYPE).getInstancesForResourceGroup(resourceGroupName, state, resourceTags);
    }

    public Collection<LiveInstance> getLiveInstances() {
        return this._routingTableRefMap.values().iterator().next().get().getLiveInstances();
    }

    public Collection<InstanceConfig> getInstanceConfigs() {
        return this._routingTableRefMap.values().iterator().next().get().getInstanceConfigs();
    }

    public Collection<String> getResources() {
        return this.getRoutingTableRef(DEFAULT_PROPERTY_TYPE, DEFAULT_STATE_TYPE).getResources();
    }

    private RoutingTable getRoutingTableRef(String propertyTypeName, String stateType) {
        if (propertyTypeName.equals(DEFAULT_PROPERTY_TYPE)) {
            if (this._routingTableRefMap.keySet().size() == 1) {
                String key = this._routingTableRefMap.keySet().iterator().next();
                if (!this._routingTableRefMap.containsKey(key)) {
                    throw new HelixException(String.format("Currently there is no snapshot available for PropertyType %s and stateType %s", propertyTypeName, stateType));
                }
                return this._routingTableRefMap.get(key).get();
            }
            throw new HelixException("There is none or more than one RoutingTableSnapshot");
        }
        if (stateType.equals(DEFAULT_STATE_TYPE) && propertyTypeName.equals(PropertyType.CUSTOMIZEDVIEW.name())) {
            throw new HelixException("Specific type needs to be used for CUSTOMIZEDVIEW PropertyType");
        }
        String key = this.generateReferenceKey(propertyTypeName, stateType);
        if (!this._routingTableRefMap.containsKey(key)) {
            throw new HelixException(String.format("Currently there is no snapshot available for PropertyType %s and stateType %s", propertyTypeName, stateType));
        }
        return this._routingTableRefMap.get(key).get();
    }

    private String generateReferenceKey(String propertyType, String stateType) {
        return propertyType + "_" + stateType;
    }

    @Override
    @PreFetch(enabled=false)
    public void onExternalViewChange(List<ExternalView> externalViewList, NotificationContext changeContext) {
        HelixConstants.ChangeType changeType = changeContext.getChangeType();
        if (changeType != null && !this._sourceDataTypeMap.containsKey((Object)changeType.getPropertyType())) {
            logger.warn("onExternalViewChange called with mismatched change types. Source data types does not contain changed data type: {}", (Object)changeType);
            return;
        }
        if (externalViewList != null && externalViewList.size() > 0) {
            String keyReference = this.generateReferenceKey(PropertyType.EXTERNALVIEW.name(), DEFAULT_STATE_TYPE);
            HelixDataAccessor accessor = changeContext.getManager().getHelixDataAccessor();
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            List<InstanceConfig> configList = accessor.getChildValues(keyBuilder.instanceConfigs(), true);
            List<LiveInstance> liveInstances = accessor.getChildValues(keyBuilder.liveInstances(), true);
            this.refreshExternalView(externalViewList, configList, liveInstances, keyReference);
        } else {
            ClusterEventType eventType;
            if (this._sourceDataTypeMap.containsKey((Object)PropertyType.EXTERNALVIEW)) {
                eventType = ClusterEventType.ExternalViewChange;
            } else if (this._sourceDataTypeMap.containsKey((Object)PropertyType.TARGETEXTERNALVIEW)) {
                eventType = ClusterEventType.TargetExternalViewChange;
            } else {
                logger.warn("onExternalViewChange called with mismatched change types. Source data types does not contain changed data type: {}", (Object)changeType);
                return;
            }
            this._routerUpdater.queueEvent(changeContext, eventType, changeType);
        }
    }

    @Override
    @PreFetch(enabled=false)
    public void onInstanceConfigChange(List<InstanceConfig> configs, NotificationContext changeContext) {
        this._routerUpdater.queueEvent(changeContext, ClusterEventType.InstanceConfigChange, HelixConstants.ChangeType.INSTANCE_CONFIG);
    }

    @Override
    @PreFetch(enabled=false)
    public void onConfigChange(List<InstanceConfig> configs, NotificationContext changeContext) {
        this.onInstanceConfigChange(configs, changeContext);
    }

    @Override
    @PreFetch(enabled=true)
    public void onLiveInstanceChange(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        if (this._sourceDataTypeMap.containsKey((Object)PropertyType.CURRENTSTATES)) {
            this.updateCurrentStatesListeners(liveInstances, changeContext);
        }
        this._routerUpdater.queueEvent(changeContext, ClusterEventType.LiveInstanceChange, HelixConstants.ChangeType.LIVE_INSTANCE);
    }

    @Override
    @PreFetch(enabled=false)
    public void onStateChange(String instanceName, List<CurrentState> statesInfo, NotificationContext changeContext) {
        if (this._sourceDataTypeMap.containsKey((Object)PropertyType.CURRENTSTATES)) {
            this._routerUpdater.queueEvent(changeContext, ClusterEventType.CurrentStateChange, HelixConstants.ChangeType.CURRENT_STATE);
        } else {
            logger.warn("RoutingTableProvider does not use CurrentStates as source, ignore CurrentState changes!");
        }
    }

    @Override
    @PreFetch(enabled=false)
    public void onCustomizedViewChange(List<CustomizedView> customizedViewList, NotificationContext changeContext) {
        if (this._sourceDataTypeMap.containsKey((Object)PropertyType.CUSTOMIZEDVIEW)) {
            this._routerUpdater.queueEvent(changeContext, ClusterEventType.CustomizedViewChange, HelixConstants.ChangeType.CUSTOMIZED_VIEW);
        } else {
            logger.warn("RoutingTableProvider does not use CurrentStates as source, ignore CurrentState changes!");
        }
    }

    @Override
    @PreFetch(enabled=false)
    public void onCustomizedViewRootChange(List<String> customizedViewTypes, NotificationContext changeContext) {
        logger.info("Registering the CustomizedView listeners again due to the CustomizedView root change.");
        List userRequestedTypes = this._sourceDataTypeMap.getOrDefault((Object)PropertyType.CUSTOMIZEDVIEW, Collections.emptyList());
        for (String customizedStateType : userRequestedTypes) {
            try {
                this._helixManager.addCustomizedViewChangeListener(this, customizedStateType);
            }
            catch (Exception e) {
                this.shutdown();
                throw new HelixException(String.format("Failed to attach CustomizedView Listener to HelixManager for type %s!", customizedStateType), e);
            }
        }
    }

    private void updateCurrentStatesListeners(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        HelixManager manager = changeContext.getManager();
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(manager.getClusterName());
        if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
            logger.info("remove current-state listeners. lastSeenSessions: {}", this._lastSeenSessions.get());
            liveInstances = Collections.emptyList();
        }
        Map curSessions = liveInstances.stream().collect(Collectors.toConcurrentMap(LiveInstance::getEphemeralOwner, liveInstance -> liveInstance));
        for (String session : curSessions.keySet()) {
            String instanceName = ((LiveInstance)curSessions.get(session)).getInstanceName();
            try {
                manager.addCurrentStateChangeListener(this, instanceName, session);
                logger.info("{} added current-state listener for instance: {}, session: {}, listener: {}", new Object[]{manager.getInstanceName(), instanceName, session, this});
            }
            catch (Exception e) {
                logger.error("Fail to add current state listener for instance: {} with session: {}", new Object[]{instanceName, session, e});
            }
        }
        Map<String, LiveInstance> lastSessions = this._lastSeenSessions.getAndSet(curSessions);
        if (lastSessions == null) {
            lastSessions = Collections.emptyMap();
        }
        for (String session : lastSessions.keySet()) {
            if (curSessions.containsKey(session)) continue;
            String instanceName = lastSessions.get(session).getInstanceName();
            try {
                manager.removeListener(keyBuilder.currentStates(instanceName, session), this);
                logger.info("remove current-state listener for instance: {}, session: {}", (Object)instanceName, (Object)session);
            }
            catch (Exception e) {
                logger.error("Fail to remove current state listener for instance: {} with session: {}", new Object[]{instanceName, session, e});
            }
        }
    }

    private void reset() {
        logger.info("Resetting the routing table.");
        for (String key : this._routingTableRefMap.keySet()) {
            RoutingTable newRoutingTable;
            PropertyType propertyType = this._routingTableRefMap.get(key).get().getPropertyType();
            if (propertyType == PropertyType.CUSTOMIZEDVIEW) {
                String stateType = this._routingTableRefMap.get(key).get().getStateType();
                newRoutingTable = new CustomizedViewRoutingTable(propertyType, stateType);
            } else {
                newRoutingTable = new RoutingTable(propertyType);
            }
            this._routingTableRefMap.get(key).set(newRoutingTable);
        }
    }

    protected void refreshExternalView(Collection<ExternalView> externalViews, Collection<InstanceConfig> instanceConfigs, Collection<LiveInstance> liveInstances, String referenceKey) {
        long startTime = System.currentTimeMillis();
        PropertyType propertyType = this._routingTableRefMap.get(referenceKey).get().getPropertyType();
        RoutingTable newRoutingTable = new RoutingTable(externalViews, instanceConfigs, liveInstances, propertyType);
        this.resetRoutingTableAndNotify(startTime, newRoutingTable, referenceKey);
    }

    protected void refreshCustomizedView(Collection<CustomizedView> customizedViews, Collection<InstanceConfig> instanceConfigs, Collection<LiveInstance> liveInstances, String referenceKey) {
        long startTime = System.currentTimeMillis();
        PropertyType propertyType = this._routingTableRefMap.get(referenceKey).get().getPropertyType();
        String customizedStateType = this._routingTableRefMap.get(referenceKey).get().getStateType();
        CustomizedViewRoutingTable newRoutingTable = new CustomizedViewRoutingTable(customizedViews, instanceConfigs, liveInstances, propertyType, customizedStateType);
        this.resetRoutingTableAndNotify(startTime, newRoutingTable, referenceKey);
    }

    protected void refreshCurrentState(Map<String, Map<String, Map<String, CurrentState>>> currentStateMap, Collection<InstanceConfig> instanceConfigs, Collection<LiveInstance> liveInstances, String referenceKey) {
        long startTime = System.currentTimeMillis();
        RoutingTable newRoutingTable = new RoutingTable(currentStateMap, instanceConfigs, liveInstances);
        this.resetRoutingTableAndNotify(startTime, newRoutingTable, referenceKey);
    }

    private void resetRoutingTableAndNotify(long startTime, RoutingTable newRoutingTable, String referenceKey) {
        this._routingTableRefMap.get(referenceKey).set(newRoutingTable);
        String clusterName = this._helixManager != null ? this._helixManager.getClusterName() : null;
        logger.info("Refreshed the RoutingTable for cluster {}, took {} ms.", (Object)clusterName, (Object)(System.currentTimeMillis() - startTime));
        this.notifyRoutingTableChange(clusterName, referenceKey);
        if (this._isPeriodicRefreshEnabled) {
            this._lastRefreshTimestamp = System.currentTimeMillis();
        }
    }

    private void notifyRoutingTableChange(String clusterName, String referenceKey) {
        long startTime = System.currentTimeMillis();
        for (Map.Entry<RoutingTableChangeListener, ListenerContext> entry : this._routingTableChangeListenerMap.entrySet()) {
            entry.getKey().onRoutingTableChange(new RoutingTableSnapshot(this._routingTableRefMap.get(referenceKey).get()), entry.getValue().getContext());
        }
        logger.info("RoutingTableProvider user callback time for cluster {}, took {} ms.", (Object)clusterName, (Object)(System.currentTimeMillis() - startTime));
    }

    protected class ListenerContext {
        private Object _context;

        public ListenerContext(Object context) {
            this._context = context;
        }

        public Object getContext() {
            return this._context;
        }
    }

    private class RouterUpdater
    extends ClusterEventProcessor {
        private final RoutingDataCache _dataCache;
        private final Map<PropertyType, List<String>> _sourceDataTypeMap;

        public RouterUpdater(String clusterName, Map<PropertyType, List<String>> sourceDataTypeMap) {
            super(clusterName, "Helix-RouterUpdater-event_process");
            this._sourceDataTypeMap = sourceDataTypeMap;
            this._dataCache = new RoutingDataCache(clusterName, this._sourceDataTypeMap);
        }

        @Override
        protected void handleEvent(ClusterEvent event) {
            NotificationContext changeContext = (NotificationContext)event.getAttribute(AttributeName.changeContext.name());
            HelixConstants.ChangeType changeType = changeContext.getChangeType();
            this._dataCache.setClusterEventId(event.getEventId());
            if (changeContext == null || changeContext.getType() != NotificationContext.Type.CALLBACK) {
                this._dataCache.requireFullRefresh();
            } else {
                this._dataCache.notifyDataChange(changeType, changeContext.getPathChanged());
            }
            if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
                RoutingTableProvider.this.reset();
            } else {
                HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
                if (manager == null) {
                    logger.error(String.format("HelixManager is null for router update event: %s", event));
                    throw new HelixException("HelixManager is null for router update event.");
                }
                if (!manager.isConnected()) {
                    logger.error(String.format("HelixManager is not connected for router update event: %s", event));
                    throw new HelixException("HelixManager is not connected for router update event.");
                }
                long startTime = System.currentTimeMillis();
                this._dataCache.refresh(manager.getHelixDataAccessor());
                for (PropertyType propertyType : this._sourceDataTypeMap.keySet()) {
                    switch (propertyType) {
                        case EXTERNALVIEW: {
                            Object keyReference = RoutingTableProvider.this.generateReferenceKey(propertyType.name(), RoutingTableProvider.DEFAULT_STATE_TYPE);
                            RoutingTableProvider.this.refreshExternalView(this._dataCache.getExternalViews().values(), this._dataCache.getRoutableInstanceConfigMap().values(), this._dataCache.getRoutableLiveInstances().values(), (String)keyReference);
                            break;
                        }
                        case TARGETEXTERNALVIEW: {
                            Object keyReference = RoutingTableProvider.this.generateReferenceKey(propertyType.name(), RoutingTableProvider.DEFAULT_STATE_TYPE);
                            RoutingTableProvider.this.refreshExternalView(this._dataCache.getTargetExternalViews().values(), this._dataCache.getRoutableInstanceConfigMap().values(), this._dataCache.getRoutableLiveInstances().values(), (String)keyReference);
                            break;
                        }
                        case CUSTOMIZEDVIEW: {
                            for (String customizedStateType : this._sourceDataTypeMap.getOrDefault((Object)PropertyType.CUSTOMIZEDVIEW, Collections.emptyList())) {
                                String keyReference = RoutingTableProvider.this.generateReferenceKey(propertyType.name(), customizedStateType);
                                RoutingTableProvider.this.refreshCustomizedView(this._dataCache.getCustomizedView(customizedStateType).values(), this._dataCache.getRoutableInstanceConfigMap().values(), this._dataCache.getRoutableLiveInstances().values(), keyReference);
                            }
                            break;
                        }
                        case CURRENTSTATES: {
                            Object keyReference = RoutingTableProvider.this.generateReferenceKey(propertyType.name(), RoutingTableProvider.DEFAULT_STATE_TYPE);
                            RoutingTableProvider.this.refreshCurrentState(this._dataCache.getCurrentStatesMap(), this._dataCache.getRoutableInstanceConfigMap().values(), this._dataCache.getRoutableLiveInstances().values(), (String)keyReference);
                            this.recordPropagationLatency(System.currentTimeMillis(), this._dataCache.getCurrentStateSnapshot());
                            break;
                        }
                        default: {
                            logger.warn("Unsupported source data type: {}, stop refreshing the routing table!", (Object)propertyType);
                        }
                    }
                    RoutingTableProvider.this._monitorMap.get((Object)propertyType).increaseDataRefreshCounters(startTime);
                }
            }
        }

        private void recordPropagationLatency(final long currentTime, final CurrentStateSnapshot currentStateSnapshot) {
            if (RoutingTableProvider.this._reportingTask == null || RoutingTableProvider.this._reportingTask.isDone()) {
                RoutingTableProvider.this._reportingTask = RoutingTableProvider.this._reportExecutor.submit(new Callable<Object>(){

                    @Override
                    public Object call() {
                        Map<PropertyKey, Map<String, Long>> currentStateEndTimeMap = currentStateSnapshot.getNewCurrentStateEndTimes();
                        for (PropertyKey key : currentStateEndTimeMap.keySet()) {
                            Map<String, Long> partitionStateEndTimes = currentStateEndTimeMap.get(key);
                            for (String partition : partitionStateEndTimes.keySet()) {
                                long endTime = partitionStateEndTimes.get(partition);
                                if (currentTime >= endTime) {
                                    for (PropertyType propertyType : RouterUpdater.this._sourceDataTypeMap.keySet()) {
                                        RoutingTableProvider.this._monitorMap.get((Object)propertyType).recordStatePropagationLatency(currentTime - endTime);
                                        logger.debug("CurrentState updated in the routing table. Node Key {}, Partition {}, end time {}, Propagation latency {}", new Object[]{key.toString(), partition, endTime, currentTime - endTime});
                                    }
                                    continue;
                                }
                                logger.trace("CurrentState updated in the routing table. Node Key {}, Partition {}, end time {}, Propagation latency {}", new Object[]{key.toString(), partition, endTime, currentTime - endTime});
                            }
                        }
                        return null;
                    }
                });
            }
        }

        public void queueEvent(NotificationContext context, ClusterEventType eventType, HelixConstants.ChangeType changeType) {
            ClusterEvent event = new ClusterEvent(this._clusterName, eventType);
            event.addAttribute(AttributeName.helixmanager.name(), context.getManager());
            event.addAttribute(AttributeName.changeContext.name(), context);
            this.queueEvent(event);
            for (PropertyType propertyType : RoutingTableProvider.this._monitorMap.keySet()) {
                RoutingTableProvider.this._monitorMap.get((Object)propertyType).increaseCallbackCounters(this._eventQueue.size());
            }
        }
    }
}

