/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.spectator;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyType;
import org.apache.helix.common.caches.BasicClusterDataCache;
import org.apache.helix.common.caches.CurrentStateCache;
import org.apache.helix.common.caches.CurrentStateSnapshot;
import org.apache.helix.common.caches.CustomizedViewCache;
import org.apache.helix.common.caches.TargetExternalViewCache;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.CustomizedView;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoutingDataCache
extends BasicClusterDataCache {
    private static Logger LOG = LoggerFactory.getLogger((String)RoutingDataCache.class.getName());
    private final Map<PropertyType, List<String>> _sourceDataTypeMap;
    private CurrentStateCache _currentStateCache;
    private Map<String, CustomizedViewCache> _customizedViewCaches;
    private TargetExternalViewCache _targetExternalViewCache;
    private Map<String, LiveInstance> _routableLiveInstanceMap;
    private Map<String, InstanceConfig> _routableInstanceConfigMap;

    public RoutingDataCache(String clusterName, PropertyType sourceDataType) {
        this(clusterName, (Map<PropertyType, List<String>>)ImmutableMap.of((Object)((Object)sourceDataType), Collections.emptyList()));
    }

    public RoutingDataCache(String clusterName, Map<PropertyType, List<String>> sourceDataTypeMap) {
        super(clusterName);
        this._sourceDataTypeMap = sourceDataTypeMap;
        this._currentStateCache = new CurrentStateCache(clusterName);
        this._customizedViewCaches = new HashMap<String, CustomizedViewCache>();
        sourceDataTypeMap.getOrDefault((Object)PropertyType.CUSTOMIZEDVIEW, Collections.emptyList()).forEach(customizedStateType -> this._customizedViewCaches.put((String)customizedStateType, new CustomizedViewCache(clusterName, (String)customizedStateType)));
        this._targetExternalViewCache = new TargetExternalViewCache(clusterName);
        this._routableInstanceConfigMap = new HashMap<String, InstanceConfig>();
        this._routableLiveInstanceMap = new HashMap<String, LiveInstance>();
        this.requireFullRefresh();
    }

    @Override
    public synchronized void refresh(HelixDataAccessor accessor) {
        LOG.info("START: RoutingDataCache.refresh() for cluster " + this._clusterName);
        long startTime = System.currentTimeMillis();
        boolean refreshRoutableInstanceConfigs = this._propertyDataChangedMap.getOrDefault((Object)HelixConstants.ChangeType.INSTANCE_CONFIG, false);
        boolean refreshRoutableLiveInstances = this._propertyDataChangedMap.getOrDefault((Object)HelixConstants.ChangeType.LIVE_INSTANCE, false) != false || refreshRoutableInstanceConfigs;
        super.refresh(accessor);
        if (refreshRoutableInstanceConfigs) {
            this.updateRoutableInstanceConfigMap(this._instanceConfigPropertyCache.getPropertyMap());
        }
        if (refreshRoutableLiveInstances) {
            this.updateRoutableLiveInstanceMap(this.getRoutableInstanceConfigMap(), this._liveInstancePropertyCache.getPropertyMap());
        }
        for (PropertyType propertyType : this._sourceDataTypeMap.keySet()) {
            long start = System.currentTimeMillis();
            switch (propertyType) {
                case TARGETEXTERNALVIEW: {
                    if (!((Boolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW)).booleanValue()) break;
                    this._propertyDataChangedMap.put(HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW, false);
                    this._targetExternalViewCache.refresh(accessor);
                    LOG.info("Reload " + this._targetExternalViewCache.getExternalViewMap().keySet().size() + " TargetExternalViews. Takes " + (System.currentTimeMillis() - start) + " ms");
                    break;
                }
                case CURRENTSTATES: {
                    if (!((Boolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CURRENT_STATE)).booleanValue()) break;
                    this._propertyDataChangedMap.put(HelixConstants.ChangeType.CURRENT_STATE, false);
                    this._liveInstancePropertyCache.refresh(accessor);
                    this.updateRoutableLiveInstanceMap(this.getRoutableInstanceConfigMap(), this._liveInstancePropertyCache.getPropertyMap());
                    Map<String, LiveInstance> liveInstanceMap = this.getRoutableLiveInstances();
                    this._currentStateCache.refresh(accessor, liveInstanceMap);
                    LOG.info("Reload CurrentStates. Takes " + (System.currentTimeMillis() - start) + " ms");
                    break;
                }
                case CUSTOMIZEDVIEW: {
                    if (((Boolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CUSTOMIZED_VIEW)).booleanValue()) {
                        for (String customizedStateType : this._sourceDataTypeMap.get((Object)PropertyType.CUSTOMIZEDVIEW)) {
                            this._customizedViewCaches.get(customizedStateType).refresh(accessor);
                        }
                        LOG.info("Reload CustomizedView for types " + this._sourceDataTypeMap.get((Object)PropertyType.CUSTOMIZEDVIEW) + " Takes " + (System.currentTimeMillis() - start) + " ms");
                    }
                    this._propertyDataChangedMap.put(HelixConstants.ChangeType.CUSTOMIZED_VIEW, false);
                    break;
                }
            }
        }
        long endTime = System.currentTimeMillis();
        LOG.info("END: RoutingDataCache.refresh() for cluster " + this._clusterName + ", took " + (endTime - startTime) + " ms");
        LOG.debug("CurrentStates: {}", (Object)this._currentStateCache);
        LOG.debug("TargetExternalViews: {}", this._targetExternalViewCache.getExternalViewMap());
        if (LOG.isDebugEnabled()) {
            for (String customizedStateType : this._sourceDataTypeMap.getOrDefault((Object)PropertyType.CUSTOMIZEDVIEW, Collections.emptyList())) {
                LOG.debug("CustomizedViews customizedStateType: {} {}", (Object)customizedStateType, this._customizedViewCaches.get(customizedStateType).getCustomizedViewMap());
            }
        }
    }

    private void updateRoutableInstanceConfigMap(Map<String, InstanceConfig> instanceConfigMap) {
        this._routableInstanceConfigMap = instanceConfigMap.entrySet().stream().filter(instanceConfigEntry -> !InstanceConstants.UNROUTABLE_INSTANCE_OPERATIONS.contains((Object)((InstanceConfig)instanceConfigEntry.getValue()).getInstanceOperation().getOperation())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void updateRoutableLiveInstanceMap(Map<String, InstanceConfig> instanceConfigMap, Map<String, LiveInstance> liveInstanceMap) {
        this._routableLiveInstanceMap = liveInstanceMap.entrySet().stream().filter(liveInstanceEntry -> instanceConfigMap.containsKey(liveInstanceEntry.getKey()) && !InstanceConstants.UNROUTABLE_INSTANCE_OPERATIONS.contains((Object)((InstanceConfig)instanceConfigMap.get(liveInstanceEntry.getKey())).getInstanceOperation().getOperation())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, LiveInstance> getRoutableLiveInstances() {
        return Collections.unmodifiableMap(this._routableLiveInstanceMap);
    }

    public Map<String, InstanceConfig> getRoutableInstanceConfigMap() {
        return Collections.unmodifiableMap(this._routableInstanceConfigMap);
    }

    public Map<String, ExternalView> getTargetExternalViews() {
        return this._targetExternalViewCache.getExternalViewMap();
    }

    public Map<String, CustomizedView> getCustomizedView(String customizedStateType) {
        if (this._customizedViewCaches.containsKey(customizedStateType)) {
            return this._customizedViewCaches.get(customizedStateType).getCustomizedViewMap();
        }
        throw new HelixException(String.format("customizedStateType %s does not exist in customizedViewCaches.", customizedStateType));
    }

    public Map<String, Map<String, Map<String, CurrentState>>> getCurrentStatesMap() {
        return this._currentStateCache.getParticipantStatesMap();
    }

    public CurrentStateSnapshot getCurrentStateSnapshot() {
        return this._currentStateCache.getSnapshot();
    }
}

