/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.metadatastore.accessor;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.helix.rest.common.HttpConstants;
import org.apache.helix.rest.metadatastore.ZkMetadataStoreDirectory;
import org.apache.helix.rest.metadatastore.accessor.MetadataStoreRoutingDataWriter;
import org.apache.helix.rest.metadatastore.concurrency.ZkDistributedLeaderElection;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkRoutingDataWriter
implements MetadataStoreRoutingDataWriter {
    private static final int HTTP_REQUEST_FORWARDING_TIMEOUT = 60000;
    private static final Logger LOG = LoggerFactory.getLogger(ZkRoutingDataWriter.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String SIMPLE_FIELD_KEY_HOSTNAME = "hostname";
    private static final String SIMPLE_FIELD_KEY_PORT = "port";
    private static final String SIMPLE_FIELD_KEY_CONTEXT_URL_PREFIX = "contextUrlPrefix";
    private final String _namespace;
    private final HelixZkClient _zkClient;
    private final ZkDistributedLeaderElection _leaderElection;
    private final CloseableHttpClient _forwardHttpClient;
    private final String _myHostName;

    public ZkRoutingDataWriter(String namespace, String zkAddress) {
        String contextUrlPrefix;
        if (namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException("namespace cannot be null or empty!");
        }
        this._namespace = namespace;
        if (zkAddress == null || zkAddress.isEmpty()) {
            throw new IllegalArgumentException("Zk address cannot be null or empty!");
        }
        this._zkClient = DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress), new HelixZkClient.ZkClientConfig().setZkSerializer((ZkSerializer)new ZNRecordSerializer()));
        ZkMetadataStoreDirectory.createRoutingDataPath(this._zkClient, zkAddress);
        String hostName = System.getProperty("msds_hostname");
        if (hostName == null || hostName.isEmpty()) {
            String errMsg = "ZkRoutingDataWriter: Hostname is not set or is empty. System.getProperty fails to fetch msds_hostname";
            LOG.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        this._myHostName = "http://" + hostName;
        ZNRecord myServerInfo = new ZNRecord(hostName);
        myServerInfo.setSimpleField(SIMPLE_FIELD_KEY_HOSTNAME, hostName);
        String port = System.getProperty("msds_port");
        if (port != null && !port.isEmpty()) {
            myServerInfo.setSimpleField(SIMPLE_FIELD_KEY_PORT, port);
        }
        if ((contextUrlPrefix = System.getProperty("msds_context_url_prefix")) != null && !contextUrlPrefix.isEmpty()) {
            myServerInfo.setSimpleField(SIMPLE_FIELD_KEY_CONTEXT_URL_PREFIX, contextUrlPrefix);
        }
        this._leaderElection = new ZkDistributedLeaderElection(this._zkClient, "/_ZK_ROUTING_DATA_WRITER_LEADER", myServerInfo);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
        this._forwardHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public static String buildEndpointFromLeaderElectionNode(ZNRecord znRecord) {
        String contextUrlPrefix;
        ArrayList<String> urlComponents = new ArrayList<String>(Collections.singletonList("http://"));
        urlComponents.add(znRecord.getSimpleField(SIMPLE_FIELD_KEY_HOSTNAME));
        String port = znRecord.getSimpleField(SIMPLE_FIELD_KEY_PORT);
        if (port != null && !port.isEmpty()) {
            urlComponents.add(":");
            urlComponents.add(port);
        }
        if ((contextUrlPrefix = znRecord.getSimpleField(SIMPLE_FIELD_KEY_CONTEXT_URL_PREFIX)) != null && !contextUrlPrefix.isEmpty()) {
            urlComponents.add(contextUrlPrefix);
        }
        return String.join((CharSequence)"", urlComponents);
    }

    @Override
    public synchronized boolean addMetadataStoreRealm(String realm) {
        if (this._leaderElection.isLeader()) {
            if (this._zkClient.isClosed()) {
                throw new IllegalStateException("ZkClient is closed!");
            }
            return this.createZkRealm(realm);
        }
        String urlSuffix = this.constructUrlSuffix("/metadata-store-realms", realm);
        return this.buildAndSendRequestToLeader(urlSuffix, HttpConstants.RestVerbs.PUT, Response.Status.CREATED.getStatusCode());
    }

    @Override
    public synchronized boolean deleteMetadataStoreRealm(String realm) {
        if (this._leaderElection.isLeader()) {
            if (this._zkClient.isClosed()) {
                throw new IllegalStateException("ZkClient is closed!");
            }
            return this.deleteZkRealm(realm);
        }
        String urlSuffix = this.constructUrlSuffix("/metadata-store-realms", realm);
        return this.buildAndSendRequestToLeader(urlSuffix, HttpConstants.RestVerbs.DELETE, Response.Status.OK.getStatusCode());
    }

    @Override
    public synchronized boolean addShardingKey(String realm, String shardingKey) {
        if (this._leaderElection.isLeader()) {
            if (this._zkClient.isClosed()) {
                throw new IllegalStateException("ZkClient is closed!");
            }
            return this.createZkShardingKey(realm, shardingKey);
        }
        String urlSuffix = this.constructUrlSuffix("/metadata-store-realms", realm, "/sharding-keys", shardingKey);
        return this.buildAndSendRequestToLeader(urlSuffix, HttpConstants.RestVerbs.PUT, Response.Status.CREATED.getStatusCode());
    }

    @Override
    public synchronized boolean deleteShardingKey(String realm, String shardingKey) {
        if (this._leaderElection.isLeader()) {
            if (this._zkClient.isClosed()) {
                throw new IllegalStateException("ZkClient is closed!");
            }
            return this.deleteZkShardingKey(realm, shardingKey);
        }
        String urlSuffix = this.constructUrlSuffix("/metadata-store-realms", realm, "/sharding-keys", shardingKey);
        return this.buildAndSendRequestToLeader(urlSuffix, HttpConstants.RestVerbs.DELETE, Response.Status.OK.getStatusCode());
    }

    @Override
    public synchronized boolean setRoutingData(Map<String, List<String>> routingData) {
        String routingDataJsonString;
        if (this._leaderElection.isLeader()) {
            if (this._zkClient.isClosed()) {
                throw new IllegalStateException("ZkClient is closed!");
            }
            if (routingData == null) {
                throw new IllegalArgumentException("routingData given is null!");
            }
            for (String string : this._zkClient.getChildren("/METADATA_STORE_ROUTING_DATA")) {
                if (this._zkClient.delete("/METADATA_STORE_ROUTING_DATA/" + string)) continue;
                LOG.error("Failed to delete existing routing data in setRoutingData()! Namespace: {}, Realm: {}", (Object)this._namespace, (Object)string);
                return false;
            }
            for (Map.Entry entry : routingData.entrySet()) {
                String zkRealm = (String)entry.getKey();
                List shardingKeyList = (List)entry.getValue();
                ZNRecord znRecord = new ZNRecord(zkRealm);
                znRecord.setListField("ZK_PATH_SHARDING_KEYS", shardingKeyList);
                String realmPath = "/METADATA_STORE_ROUTING_DATA/" + zkRealm;
                try {
                    if (!this._zkClient.exists(realmPath)) {
                        this._zkClient.createPersistent(realmPath);
                    }
                    this._zkClient.writeData(realmPath, (Object)znRecord);
                }
                catch (Exception e) {
                    LOG.error("Failed to write data in setRoutingData()! Namespace: {}, Realm: {}", new Object[]{this._namespace, zkRealm, e});
                    return false;
                }
            }
            return true;
        }
        String url = ZkRoutingDataWriter.buildEndpointFromLeaderElectionNode(this._leaderElection.getCurrentLeaderInfo()) + this.constructUrlSuffix("/routing-data");
        HttpPut httpPut = new HttpPut(url);
        try {
            routingDataJsonString = OBJECT_MAPPER.writeValueAsString(routingData);
        }
        catch (JsonGenerationException | JsonMappingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IOException e) {
            LOG.error("setRoutingData failed before forwarding the request to leader: an exception happened while routingData is converted to json. routingData: {}", routingData, (Object)e);
            return false;
        }
        httpPut.setEntity((HttpEntity)new StringEntity(routingDataJsonString, ContentType.APPLICATION_JSON));
        return this.sendRequestToLeader((HttpUriRequest)httpPut, Response.Status.CREATED.getStatusCode());
    }

    @Override
    public synchronized void close() {
        this._zkClient.close();
        try {
            this._forwardHttpClient.close();
        }
        catch (IOException e) {
            LOG.error("HttpClient failed to close. ", (Throwable)e);
        }
    }

    protected boolean createZkRealm(String realm) {
        if (this._zkClient.exists("/METADATA_STORE_ROUTING_DATA/" + realm)) {
            LOG.warn("createZkRealm() called for realm: {}, but this realm already exists! Namespace: {}", (Object)realm, (Object)this._namespace);
            return true;
        }
        try {
            this._zkClient.createPersistent("/METADATA_STORE_ROUTING_DATA/" + realm);
            this._zkClient.writeData("/METADATA_STORE_ROUTING_DATA/" + realm, (Object)new ZNRecord(realm));
        }
        catch (Exception e) {
            LOG.error("Failed to create ZkRealm: {}, Namespace: {}", new Object[]{realm, this._namespace, e});
            return false;
        }
        return true;
    }

    protected boolean deleteZkRealm(String realm) {
        if (!this._zkClient.exists("/METADATA_STORE_ROUTING_DATA/" + realm)) {
            LOG.warn("deleteZkRealm() called for realm: {}, but this realm already doesn't exist! Namespace: {}", (Object)realm, (Object)this._namespace);
            return true;
        }
        return this._zkClient.delete("/METADATA_STORE_ROUTING_DATA/" + realm);
    }

    protected boolean createZkShardingKey(String realm, String shardingKey) {
        ZNRecord znRecord;
        String realmPath = "/METADATA_STORE_ROUTING_DATA/" + realm;
        if (!this._zkClient.exists(realmPath) && !this.createZkRealm(realm)) {
            LOG.error("Failed to add sharding key because ZkRealm creation failed! Namespace: {}, Realm: {}, Sharding key: {}", new Object[]{this._namespace, realm, shardingKey});
            return false;
        }
        try {
            znRecord = (ZNRecord)this._zkClient.readData(realmPath);
        }
        catch (Exception e) {
            LOG.error("Failed to read the realm ZNRecord in addShardingKey()! Namespace: {}, Realm: {}, ShardingKey: {}", new Object[]{this._namespace, realm, shardingKey, e});
            return false;
        }
        ArrayList<String> shardingKeys = znRecord.getListField("ZK_PATH_SHARDING_KEYS");
        if (shardingKeys == null || shardingKeys.isEmpty()) {
            shardingKeys = new ArrayList<String>();
        }
        shardingKeys.add(shardingKey);
        znRecord.setListField("ZK_PATH_SHARDING_KEYS", shardingKeys);
        try {
            this._zkClient.writeData(realmPath, (Object)znRecord);
        }
        catch (Exception e) {
            LOG.error("Failed to write the realm ZNRecord in addShardingKey()! Namespace: {}, Realm: {}, ShardingKey: {}", new Object[]{this._namespace, realm, shardingKey, e});
            return false;
        }
        return true;
    }

    protected boolean deleteZkShardingKey(String realm, String shardingKey) {
        ZNRecord znRecord = (ZNRecord)this._zkClient.readData("/METADATA_STORE_ROUTING_DATA/" + realm, true);
        if (znRecord == null || !znRecord.getListField("ZK_PATH_SHARDING_KEYS").contains(shardingKey)) {
            return true;
        }
        znRecord.getListField("ZK_PATH_SHARDING_KEYS").remove(shardingKey);
        try {
            this._zkClient.writeData("/METADATA_STORE_ROUTING_DATA/" + realm, (Object)znRecord);
        }
        catch (Exception e) {
            LOG.error("Failed to write the data back in deleteShardingKey()! Namespace: {}, Realm: {}, ShardingKey: {}", new Object[]{this._namespace, realm, shardingKey, e});
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String constructUrlSuffix(String ... urlParams) {
        ArrayList<String> allUrlParameters = new ArrayList<String>(Arrays.asList("/namespaces", "/", this._namespace));
        for (String string : urlParams) {
            void var6_6;
            if (string.charAt(0) != '/') {
                String string2 = "/" + string;
            }
            allUrlParameters.add((String)var6_6);
        }
        return String.join((CharSequence)"", allUrlParameters);
    }

    private boolean buildAndSendRequestToLeader(String urlSuffix, HttpConstants.RestVerbs requestMethod, int expectedResponseCode) throws IllegalArgumentException {
        HttpPut request;
        String url = ZkRoutingDataWriter.buildEndpointFromLeaderElectionNode(this._leaderElection.getCurrentLeaderInfo()) + urlSuffix;
        switch (requestMethod) {
            case PUT: {
                request = new HttpPut(url);
                break;
            }
            case DELETE: {
                request = new HttpDelete(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported requestMethod: " + requestMethod.name());
            }
        }
        return this.sendRequestToLeader((HttpUriRequest)request, expectedResponseCode);
    }

    protected boolean sendRequestToLeader(HttpUriRequest request, int expectedResponseCode) {
        try {
            CloseableHttpResponse response = this._forwardHttpClient.execute(request);
            if (response.getStatusLine().getStatusCode() != expectedResponseCode) {
                HttpEntity respEntity = response.getEntity();
                String errorLog = "The forwarded request to leader has failed. Uri: " + request.getURI() + ". Error code: " + response.getStatusLine().getStatusCode() + " Current hostname: " + this._myHostName;
                if (respEntity != null) {
                    errorLog = errorLog + " Response: " + EntityUtils.toString((HttpEntity)respEntity);
                }
                LOG.error(errorLog);
                return false;
            }
        }
        catch (IOException e) {
            LOG.error("The forwarded request to leader raised an exception. Uri: {} Current hostname: {} ", new Object[]{request.getURI(), this._myHostName, e});
            return false;
        }
        return true;
    }
}

