/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.constraints.UsageSoftConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

class ResourceTopStateAntiAffinityConstraint
extends UsageSoftConstraint {
    ResourceTopStateAntiAffinityConstraint() {
    }

    @Override
    protected double getAssignmentScore(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        if (!replica.isReplicaTopState()) {
            return 0.0;
        }
        int curTopPartitionCountForResource = node.getAssignedTopStatePartitionsCount();
        int estimatedMaxTopStateCount = clusterContext.getEstimatedMaxTopStateCount();
        return this.computeUtilizationScore(estimatedMaxTopStateCount, curTopPartitionCountForResource);
    }
}

