/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.util.List;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.zookeeper.data.Stat;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkChildResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ZkChildResource.class);

    public ZkChildResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    private String getZKPath() {
        String relativeRef = this.getRequest().getResourceRef().getRelativeRef().toString();
        if (relativeRef.equals(".")) {
            relativeRef = "";
        }
        while (relativeRef.endsWith("/")) {
            relativeRef = relativeRef.substring(0, relativeRef.length() - 1);
        }
        return "/" + relativeRef;
    }

    public Representation get() {
        StringRepresentation presentation = null;
        String zkPath = this.getZKPath();
        try {
            ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
            ZNRecord result = this.readZkChild(zkPath, zkClient);
            presentation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(result), MediaType.APPLICATION_JSON);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Error in read zkPath: " + zkPath, (Throwable)e);
        }
        return presentation;
    }

    private ZNRecord readZkChild(String zkPath, ZkClient zkClient) {
        ZNRecord result = null;
        Stat stat = new Stat();
        ZNRecord data = (ZNRecord)zkClient.readDataAndStat(zkPath, stat, true);
        result = data != null ? data : new ZNRecord("");
        List children = zkClient.getChildren(zkPath);
        if (children != null && children.size() > 0) {
            result.setSimpleField("numChildren", "" + children.size());
            result.setListField("childrenList", children);
        } else {
            result.setSimpleField("numChildren", "0");
        }
        return result;
    }

    public Representation delete() {
        String zkPath = this.getZKPath();
        try {
            ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
            List childNames = zkClient.getChildren(zkPath);
            if (childNames != null) {
                for (String childName : childNames) {
                    String childPath = zkPath.equals("/") ? "/" + childName : zkPath + "/" + childName;
                    zkClient.deleteRecursively(childPath);
                }
            }
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in delete zkChild: " + zkPath, (Throwable)e);
        }
        return null;
    }
}

