/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.api.topology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ClusterTrie;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.TrieNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTopology {
    private static Logger logger = LoggerFactory.getLogger(ClusterTopology.class);
    private final ClusterTrie _trieClusterTopology;

    public ClusterTopology(List<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, ClusterConfig clusterConfig) {
        this._trieClusterTopology = new ClusterTrie(liveNodes, instanceConfigMap, clusterConfig);
    }

    public Map<String, List<String>> getTopologyMap() {
        return this.getTopologyUnderDomain(Collections.emptyMap());
    }

    public Map<String, List<String>> getFaultZoneMap() {
        String faultZone = this._trieClusterTopology.getFaultZoneType();
        if (faultZone == null) {
            throw new IllegalArgumentException("The fault zone in cluster config is not defined");
        }
        return this.getTopologyUnderDomainType(faultZone);
    }

    public List<String> getInvalidInstances() {
        return this._trieClusterTopology.getInvalidInstances();
    }

    private Map<String, List<String>> getTopologyUnderDomain(Map<String, String> domainMap) {
        LinkedHashMap<String, String> orderedDomain = this.validateAndOrderDomain(domainMap);
        TrieNode startNode = this._trieClusterTopology.getNode(orderedDomain);
        Map<String, TrieNode> children = startNode.getChildren();
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        children.entrySet().forEach(child -> results.put(startNode.getPath() + "/" + (String)child.getKey(), this.truncatePath(this._trieClusterTopology.getPathUnderNode((TrieNode)child.getValue()), ((TrieNode)child.getValue()).getPath())));
        return results;
    }

    private Map<String, List<String>> getTopologyUnderDomainType(String domainType) {
        String[] topologyKeys = this._trieClusterTopology.getTopologyKeys();
        if (domainType.equals(topologyKeys[0])) {
            return this.getTopologyMap();
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        String parentDomainType = null;
        for (int i = 1; i < topologyKeys.length; ++i) {
            if (!topologyKeys[i].equals(domainType)) continue;
            parentDomainType = topologyKeys[i - 1];
            break;
        }
        List<TrieNode> startNodes = this._trieClusterTopology.getStartNodes(parentDomainType);
        for (TrieNode startNode : startNodes) {
            results.putAll(this.getTopologyUnderPath(startNode.getPath()));
        }
        return results;
    }

    private Map<String, List<String>> getTopologyUnderPath(String path) {
        Map<String, String> domain = this.convertPathToDomain(path);
        return this.getTopologyUnderDomain(domain);
    }

    private LinkedHashMap<String, String> validateAndOrderDomain(Map<String, String> domainMap) {
        LinkedHashMap<String, String> orderedDomain = new LinkedHashMap<String, String>();
        if (domainMap == null) {
            throw new IllegalArgumentException("The domain should not be null");
        }
        String[] topologyKeys = this._trieClusterTopology.getTopologyKeys();
        for (int i = 0; i < domainMap.size(); ++i) {
            if (!domainMap.containsKey(topologyKeys[i])) {
                throw new IllegalArgumentException(String.format("The input domain is not valid, the key %s is required", topologyKeys[i]));
            }
            orderedDomain.put(topologyKeys[i], domainMap.get(topologyKeys[i]));
        }
        return orderedDomain;
    }

    private List<String> truncatePath(Set<String> paths, String toRemovePath) {
        ArrayList<String> results = new ArrayList<String>();
        paths.forEach(path -> {
            String truncatedPath = path.replace(toRemovePath, "");
            results.add(truncatedPath);
        });
        return results;
    }

    private Map<String, String> convertPathToDomain(String path) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (String part : path.substring(1).split("/")) {
            results.put(part.substring(0, part.indexOf(":")), part.substring(part.indexOf(":") + 1));
        }
        return results;
    }
}

