/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.spdy.api.DataInfo;

public class ByteBufferDataInfo
extends DataInfo {
    private final ByteBuffer buffer;
    private final int length;

    public ByteBufferDataInfo(ByteBuffer buffer, boolean close) {
        this(0L, TimeUnit.SECONDS, buffer, close);
    }

    public ByteBufferDataInfo(long timeout, TimeUnit unit, ByteBuffer buffer, boolean close) {
        super(timeout, unit, close);
        this.buffer = buffer;
        this.length = buffer.remaining();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public int readInto(ByteBuffer output) {
        int space = output.remaining();
        if (this.available() > space) {
            int limit = this.buffer.limit();
            this.buffer.limit(this.buffer.position() + space);
            output.put(this.buffer);
            this.buffer.limit(limit);
        } else {
            space = this.buffer.remaining();
            output.put(this.buffer);
        }
        return space;
    }

    @Override
    public int readInto(byte[] bytes, int offset, int length) {
        int available = this.available();
        if (available < length) {
            length = available;
        }
        this.buffer.get(bytes, offset, length);
        return length;
    }

    @Override
    protected ByteBuffer allocate(int size) {
        return this.buffer.isDirect() ? ByteBuffer.allocateDirect(size) : super.allocate(size);
    }
}

