/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.HelixException;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.AsyncCallback;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MultiTypeMessageHandlerFactory;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCallbackService
implements MultiTypeMessageHandlerFactory {
    private final ConcurrentHashMap<String, AsyncCallback> _callbackMap = new ConcurrentHashMap();
    private static Logger _logger = LoggerFactory.getLogger(AsyncCallbackService.class);

    public void registerAsyncCallback(String correlationId, AsyncCallback callback) {
        if (this._callbackMap.containsKey(correlationId)) {
            _logger.warn("correlation id " + correlationId + " already registered");
        }
        _logger.info("registering correlation id " + correlationId);
        this._callbackMap.put(correlationId, callback);
    }

    void verifyMessage(Message message) {
        if (!message.getMsgType().toString().equalsIgnoreCase(Message.MessageType.TASK_REPLY.name())) {
            String errorMsg = "Unexpected msg type for message " + message.getMsgId() + " type:" + message.getMsgType() + " Expected : " + Message.MessageType.TASK_REPLY;
            _logger.error(errorMsg);
            throw new HelixException(errorMsg);
        }
        String correlationId = message.getCorrelationId();
        if (correlationId == null) {
            String errorMsg = "Message " + message.getMsgId() + " does not have correlation id";
            _logger.error(errorMsg);
            throw new HelixException(errorMsg);
        }
        if (!this._callbackMap.containsKey(correlationId)) {
            String errorMsg = "Message " + message.getMsgId() + " does not have correponding callback. Probably timed out already. Correlation id: " + correlationId;
            _logger.error(errorMsg);
            throw new HelixException(errorMsg, false);
        }
        _logger.info("Verified reply message " + message.getMsgId() + " correlation:" + correlationId);
    }

    @Override
    public MessageHandler createHandler(Message message, NotificationContext context) {
        this.verifyMessage(message);
        return new AsyncCallbackMessageHandler(message.getCorrelationId(), message, context);
    }

    @Override
    public List<String> getMessageTypes() {
        return ImmutableList.of((Object)Message.MessageType.TASK_REPLY.name());
    }

    @Override
    public void reset() {
    }

    public class AsyncCallbackMessageHandler
    extends MessageHandler {
        private final String _correlationId;

        public AsyncCallbackMessageHandler(String correlationId, Message message, NotificationContext context) {
            super(message, context);
            this._correlationId = correlationId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HelixTaskResult handleMessage() throws InterruptedException {
            AsyncCallback callback;
            AsyncCallbackService.this.verifyMessage(this._message);
            HelixTaskResult result = new HelixTaskResult();
            assert (this._correlationId.equalsIgnoreCase(this._message.getCorrelationId()));
            _logger.info("invoking reply message " + this._message.getMsgId() + ", correlationid:" + this._correlationId);
            AsyncCallback asyncCallback = callback = AsyncCallbackService.this._callbackMap.get(this._correlationId);
            synchronized (asyncCallback) {
                callback.onReply(this._message);
                if (callback.isDone()) {
                    _logger.info("Removing finished callback, correlationid:" + this._correlationId);
                    AsyncCallbackService.this._callbackMap.remove(this._correlationId);
                }
            }
            result.setSuccess(true);
            return result;
        }

        @Override
        public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
            _logger.error("Message handling pipeline get an exception. MsgId:" + this._message.getMsgId(), (Throwable)e);
        }
    }
}

