/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.agent;

import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.HelixManager;
import org.apache.helix.InstanceType;
import org.apache.helix.agent.AgentStateModelFactory;
import org.apache.helix.manager.zk.ZKHelixManager;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixAgentMain {
    private static Logger LOG = LoggerFactory.getLogger(HelixAgentMain.class);
    public static final String zkAddr = "zkSvr";
    public static final String cluster = "cluster";
    public static final String help = "help";
    public static final String instanceName = "instanceName";
    public static final String stateModel = "stateModel";

    private static synchronized Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)help);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)zkAddr);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"ZookeeperServerAddress(Required)");
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkAddrOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)cluster);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"Cluster name (Required)");
        OptionBuilder.withDescription((String)"Provide cluster name");
        Option clusterOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)instanceName);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"Helix agent name (Required)");
        OptionBuilder.withDescription((String)"Provide Helix agent name");
        Option instanceNameOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)stateModel);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"State model name (Required)");
        OptionBuilder.withDescription((String)"Provide state model name");
        Option stateModelOption = OptionBuilder.create();
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(zkAddrOption);
        options.addOption(clusterOption);
        options.addOption(instanceNameOption);
        options.addOption(stateModelOption);
        return options;
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + HelixAgentMain.class.getName(), cliOptions);
    }

    public static CommandLine processCommandLineArgs(String[] cliArgs) throws Exception {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = HelixAgentMain.constructCommandLineOptions();
        try {
            return cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            LOG.error("fail to parse command-line options. cliArgs: " + Arrays.toString(cliArgs), (Throwable)pe);
            HelixAgentMain.printUsage(cliOptions);
            System.exit(1);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CommandLine cmd = HelixAgentMain.processCommandLineArgs(args);
        String zkAddress = cmd.getOptionValue(zkAddr);
        String clusterName = cmd.getOptionValue(cluster);
        String instance = cmd.getOptionValue(instanceName);
        String stateModelName = cmd.getOptionValue(stateModel);
        ZKHelixManager manager = new ZKHelixManager(clusterName, instance, InstanceType.PARTICIPANT, zkAddress);
        StateMachineEngine stateMach = manager.getStateMachineEngine();
        stateMach.registerStateModelFactory(stateModelName, (StateModelFactory)new AgentStateModelFactory());
        Runtime.getRuntime().addShutdownHook(new HelixAgentShutdownHook((HelixManager)manager));
        try {
            manager.connect();
            Thread.currentThread().join();
        }
        catch (Exception e) {
            LOG.error(e.toString());
        }
        finally {
            if (manager != null && manager.isConnected()) {
                manager.disconnect();
            }
        }
    }

    static class HelixAgentShutdownHook
    extends Thread {
        final HelixManager _manager;

        HelixAgentShutdownHook(HelixManager manager) {
            this._manager = manager;
        }

        @Override
        public void run() {
            LOG.info("HelixAgentShutdownHook invoked. agent: " + this._manager.getInstanceName());
            if (this._manager != null && this._manager.isConnected()) {
                this._manager.disconnect();
            }
        }
    }
}

