/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.view.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.model.ExternalView;
import org.apache.helix.view.dataprovider.SourceClusterDataProvider;
import org.apache.helix.view.dataprovider.ViewClusterDataCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewClusterRefresher {
    private static final Logger logger = LoggerFactory.getLogger(ViewClusterRefresher.class);
    private final String _viewClusterName;
    private final HelixDataAccessor _viewClusterDataAccessor;
    private final ViewClusterDataCache _viewClusterDataCache;
    private Set<SourceClusterDataProvider> _dataProviderView;

    public ViewClusterRefresher(String viewClusterName, HelixDataAccessor viewClusterDataAccessor) {
        this._viewClusterName = viewClusterName;
        this._viewClusterDataAccessor = viewClusterDataAccessor;
        this._viewClusterDataCache = new ViewClusterDataCache(viewClusterName);
    }

    public void updateProviderView(Set<SourceClusterDataProvider> dataProviderView) {
        this._dataProviderView = dataProviderView;
    }

    public boolean refreshPropertiesInViewCluster(PropertyType propertyType) throws IllegalArgumentException {
        boolean ok = false;
        HashSet<String> listedNamesInSource = new HashSet<String>();
        HashMap<String, HelixProperty> sourceProperties = new HashMap<String, HelixProperty>();
        Map<String, HelixProperty> viewClusterPropertyCache = this.getViewClusterPropertyCache(propertyType);
        if (viewClusterPropertyCache == null) {
            throw new IllegalArgumentException("Cannot find view cluster property cache. Property: " + propertyType.name());
        }
        try {
            HashSet<String> listedNamesInView = new HashSet<String>(this._viewClusterDataAccessor.getChildNames(this.getPropertyKey(propertyType, null)));
            block7: for (SourceClusterDataProvider provider : this._dataProviderView) {
                if (!provider.getPropertiesToAggregate().contains(propertyType)) {
                    logger.info(String.format("SourceCluster %s does not need to aggregate %s, skip.", provider.getName(), propertyType.name()));
                    continue;
                }
                switch (propertyType) {
                    case INSTANCES: {
                        listedNamesInSource.addAll(provider.getInstanceConfigNames());
                        sourceProperties.putAll(provider.getInstanceConfigMap());
                        break;
                    }
                    case LIVEINSTANCES: {
                        listedNamesInSource.addAll(provider.getLiveInstanceNames());
                        sourceProperties.putAll(provider.getLiveInstances());
                        break;
                    }
                    case EXTERNALVIEW: {
                        listedNamesInSource.addAll(provider.getExternalViewNames());
                        for (Map.Entry entry : provider.getExternalViews().entrySet()) {
                            String resourceName = (String)entry.getKey();
                            if (!sourceProperties.containsKey(resourceName)) {
                                sourceProperties.put(resourceName, (HelixProperty)new ExternalView(resourceName));
                            }
                            ViewClusterRefresher.mergeExternalViews((ExternalView)sourceProperties.get(resourceName), (ExternalView)entry.getValue());
                        }
                        continue block7;
                    }
                }
            }
            ok = this.doRefresh(propertyType, listedNamesInView, listedNamesInSource, sourceProperties, viewClusterPropertyCache);
        }
        catch (Exception e) {
            logger.warn(String.format("Caught exception during refreshing %s for view cluster %s", propertyType.name(), this._viewClusterName), (Throwable)e);
        }
        this.logRefreshResult(propertyType, ok);
        return ok;
    }

    private static void mergeExternalViews(ExternalView source, ExternalView toMerge) throws IllegalArgumentException {
        if (!source.getId().equals(toMerge.getId())) {
            throw new IllegalArgumentException(String.format("Cannot merge ExternalViews with different ID. SourceID: %s; ToMergeID: %s", source.getId(), toMerge.getId()));
        }
        for (String partitionName : toMerge.getPartitionSet()) {
            if (!source.getPartitionSet().contains(partitionName)) {
                source.setStateMap(partitionName, new TreeMap());
            }
            source.getStateMap(partitionName).putAll(toMerge.getStateMap(partitionName));
        }
    }

    private ClusterPropertyDiff calculatePropertyDiff(Set<String> viewPropertyNames, Set<String> sourcePropertyNames, Map<String, HelixProperty> cachedSourceProperties, Map<String, HelixProperty> viewClusterPropertyCache) {
        ClusterPropertyDiff diff = new ClusterPropertyDiff();
        HashSet<String> toDelete = new HashSet<String>(viewPropertyNames);
        toDelete.removeAll(sourcePropertyNames);
        diff.addPropertiesToDelete(toDelete);
        for (Map.Entry<String, HelixProperty> sourceProperty : cachedSourceProperties.entrySet()) {
            String name = sourceProperty.getKey();
            HelixProperty property = sourceProperty.getValue();
            if (property == null || !sourcePropertyNames.contains(name) || viewClusterPropertyCache.containsKey(name) && viewClusterPropertyCache.get(name).getRecord().equals((Object)property.getRecord())) continue;
            diff.addPropertyToSet(name, property);
        }
        return diff;
    }

    private boolean doRefresh(PropertyType propertyType, Set<String> viewPropertyNames, Set<String> sourcePropertyNames, Map<String, HelixProperty> cachedSourceProperties, Map<String, HelixProperty> viewClusterPropertyCache) {
        PropertyKey key;
        boolean ok = true;
        ClusterPropertyDiff diff = this.calculatePropertyDiff(viewPropertyNames, sourcePropertyNames, cachedSourceProperties, viewClusterPropertyCache);
        ArrayList<PropertyKey> keysToSet = new ArrayList<PropertyKey>();
        ArrayList<PropertyKey> keysToDelete = new ArrayList<PropertyKey>();
        for (String name : diff.getKeysToSet()) {
            key = this.getPropertyKey(propertyType, name);
            if (key == null) continue;
            keysToSet.add(key);
        }
        for (String name : diff.getKeysToDelete()) {
            key = this.getPropertyKey(propertyType, name);
            if (key == null) continue;
            keysToDelete.add(key);
        }
        if (!this.deleteProperties(keysToDelete)) {
            ok = false;
        }
        if (!this.addOrUpdateProperties(keysToSet, diff.getPropertiesToSet())) {
            ok = false;
        }
        return ok;
    }

    private PropertyKey getPropertyKey(PropertyType propertyType, String propertyName) {
        switch (propertyType) {
            case INSTANCES: {
                return propertyName == null ? this._viewClusterDataAccessor.keyBuilder().instanceConfigs() : this._viewClusterDataAccessor.keyBuilder().instanceConfig(propertyName);
            }
            case LIVEINSTANCES: {
                return propertyName == null ? this._viewClusterDataAccessor.keyBuilder().liveInstances() : this._viewClusterDataAccessor.keyBuilder().liveInstance(propertyName);
            }
            case EXTERNALVIEW: {
                return propertyName == null ? this._viewClusterDataAccessor.keyBuilder().externalViews() : this._viewClusterDataAccessor.keyBuilder().externalView(propertyName);
            }
        }
        return null;
    }

    boolean refreshViewClusterDataCache() {
        return this._viewClusterDataCache.updateCache(this._viewClusterDataAccessor);
    }

    private Map<String, ? extends HelixProperty> getViewClusterPropertyCache(PropertyType propertyType) {
        switch (propertyType) {
            case INSTANCES: {
                return this._viewClusterDataCache.getInstanceConfigMap();
            }
            case LIVEINSTANCES: {
                return this._viewClusterDataCache.getLiveInstances();
            }
            case EXTERNALVIEW: {
                return this._viewClusterDataCache.getExternalViews();
            }
        }
        return null;
    }

    private <T extends HelixProperty> boolean addOrUpdateProperties(List<PropertyKey> keysToAddOrUpdate, List<HelixProperty> objects) {
        boolean ok = true;
        logger.info(String.format("AddOrUpdate %s objects: %s", keysToAddOrUpdate.size(), keysToAddOrUpdate));
        boolean[] addOrUpdateResults = this._viewClusterDataAccessor.setChildren(keysToAddOrUpdate, objects);
        for (int i = 0; i < addOrUpdateResults.length; ++i) {
            if (addOrUpdateResults[i]) continue;
            logger.warn(String.format("Failed to create or update live instance %s, will retry later", keysToAddOrUpdate.get(i).getPath()));
            ok = false;
        }
        return ok;
    }

    private <T extends HelixProperty> boolean deleteProperties(List<PropertyKey> keysToDelete) {
        boolean ok = true;
        logger.info(String.format("Deleting %s objects: %s", keysToDelete.size(), keysToDelete));
        for (PropertyKey key : keysToDelete) {
            if (this._viewClusterDataAccessor.removeProperty(key)) continue;
            ok = false;
            logger.warn(String.format("Failed to create or update live instance %s, will retry later", key.getPath()));
        }
        return ok;
    }

    private void logRefreshResult(PropertyType type, boolean ok) {
        if (!ok) {
            logger.warn(String.format("Failed to refresh all %s for view cluster %s, will retry", type.name(), this._viewClusterName));
        } else {
            logger.info(String.format("Successfully refreshed all %s for view cluster %s", type.name(), this._viewClusterName));
        }
    }

    private static class ClusterPropertyDiff {
        List<String> _keysToSet = new ArrayList<String>();
        List<HelixProperty> _propertiesToSet = new ArrayList<HelixProperty>();
        List<String> _keysToDelete = new ArrayList<String>();

        public void addPropertyToSet(String key, HelixProperty obj) {
            this._keysToSet.add(key);
            this._propertiesToSet.add(obj);
        }

        public void addPropertiesToDelete(Collection<? extends String> keys) {
            this._keysToDelete.addAll(keys);
        }

        public List<String> getKeysToSet() {
            return Collections.unmodifiableList(this._keysToSet);
        }

        public List<HelixProperty> getPropertiesToSet() {
            return Collections.unmodifiableList(this._propertiesToSet);
        }

        public List<String> getKeysToDelete() {
            return Collections.unmodifiableList(this._keysToDelete);
        }
    }
}

