/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server;

import com.codahale.metrics.jmx.ObjectNameFactory;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.HelixException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HelixRestObjectNameFactory
implements ObjectNameFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HelixRestObjectNameFactory.class);
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private static final String KEY_NAMESPACE = "namespace";
    private final String _namespace;

    HelixRestObjectNameFactory(String nameSpace) {
        this._namespace = nameSpace;
    }

    public ObjectName createName(String type, String domain, String name) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put(KEY_NAME, name);
        properties.put(KEY_TYPE, type);
        properties.put(KEY_NAMESPACE, this._namespace);
        try {
            ObjectName objectName = new ObjectName(domain, properties);
            boolean needQuote = false;
            if (objectName.isDomainPattern()) {
                domain = ObjectName.quote(domain);
                needQuote = true;
            }
            if (objectName.isPropertyValuePattern(KEY_NAME)) {
                properties.put(KEY_NAME, ObjectName.quote(name));
                needQuote = true;
            }
            if (objectName.isPropertyValuePattern(KEY_TYPE)) {
                properties.put(KEY_TYPE, ObjectName.quote(type));
                needQuote = true;
            }
            return needQuote ? new ObjectName(domain, properties) : objectName;
        }
        catch (MalformedObjectNameException e) {
            throw new HelixException(String.format("Unable to register metrics: domain=%s, name=%s, namespace=%s", domain, name, this._namespace), (Throwable)e);
        }
    }
}

