/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.zip.CRC32;

public class RUSHrHash {
    protected int replicationDegree = 1;
    protected HashMap[] clusters;
    protected HashMap[] clusterConfig;
    protected int totalClusters = 0;
    protected int totalNodes = 0;
    protected int totalNodesW = 0;
    protected HashMap[] nodes = null;
    protected final int SEED_PARAM = 1560;
    Random ran = new Random();
    float ranMax = (float)Math.pow(2.0, 16.0);

    public RUSHrHash(HashMap<String, Object> conf) throws Exception {
        this.clusterConfig = (HashMap[])conf.get("subClusters");
        this.replicationDegree = (Integer)conf.get("replicationDegree");
        HashMap[] subClusters = (HashMap[])conf.get("subClusters");
        this.totalClusters = subClusters.length;
        this.clusters = new HashMap[this.totalClusters];
        if (this.totalClusters <= 0) {
            throw new Exception("data config to the RUSHr locator does not contain a valid clusters property");
        }
        int nodeCt = 0;
        HashMap[] nodeData = null;
        ArrayList<HashMap> tempNodes = new ArrayList<HashMap>();
        HashMap subCluster = null;
        HashMap<String, Object> clusterData = null;
        Integer[] clusterDataList = null;
        for (int i = 0; i < this.totalClusters; ++i) {
            subCluster = subClusters[i];
            nodeData = (HashMap[])subCluster.get("nodes");
            nodeCt = nodeData.length;
            clusterDataList = new Integer[nodeCt];
            for (int n = 0; n < nodeCt; ++n) {
                tempNodes.add(nodeData[n]);
                clusterDataList[n] = n;
            }
            this.totalNodes += nodeCt;
            this.totalNodesW += nodeCt * (Integer)subCluster.get("weight");
            clusterData = new HashMap<String, Object>();
            clusterData.put("count", nodeCt);
            clusterData.put("list", clusterDataList);
            this.clusters[i] = clusterData;
        }
        this.nodes = new HashMap[this.totalNodes];
        tempNodes.toArray(this.nodes);
    }

    public ArrayList<HashMap> findNode(long objKey) throws Exception {
        HashMap[] c = this.clusters;
        int sumRemainingNodes = this.totalNodes;
        int sumRemainingNodesW = this.totalNodesW;
        int repDeg = this.replicationDegree;
        int totClu = this.totalClusters;
        int totNod = this.totalNodes;
        HashMap[] clusConfig = this.clusterConfig;
        if (totNod <= 0 || totClu <= 0) {
            throw new Exception("the total nodes or total clusters is negative or 0.  bad joo joos!");
        }
        int currentCluster = totClu - 1;
        ArrayList<HashMap> nodeData = new ArrayList<HashMap>();
        while (true) {
            if (currentCluster < 0) {
                throw new Exception("the cluster index became negative while we were looking for the following id: objKey.  This should never happen with any key.  There is a bug or maybe your joo joos are BAD!");
            }
            HashMap clusterData = clusConfig[currentCluster];
            Integer weight = (Integer)clusterData.get("weight");
            Integer disksInCurrentCluster = (Integer)c[currentCluster].get("count");
            Integer disksInCurrentClusterW = disksInCurrentCluster * weight;
            long seed = objKey + (long)currentCluster;
            this.ran.setSeed(seed);
            int t = repDeg - (sumRemainingNodes -= disksInCurrentCluster.intValue()) > 0 ? repDeg - sumRemainingNodes : 0;
            int u = t + this.drawWHG(repDeg - t, disksInCurrentClusterW - t, disksInCurrentClusterW + (sumRemainingNodesW -= disksInCurrentClusterW.intValue()) - t, weight);
            if (u > 0) {
                if (u > disksInCurrentCluster) {
                    u = disksInCurrentCluster;
                }
                this.ran.setSeed(objKey + (long)currentCluster + 1560L);
                this.choose(u, currentCluster, sumRemainingNodes, nodeData);
                this.reset(u, currentCluster);
                repDeg -= u;
            }
            if (repDeg == 0) break;
            --currentCluster;
        }
        return nodeData;
    }

    public ArrayList<HashMap> findNode(String objKey) throws Exception {
        CRC32 crc32 = new CRC32();
        byte[] bytes = objKey.getBytes();
        crc32.update(bytes);
        long crc32Value = crc32.getValue();
        long objKeyLong = crc32Value >> 16 & 0x7FFFL;
        return this.findNode(objKeyLong);
    }

    public void reset(int nodesToRetrieve, int currentCluster) {
        Integer[] list = (Integer[])this.clusters[currentCluster].get("list");
        Integer count = (Integer)this.clusters[currentCluster].get("count");
        for (int nodeIdx = 0; nodeIdx < nodesToRetrieve; ++nodeIdx) {
            int listIdx = count - nodesToRetrieve + nodeIdx;
            int val = list[listIdx];
            if (val < count - nodesToRetrieve) {
                list[val] = val;
            }
            list[listIdx] = listIdx;
        }
    }

    public void choose(int nodesToRetrieve, int currentCluster, int remainingNodes, ArrayList<HashMap> nodeData) {
        Integer[] list = (Integer[])this.clusters[currentCluster].get("list");
        Integer count = (Integer)this.clusters[currentCluster].get("count");
        for (int nodeIdx = 0; nodeIdx < nodesToRetrieve; ++nodeIdx) {
            int maxIdx = count - nodeIdx - 1;
            int randNode = this.ran.nextInt(maxIdx + 1);
            int chosen = list[randNode];
            list[randNode] = list[maxIdx];
            list[maxIdx] = chosen;
            nodeData.add(this.nodes[remainingNodes + chosen]);
        }
    }

    public ArrayList<HashMap> findNodes(String objKey) throws Exception {
        return this.findNode(objKey);
    }

    public int getReplicationDegree() {
        return this.replicationDegree;
    }

    public int getTotalNodes() {
        return this.totalNodes;
    }

    public int drawWHG(int replicas, int disksInCurrentCluster, int totalDisks, int weight) {
        int found = 0;
        for (int i = 0; i < replicas; ++i) {
            float prob;
            if (totalDisks == 0) continue;
            int ranInt = this.ran.nextInt((int)(this.ranMax + 1.0f));
            float z = (float)ranInt / this.ranMax;
            if (z <= (prob = (float)disksInCurrentCluster / (float)totalDisks)) {
                ++found;
                disksInCurrentCluster -= weight;
            }
            totalDisks -= weight;
        }
        return found;
    }
}

