ace.define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(i,h,b){"use strict";var f=i("../lib/oop"),p=i("./text_highlight_rules").TextHighlightRules,g=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},g.getTagRule(),{defaultToken:"comment.doc",caseInsensitive:!0}]}};f.inherits(g,p),g.getTagRule=function(c){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}},g.getStartRule=function(c){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:c}},g.getEndRule=function(c){return{token:"comment.doc",regex:"\\*\\/",next:c}},h.DocCommentHighlightRules=g}),ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(i,h,b){"use strict";var f=i("../lib/oop"),p=i("./doc_comment_highlight_rules").DocCommentHighlightRules,g=i("./text_highlight_rules").TextHighlightRules,c="[a-zA-Z\\$_\xa1-\uffff][a-zA-Z\\d\\$_\xa1-\uffff]*",o=function(u){var s=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Symbol|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|break|case|catch|continue|default|delete|do|else|finally|for|function|if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|__parent__|__count__|escape|unescape|with|__proto__|class|enum|extends|super|export|implements|private|public|interface|package|protected|static|constructor","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},"identifier"),n="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|u{[0-9a-fA-F]{1,6}}|[0-2][0-7]{0,2}|3[0-7][0-7]?|[4-7][0-7]?|.)";this.$rules={no_regex:[p.getStartRule("doc-start"),a("no_regex"),{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+c+")(\\.)(prototype)(\\.)("+c+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+c+")(\\.)("+c+")(\\s*)(=)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+c+")(\\s*)(=)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+c+")(\\.)("+c+")(\\s*)(=)(\\s*)(function\\*?)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function\\*?)(\\s+)("+c+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+c+")(\\s*)(:)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"from(?=\\s*('|\"))"},{token:"keyword",regex:"(?:case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void)\\b",next:"start"},{token:"support.constant",regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|trace|timeEnd|assert)\b/},{token:s,regex:c},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+c+")(\\.)("+c+")(\\s*)(=)(\\s*)(function\\*?)(?:(\\s+)(\\w+))?(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|lter|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward|rEach)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:c},{regex:"",token:"empty",next:"no_regex"}],start:[p.getStartRule("doc-start"),a("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],default_parameter:[{token:"string",regex:"'(?=.)",push:[{token:"string",regex:"'|$",next:"pop"},{include:"qstring"}]},{token:"string",regex:'"(?=.)',push:[{token:"string",regex:'"|$',next:"pop"},{include:"qqstring"}]},{token:"constant.language",regex:"null|Infinity|NaN|undefined"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:"punctuation.operator",regex:",",next:"function_arguments"},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],function_arguments:[a("function_arguments"),{token:"variable.parameter",regex:c},{token:"punctuation.operator",regex:","},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:n},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:n},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]},(!u||!u.noES6)&&(this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(e,r,l){if(this.next="{"==e?this.nextState:"","{"==e&&l.length)l.unshift("start",r);else if("}"==e&&l.length&&(l.shift(),this.next=l.shift(),-1!=this.next.indexOf("string")||-1!=this.next.indexOf("jsx")))return"paren.quasi.end";return"{"==e?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:n},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]},{token:["variable.parameter","text"],regex:"("+c+")(\\s*)(?=\\=>)"},{token:"paren.lparen",regex:"(\\()(?=.+\\s*=>)",next:"function_arguments"},{token:"variable.language",regex:"(?:(?:(?:Weak)?(?:Set|Map))|Promise)\\b"}),this.$rules.function_arguments.unshift({token:"keyword.operator",regex:"=",next:"default_parameter"},{token:"keyword.operator",regex:"\\.{3}"}),this.$rules.property.unshift({token:"support.function",regex:"(findIndex|repeat|startsWith|endsWith|includes|isSafeInteger|trunc|cbrt|log2|log10|sign|then|catch|finally|resolve|reject|race|any|all|allSettled|keys|entries|isInteger)\\b(?=\\()"},{token:"constant.language",regex:"(?:MAX_SAFE_INTEGER|MIN_SAFE_INTEGER|EPSILON)\\b"}),(!u||0!=u.jsx)&&d.call(this)),this.embedRules(p,"doc-",[p.getEndRule("no_regex")]),this.normalizeRules()};function d(){var u=c.replace("\\d","\\d\\-"),s={onMatch:function(n,e,r){var l="/"==n.charAt(1)?2:1;return 1==l?(e!=this.nextState?r.unshift(this.next,this.nextState,0):r.unshift(this.next),r[2]++):2==l&&e==this.nextState&&(r[1]--,(!r[1]||r[1]<0)&&(r.shift(),r.shift())),[{type:"meta.tag.punctuation."+(1==l?"":"end-")+"tag-open.xml",value:n.slice(0,l)},{type:"meta.tag.tag-name.xml",value:n.substr(l)}]},regex:"</?"+u,next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(s);var t={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[t,s,{include:"reference"},{defaultToken:"string"}],this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(n,e,r){return e==r[0]&&r.shift(),2==n.length&&(r[0]==this.nextState&&r[1]--,(!r[1]||r[1]<0)&&r.splice(0,2)),this.next=r[0]||"start",[{type:this.token,value:n}]},nextState:"jsx"},t,a("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:u},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},s],this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function a(u){return[{token:"comment",regex:/\/\*/,next:[p.getTagRule(),{token:"comment",regex:"\\*\\/",next:u||"pop"},{defaultToken:"comment",caseInsensitive:!0}]},{token:"comment",regex:"\\/\\/",next:[p.getTagRule(),{token:"comment",regex:"$|^",next:u||"pop"},{defaultToken:"comment",caseInsensitive:!0}]}]}f.inherits(o,g),h.JavaScriptHighlightRules=o}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(i,h,b){"use strict";var f=i("../range").Range,p=function(){};(function(){this.checkOutdent=function(g,c){return!!/^\s+$/.test(g)&&/^\s*\}/.test(c)},this.autoOutdent=function(g,c){var d=g.getLine(c).match(/^(\s*\})/);if(!d)return 0;var a=d[1].length,u=g.findMatchingBracket({row:c,column:a});if(!u||u.row==c)return 0;var s=this.$getIndent(g.getLine(u.row));g.replace(new f(c,0,c,a-1),s)},this.$getIndent=function(g){return g.match(/^\s*/)[0]}}).call(p.prototype),h.MatchingBraceOutdent=p}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(i,h,b){"use strict";var f=i("../../lib/oop"),p=i("../../range").Range,g=i("./fold_mode").FoldMode,c=h.FoldMode=function(o){o&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+o.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+o.end)))};f.inherits(c,g),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(o,d,a){var u=o.getLine(a);if(this.singleLineBlockCommentRe.test(u)&&!this.startRegionRe.test(u)&&!this.tripleStarBlockCommentRe.test(u))return"";var s=this._getFoldWidgetBase(o,d,a);return!s&&this.startRegionRe.test(u)?"start":s},this.getFoldWidgetRange=function(o,d,a,u){var e,s=o.getLine(a);if(this.startRegionRe.test(s))return this.getCommentRegionBlock(o,s,a);if(e=s.match(this.foldingStartMarker)){var t=e.index;if(e[1])return this.openingBracketBlock(o,e[1],a,t);var n=o.getCommentFoldRange(a,t+e[0].length,1);return n&&!n.isMultiLine()&&(u?n=this.getSectionRange(o,a):"all"!=d&&(n=null)),n}return"markbegin"!==d&&(e=s.match(this.foldingStopMarker))?(t=e.index+e[0].length,e[1]?this.closingBracketBlock(o,e[1],a,t):o.getCommentFoldRange(a,t,-1)):void 0},this.getSectionRange=function(o,d){for(var a=o.getLine(d),u=a.search(/\S/),s=d,t=a.length,n=d+=1,e=o.getLength();++d<e;){var r=(a=o.getLine(d)).search(/\S/);if(-1!==r){if(u>r)break;var l=this.getFoldWidgetRange(o,"all",d);if(l){if(l.start.row<=s)break;if(l.isMultiLine())d=l.end.row;else if(u==r)break}n=d}}return new p(s,t,n,o.getLine(n).length)},this.getCommentRegionBlock=function(o,d,a){for(var u=d.search(/\s*$/),s=o.getLength(),t=a,n=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,e=1;++a<s;){d=o.getLine(a);var r=n.exec(d);if(r&&(r[1]?e--:e++,!e))break}if(a>t)return new p(t,u,a,d.length)}}.call(c.prototype)}),ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(i,h,b){"use strict";var f=i("../lib/oop"),p=i("./text").Mode,g=i("./javascript_highlight_rules").JavaScriptHighlightRules,c=i("./matching_brace_outdent").MatchingBraceOutdent,o=i("../worker/worker_client").WorkerClient,d=i("./behaviour/cstyle").CstyleBehaviour,a=i("./folding/cstyle").FoldMode,u=function(){this.HighlightRules=g,this.$outdent=new c,this.$behaviour=new d,this.foldingRules=new a};f.inherits(u,p),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.$quotes={'"':'"',"'":"'","`":"`"},this.$pairQuotesAfter={"`":/\w/},this.getNextLineIndent=function(s,t,n){var e=this.$getIndent(t),r=this.getTokenizer().getLineTokens(t,s),l=r.tokens,m=r.state;if(l.length&&"comment"==l[l.length-1].type)return e;if("start"==s||"no_regex"==s)(x=t.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/))&&(e+=n);else if("doc-start"==s){if("start"==m||"no_regex"==m)return"";var x;(x=t.match(/^\s*(\/?)\*/))&&(x[1]&&(e+=" "),e+="* ")}return e},this.checkOutdent=function(s,t,n){return this.$outdent.checkOutdent(t,n)},this.autoOutdent=function(s,t,n){this.$outdent.autoOutdent(t,n)},this.createWorker=function(s){var t=new o(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");return t.attachToDocument(s.getDocument()),t.on("annotate",function(n){s.setAnnotations(n.data)}),t.on("terminate",function(){s.clearAnnotations()}),t},this.$id="ace/mode/javascript",this.snippetFileId="ace/snippets/javascript"}.call(u.prototype),h.Mode=u}),ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(i,h,b){"use strict";var f=i("../lib/oop"),g=(i("../lib/lang"),i("./text_highlight_rules").TextHighlightRules),c=h.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index",o=h.supportFunction="rgb|rgba|url|attr|counter|counters",d=h.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|flex-end|flex-start|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom",a=h.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen",u=h.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace",s=h.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))",t=h.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b",n=h.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b",e=function(){var r=this.createKeywordMapper({"support.function":o,"support.constant":d,"support.type":c,"support.constant.color":a,"support.constant.fonts":u},"text",!0);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:s},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:!0}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document|page|font|keyframes|viewport|counter-style|font-feature-values|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+s+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:s},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:t},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:n},{include:"url"},{token:r,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{caseInsensitive:!0}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]},this.normalizeRules()};f.inherits(e,g),h.CssHighlightRules=e}),ace.define("ace/mode/css_completions",["require","exports","module"],function(i,h,b){"use strict";var f={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}},p=function(){};(function(){this.completionsDefined=!1,this.defineCompletions=function(){if(document){var g=document.createElement("c").style;for(var c in g)if("string"==typeof g[c]){var o=c.replace(/[A-Z]/g,function(d){return"-"+d.toLowerCase()});f.hasOwnProperty(o)||(f[o]=1)}}this.completionsDefined=!0},this.getCompletions=function(g,c,o,d){if(this.completionsDefined||this.defineCompletions(),"ruleset"===g||"ace/mode/scss"==c.$mode.$id){var a=c.getLine(o.row).substr(0,o.column),u=/\([^)]*$/.test(a);return u&&(a=a.substr(a.lastIndexOf("(")+1)),/:[^;]+$/.test(a)?(/([\w\-]+):[^:]*$/.test(a),this.getPropertyValueCompletions(g,c,o,d)):this.getPropertyCompletions(g,c,o,d,u)}return[]},this.getPropertyCompletions=function(g,c,o,d,a){return a=a||!1,Object.keys(f).map(function(s){return{caption:s,snippet:s+": $0"+(a?"":";"),meta:"property",score:1e6}})},this.getPropertyValueCompletions=function(g,c,o,d){var a=c.getLine(o.row).substr(0,o.column),u=(/([\w\-]+):[^:]*$/.exec(a)||{})[1];if(!u)return[];var s=[];return u in f&&"object"==typeof f[u]&&(s=Object.keys(f[u])),s.map(function(t){return{caption:t,snippet:t,meta:"property value",score:1e6}})}}).call(p.prototype),h.CssCompletions=p}),ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(i,h,b){"use strict";var f=i("../../lib/oop"),g=(i("../behaviour"),i("./cstyle").CstyleBehaviour),c=i("../../token_iterator").TokenIterator,o=function(){this.inherit(g),this.add("colon","insertion",function(d,a,u,s,t){if(":"===t&&u.selection.isEmpty()){var n=u.getCursorPosition(),e=new c(s,n.row,n.column),r=e.getCurrentToken();if(r&&r.value.match(/\s+/)&&(r=e.stepBackward()),r&&"support.type"===r.type){var l=s.doc.getLine(n.row);if(":"===l.substring(n.column,n.column+1))return{text:"",selection:[1,1]};if(/^(\s+[^;]|\s*$)/.test(l.substring(n.column)))return{text:":;",selection:[1,1]}}}}),this.add("colon","deletion",function(d,a,u,s,t){var n=s.doc.getTextRange(t);if(!t.isMultiLine()&&":"===n){var e=u.getCursorPosition(),r=new c(s,e.row,e.column),l=r.getCurrentToken();if(l&&l.value.match(/\s+/)&&(l=r.stepBackward()),l&&"support.type"===l.type&&";"===s.doc.getLine(t.start.row).substring(t.end.column,t.end.column+1))return t.end.column++,t}}),this.add("semicolon","insertion",function(d,a,u,s,t){if(";"===t&&u.selection.isEmpty()){var n=u.getCursorPosition();if(";"===s.doc.getLine(n.row).substring(n.column,n.column+1))return{text:"",selection:[1,1]}}}),this.add("!important","insertion",function(d,a,u,s,t){if("!"===t&&u.selection.isEmpty()){var n=u.getCursorPosition(),e=s.doc.getLine(n.row);if(/^\s*(;|}|$)/.test(e.substring(n.column)))return{text:"!important",selection:[10,10]}}})};f.inherits(o,g),h.CssBehaviour=o}),ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(i,h,b){"use strict";var f=i("../lib/oop"),p=i("./text").Mode,g=i("./css_highlight_rules").CssHighlightRules,c=i("./matching_brace_outdent").MatchingBraceOutdent,o=i("../worker/worker_client").WorkerClient,d=i("./css_completions").CssCompletions,a=i("./behaviour/css").CssBehaviour,u=i("./folding/cstyle").FoldMode,s=function(){this.HighlightRules=g,this.$outdent=new c,this.$behaviour=new a,this.$completer=new d,this.foldingRules=new u};f.inherits(s,p),function(){this.foldingRules="cStyle",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(t,n,e){var r=this.$getIndent(n),l=this.getTokenizer().getLineTokens(n,t).tokens;return l.length&&"comment"==l[l.length-1].type||n.match(/^.*\{\s*$/)&&(r+=e),r},this.checkOutdent=function(t,n,e){return this.$outdent.checkOutdent(n,e)},this.autoOutdent=function(t,n,e){this.$outdent.autoOutdent(n,e)},this.getCompletions=function(t,n,e,r){return this.$completer.getCompletions(t,n,e,r)},this.createWorker=function(t){var n=new o(["ace"],"ace/mode/css_worker","Worker");return n.attachToDocument(t.getDocument()),n.on("annotate",function(e){t.setAnnotations(e.data)}),n.on("terminate",function(){t.clearAnnotations()}),n},this.$id="ace/mode/css",this.snippetFileId="ace/snippets/css"}.call(s.prototype),h.Mode=s}),ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(i,h,b){"use strict";var f=i("../lib/oop"),p=i("./text_highlight_rules").TextHighlightRules,g=function(c){var o="[_:a-zA-Z\xc0-\uffff][-_:.a-zA-Z0-9\xc0-\uffff]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+o+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:!0},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:o},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+o+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"--\x3e",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+o+":)?"+o+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:o},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]},this.constructor===g&&this.normalizeRules()};(function(){this.embedTagRules=function(c,o,d){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+d+".tag-name.xml"],regex:"(<)("+d+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:o+"start"}]}),this.$rules[d+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(a,u,s){return s.splice(0),this.token}}],this.embedRules(c,o,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+d+".tag-name.xml"],regex:"(</)("+d+"(?=\\s|>|$))",next:d+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(p.prototype),f.inherits(g,p),h.XmlHighlightRules=g}),ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(i,h,b){"use strict";var f=i("../lib/oop"),p=i("../lib/lang"),g=i("./css_highlight_rules").CssHighlightRules,c=i("./javascript_highlight_rules").JavaScriptHighlightRules,o=i("./xml_highlight_rules").XmlHighlightRules,d=p.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"}),a=function(){o.call(this),this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(u,s){var t=d[s];return["meta.tag.punctuation."+("<"==u?"":"end-")+"tag-open.xml","meta.tag"+(t?"."+t:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}),this.embedTagRules(g,"css-","style"),this.embedTagRules(new c({jsx:!1}).getRules(),"js-","script"),this.constructor===a&&this.normalizeRules()};f.inherits(a,o),h.HtmlHighlightRules=a}),ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(i,h,b){"use strict";var f=i("../../lib/oop"),p=i("../behaviour").Behaviour,g=i("../../token_iterator").TokenIterator;function o(a,u){return a&&a.type.lastIndexOf(u+".xml")>-1}i("../../lib/lang");var d=function(){this.add("string_dquotes","insertion",function(a,u,s,t,n){if('"'==n||"'"==n){var e=n,r=t.doc.getTextRange(s.getSelectionRange());if(""!==r&&"'"!==r&&'"'!=r&&s.getWrapBehavioursEnabled())return{text:e+r+e,selection:!1};var l=s.getCursorPosition(),x=t.doc.getLine(l.row).substring(l.column,l.column+1),k=new g(t,l.row,l.column),v=k.getCurrentToken();if(x==e&&(o(v,"attribute-value")||o(v,"string")))return{text:"",selection:[1,1]};if(v||(v=k.stepBackward()),!v)return;for(;o(v,"tag-whitespace")||o(v,"whitespace");)v=k.stepBackward();var y=!x||x.match(/\s/);if(o(v,"attribute-equals")&&(y||">"==x)||o(v,"decl-attribute-equals")&&(y||"?"==x))return{text:e+e,selection:[1,1]}}}),this.add("string_dquotes","deletion",function(a,u,s,t,n){var e=t.doc.getTextRange(n);if(!n.isMultiLine()&&('"'==e||"'"==e)&&t.doc.getLine(n.start.row).substring(n.start.column+1,n.start.column+2)==e)return n.end.column++,n}),this.add("autoclosing","insertion",function(a,u,s,t,n){if(">"==n){var e=s.getSelectionRange().start,r=new g(t,e.row,e.column),l=r.getCurrentToken()||r.stepBackward();if(!l||!(o(l,"tag-name")||o(l,"tag-whitespace")||o(l,"attribute-name")||o(l,"attribute-equals")||o(l,"attribute-value"))||o(l,"reference.attribute-value"))return;if(o(l,"attribute-value")){var m=r.getCurrentTokenColumn()+l.value.length;if(e.column<m)return;if(e.column==m){var x=r.stepForward();if(x&&o(x,"attribute-value"))return;r.stepBackward()}}if(/^\s*>/.test(t.getLine(e.row).slice(e.column)))return;for(;!o(l,"tag-name");)if("<"==(l=r.stepBackward()).value){l=r.stepForward();break}var k=r.getCurrentTokenRow(),v=r.getCurrentTokenColumn();if(o(r.stepBackward(),"end-tag-open"))return;var y=l.value;return k==e.row&&(y=y.substring(0,e.column-v)),this.voidElements.hasOwnProperty(y.toLowerCase())?void 0:{text:"></"+y+">",selection:[1,1]}}}),this.add("autoindent","insertion",function(a,u,s,t,n){if("\n"==n){var e=s.getCursorPosition(),r=t.getLine(e.row),l=new g(t,e.row,e.column),m=l.getCurrentToken();if(m&&-1!==m.type.indexOf("tag-close")){if("/>"==m.value)return;for(;m&&-1===m.type.indexOf("tag-name");)m=l.stepBackward();if(!m)return;var x=m.value,k=l.getCurrentTokenRow();if(!(m=l.stepBackward())||-1!==m.type.indexOf("end-tag"))return;if(this.voidElements&&!this.voidElements[x]){var v=t.getTokenAt(e.row,e.column+1),y=(r=t.getLine(k),this.$getIndent(r)),w=y+t.getTabString();return v&&"</"===v.value?{text:"\n"+w+"\n"+y,selection:[1,w.length,1,w.length]}:{text:"\n"+w}}}}})};f.inherits(d,p),h.XmlBehaviour=d}),ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(i,h,b){"use strict";var f=i("../../lib/oop"),p=i("./fold_mode").FoldMode,g=h.FoldMode=function(c,o){this.defaultMode=c,this.subModes=o};f.inherits(g,p),function(){this.$getMode=function(c){for(var o in"string"!=typeof c&&(c=c[0]),this.subModes)if(0===c.indexOf(o))return this.subModes[o];return null},this.$tryMode=function(c,o,d,a){var u=this.$getMode(c);return u?u.getFoldWidget(o,d,a):""},this.getFoldWidget=function(c,o,d){return this.$tryMode(c.getState(d-1),c,o,d)||this.$tryMode(c.getState(d),c,o,d)||this.defaultMode.getFoldWidget(c,o,d)},this.getFoldWidgetRange=function(c,o,d){var a=this.$getMode(c.getState(d-1));return(!a||!a.getFoldWidget(c,o,d))&&(a=this.$getMode(c.getState(d))),(!a||!a.getFoldWidget(c,o,d))&&(a=this.defaultMode),a.getFoldWidgetRange(c,o,d)}}.call(g.prototype)}),ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(i,h,b){"use strict";var f=i("../../lib/oop"),p=i("../../range").Range,g=i("./fold_mode").FoldMode,c=h.FoldMode=function(a,u){g.call(this),this.voidElements=a||{},this.optionalEndTags=f.mixin({},this.voidElements),u&&f.mixin(this.optionalEndTags,u)};f.inherits(c,g);var o=function(){this.tagName="",this.closing=!1,this.selfClosing=!1,this.start={row:0,column:0},this.end={row:0,column:0}};function d(a,u){return a.type.lastIndexOf(u+".xml")>-1}(function(){this.getFoldWidget=function(a,u,s){var t=this._getFirstTagInLine(a,s);return t?t.closing||!t.tagName&&t.selfClosing?"markbeginend"===u?"end":"":!t.tagName||t.selfClosing||this.voidElements.hasOwnProperty(t.tagName.toLowerCase())||this._findEndTagInLine(a,s,t.tagName,t.end.column)?"":"start":this.getCommentFoldWidget(a,s)},this.getCommentFoldWidget=function(a,u){return/comment/.test(a.getState(u))&&/<!-/.test(a.getLine(u))?"start":""},this._getFirstTagInLine=function(a,u){for(var s=a.getTokens(u),t=new o,n=0;n<s.length;n++){var e=s[n];if(d(e,"tag-open")){if(t.end.column=t.start.column+e.value.length,t.closing=d(e,"end-tag-open"),!(e=s[++n]))return null;for(t.tagName=e.value,t.end.column+=e.value.length,n++;n<s.length;n++)if(t.end.column+=(e=s[n]).value.length,d(e,"tag-close")){t.selfClosing="/>"==e.value;break}return t}if(d(e,"tag-close"))return t.selfClosing="/>"==e.value,t;t.start.column+=e.value.length}return null},this._findEndTagInLine=function(a,u,s,t){for(var n=a.getTokens(u),e=0,r=0;r<n.length;r++){var l=n[r];if(!((e+=l.value.length)<t)&&d(l,"end-tag-open")&&(l=n[r+1])&&l.value==s)return!0}return!1},this.getFoldWidgetRange=function(a,u,s){var t=a.getMatchingTags({row:s,column:0});return t?new p(t.openTag.end.row,t.openTag.end.column,t.closeTag.start.row,t.closeTag.start.column):this.getCommentFoldWidget(a,s)&&a.getCommentFoldRange(s,a.getLine(s).length)}}).call(c.prototype)}),ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(i,h,b){"use strict";var f=i("../../lib/oop"),p=i("./mixed").FoldMode,g=i("./xml").FoldMode,c=i("./cstyle").FoldMode,o=h.FoldMode=function(d,a){p.call(this,new g(d,a),{"js-":new c,"css-":new c})};f.inherits(o,p)}),ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(i,h,b){"use strict";var f=i("../token_iterator").TokenIterator,c=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"].concat(["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"]),o={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}},d=Object.keys(o);function a(n,e){return n.type.lastIndexOf(e+".xml")>-1}function u(n,e){for(var r=new f(n,e.row,e.column),l=r.getCurrentToken();l&&!a(l,"tag-name");)l=r.stepBackward();if(l)return l.value}var t=function(){};(function(){this.getCompletions=function(n,e,r,l){var m=e.getTokenAt(r.row,r.column);if(!m)return[];if(a(m,"tag-name")||a(m,"tag-open")||a(m,"end-tag-open"))return this.getTagCompletions(n,e,r,l);if(a(m,"tag-whitespace")||a(m,"attribute-name"))return this.getAttributeCompletions(n,e,r,l);if(a(m,"attribute-value"))return this.getAttributeValueCompletions(n,e,r,l);var x=e.getLine(r.row).substr(0,r.column);return/&[a-z]*$/i.test(x)?this.getHTMLEntityCompletions(n,e,r,l):[]},this.getTagCompletions=function(n,e,r,l){return d.map(function(m){return{value:m,meta:"tag",score:1e6}})},this.getAttributeCompletions=function(n,e,r,l){var m=u(e,r);if(!m)return[];var x=c;return m in o&&(x=x.concat(Object.keys(o[m]))),x.map(function(k){return{caption:k,snippet:k+'="$0"',meta:"attribute",score:1e6}})},this.getAttributeValueCompletions=function(n,e,r,l){var m=u(e,r),x=function s(n,e){for(var r=new f(n,e.row,e.column),l=r.getCurrentToken();l&&!a(l,"attribute-name");)l=r.stepBackward();if(l)return l.value}(e,r);if(!m)return[];var k=[];return m in o&&x in o[m]&&"object"==typeof o[m][x]&&(k=Object.keys(o[m][x])),k.map(function(v){return{caption:v,snippet:v,meta:"attribute value",score:1e6}})},this.getHTMLEntityCompletions=function(n,e,r,l){return["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"].map(function(x){return{caption:x,snippet:x,meta:"html entity",score:1e6}})}}).call(t.prototype),h.HtmlCompletions=t}),ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(i,h,b){"use strict";var f=i("../lib/oop"),p=i("../lib/lang"),g=i("./text").Mode,c=i("./javascript").Mode,o=i("./css").Mode,d=i("./html_highlight_rules").HtmlHighlightRules,a=i("./behaviour/xml").XmlBehaviour,u=i("./folding/html").FoldMode,s=i("./html_completions").HtmlCompletions,t=i("../worker/worker_client").WorkerClient,n=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"],e=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"],r=function(l){this.fragmentContext=l&&l.fragmentContext,this.HighlightRules=d,this.$behaviour=new a,this.$completer=new s,this.createModeDelegates({"js-":c,"css-":o}),this.foldingRules=new u(this.voidElements,p.arrayToMap(e))};f.inherits(r,g),function(){this.blockComment={start:"\x3c!--",end:"--\x3e"},this.voidElements=p.arrayToMap(n),this.getNextLineIndent=function(l,m,x){return this.$getIndent(m)},this.checkOutdent=function(l,m,x){return!1},this.getCompletions=function(l,m,x,k){return this.$completer.getCompletions(l,m,x,k)},this.createWorker=function(l){if(this.constructor==r){var m=new t(["ace"],"ace/mode/html_worker","Worker");return m.attachToDocument(l.getDocument()),this.fragmentContext&&m.call("setOptions",[{context:this.fragmentContext}]),m.on("error",function(x){l.setAnnotations(x.data)}),m.on("terminate",function(){l.clearAnnotations()}),m}},this.$id="ace/mode/html",this.snippetFileId="ace/snippets/html"}.call(r.prototype),h.Mode=r}),ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(i,h,b){"use strict";var f=i("../lib/oop"),p=i("./text_highlight_rules").TextHighlightRules,g=function(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"punctuation.operator",regex:/[,]/},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}};f.inherits(g,p),h.JsonHighlightRules=g}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(i,h,b){"use strict";var f=i("../lib/oop"),p=i("./text").Mode,g=i("./json_highlight_rules").JsonHighlightRules,c=i("./matching_brace_outdent").MatchingBraceOutdent,o=i("./behaviour/cstyle").CstyleBehaviour,d=i("./folding/cstyle").FoldMode,a=i("../worker/worker_client").WorkerClient,u=function(){this.HighlightRules=g,this.$outdent=new c,this.$behaviour=new o,this.foldingRules=new d};f.inherits(u,p),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(s,t,n){var e=this.$getIndent(t);return"start"==s&&t.match(/^.*[\{\(\[]\s*$/)&&(e+=n),e},this.checkOutdent=function(s,t,n){return this.$outdent.checkOutdent(t,n)},this.autoOutdent=function(s,t,n){this.$outdent.autoOutdent(t,n)},this.createWorker=function(s){var t=new a(["ace"],"ace/mode/json_worker","JsonWorker");return t.attachToDocument(s.getDocument()),t.on("annotate",function(n){s.setAnnotations(n.data)}),t.on("terminate",function(){s.clearAnnotations()}),t},this.$id="ace/mode/json"}.call(u.prototype),h.Mode=u}),ace.define("ace/mode/liquid_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules","ace/mode/css_highlight_rules","ace/mode/html_highlight_rules","ace/mode/json_highlight_rules","ace/mode/javascript_highlight_rules"],function(i,h,b){"use strict";var f=i("../lib/oop"),p=i("./text_highlight_rules").TextHighlightRules,g=i("./css_highlight_rules").CssHighlightRules,c=i("./html_highlight_rules").HtmlHighlightRules,o=i("./json_highlight_rules").JsonHighlightRules,d=i("./javascript_highlight_rules").JavaScriptHighlightRules,a=function(){function u(t){var n=t.length;return function(e){var r=e.indexOf(t);return[{type:"meta.tag.punctuation.tag-open",value:"{%"},{type:"text",value:e.slice(2,r)},{type:"keyword.tag"+t+".tag-name",value:e.slice(r,r+n)},{type:"text",value:e.slice(r+n,e.indexOf("%}"))},{type:"meta.tag.punctuation.tag-close",value:"%}"}]}}for(var s in c.call(this),this.$rules)this.$rules[s].unshift({token:"comment.block",regex:/{%-?\s*comment\s*-?%}/,next:[{token:"comment.block",regex:/{%-?\s*endcomment\s*-?%}/,next:"pop"},{defaultToken:"comment",caseInsensitive:!1}]},{token:"comment.line",regex:/{%-?\s*#/,next:[{token:"comment.line",regex:/-?%}/,next:"pop"},{defaultToken:"comment",caseInsensitive:!1}]},{token:"style.embedded.start",regex:/({%-?\s*\bstyle\b\s*-?%})/,next:"style-start",onMatch:u("style")},{regex:/({%-?\s*\bstylesheet\b\s*-?%})/,next:"stylesheet-start",onMatch:u("stylesheet")},{regex:/({%-?\s*\bschema\b\s*-?%})/,next:"schema-start",onMatch:u("schema")},{regex:/({%-?\s*\bjavascript\b\s*-?%})/,next:"javascript-start",onMatch:u("javascript")},{token:"meta.tag.punctuation.tag-open",regex:/({%)/,next:[{token:"keyword.block",regex:/-?\s*[a-zA-Z_$][a-zA-Z0-9_$]+\b/,next:"liquid-start"},{token:"meta.tag.punctuation.tag-close",regex:/(-?)(%})/,next:"pop"}]},{token:"meta.tag.punctuation.ouput-open",regex:/({{)/,push:"liquid-start"});this.embedRules(o,"schema-",[{token:"schema-start",next:"pop",regex:/({%-?\s*\bendschema\b\s*-?%})/,onMatch:u("endschema")}]),this.embedRules(d,"javascript-",[{token:"javascript-start",next:"pop",regex:/({%-?\s*\bendjavascript\b\s*-?%})/,onMatch:u("endjavascript")}]),this.embedRules(g,"style-",[{token:"style-start",next:"pop",regex:/({%-?\s*\bendstyle\b\s*-?%})/,onMatch:u("endstyle")}]),this.embedRules(g,"stylesheet-",[{token:"stylesheet-start",next:"pop",regex:/({%-?\s*\bendstylesheet\b\s*-?%})/,onMatch:u("endstylesheet")}]),this.addRules({"liquid-start":[{token:"meta.tag.punctuation.ouput-close",regex:/}}/,next:"pop"},{token:"meta.tag.punctuation.tag-close",regex:/%}/,next:"pop"},{token:"string",regex:/['](?:(?:\\.)|(?:[^'\\]))*?[']/},{token:"string",regex:/["](?:(?:\\.)|(?:[^'\\]))*?["]/},{token:"constant.numeric",regex:/0[xX][0-9a-fA-F]+\b/},{token:"constant.numeric",regex:/[+-]?\d+(?:(?:\.\d*)?(?:[eE][+-]?\d+)?)?\b/},{token:"keyword.operator",regex:/\*|\-|\+|=|!=|\?\|\:/},{token:"constant.language.boolean",regex:/(?:true|false|nil|empty)\b/},{token:"keyword.operator",regex:/\s+(?:and|contains|in|with)\b\s+/},{token:["keyword.operator","support.function"],regex:/(\|\s*)([a-zA-Z_]+)/},{token:"support.function",regex:/\s*([a-zA-Z_]+\b)(?=:)/},{token:"keyword.operator",regex:/(:)\s*(?=[a-zA-Z_])/},{token:["support.class","keyword.operator","support.object","keyword.operator","variable.parameter"],regex:/(\w+)(\.)(\w+)(\.)?(\w+)?/},{token:"variable.parameter",regex:/\.([a-zA-Z_$][a-zA-Z0-9_$]*\b)$/},{token:"support.class",regex:/(?:additional_checkout_buttons|content_for_additional_checkout_buttons)\b/},{token:"paren.lparen",regex:/[\[\({]/},{token:"paren.rparen",regex:/[\])}]/},{token:"text",regex:/\s+/}]}),this.normalizeRules()};f.inherits(a,p),h.LiquidHighlightRules=a}),ace.define("ace/mode/liquid",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/html","ace/mode/javascript","ace/mode/json","ace/mode/css","ace/mode/liquid_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle"],function(i,h,b){var f=i("../lib/oop"),p=i("./text").Mode,g=i("./html").Mode,c=i("./javascript").Mode,o=i("./json").Mode,d=i("./css").Mode,a=i("./liquid_highlight_rules").LiquidHighlightRules,s=(i("./matching_brace_outdent"),i("./folding/cstyle").FoldMode),t=function(){o.call(this),g.call(this),d.call(this),c.call(this),this.HighlightRules=a,this.foldingRules=new s};f.inherits(t,p),function(){this.blockComment={start:"\x3c!--",end:"--\x3e"},this.voidElements=(new g).voidElements,this.getNextLineIndent=function(n,e,r){var l=this.$getIndent(e),x=this.getTokenizer().getLineTokens(e,n).tokens;return x.length&&"comment"==x[x.length-1].type||"start"==n&&e.match(/^.*[\{\(\[]\s*$/)&&(l+=r),l},this.checkOutdent=function(n,e,r){return this.$outdent.checkOutdent(e,r)},this.autoOutdent=function(n,e,r){this.$outdent.autoOutdent(e,r)},this.$id="ace/mode/liquid",this.snippetFileId="ace/snippets/liquid"}.call(t.prototype),h.Mode=t}),ace.require(["ace/mode/liquid"],function(i){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=i)});