/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixException;
import org.apache.helix.controller.rebalancer.topology.Topology;
import org.apache.helix.controller.rebalancer.util.WagedValidationUtil;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignableNode
implements Comparable<AssignableNode> {
    private static final Logger LOG = LoggerFactory.getLogger((String)AssignableNode.class.getName());
    private final String _instanceName;
    private final String _faultZone;
    private final int _maxPartition;
    private final ImmutableSet<String> _instanceTags;
    private final ImmutableMap<String, List<String>> _disabledPartitionsMap;
    private final ImmutableMap<String, Integer> _maxAllowedCapacity;
    private Map<String, Map<String, AssignableReplica>> _currentAssignedReplicaMap;
    private Map<String, Integer> _remainingCapacity;
    private Map<String, Integer> _remainingTopStateCapacity;

    AssignableNode(ClusterConfig clusterConfig, InstanceConfig instanceConfig, String instanceName) {
        this._instanceName = instanceName;
        Map<String, Integer> instanceCapacity = this.fetchInstanceCapacity(clusterConfig, instanceConfig);
        this._faultZone = this.computeFaultZone(clusterConfig, instanceConfig);
        this._instanceTags = ImmutableSet.copyOf(instanceConfig.getTags());
        this._disabledPartitionsMap = ImmutableMap.copyOf(instanceConfig.getDisabledPartitionsMap());
        this._maxAllowedCapacity = ImmutableMap.copyOf(instanceCapacity);
        this._remainingCapacity = new HashMap<String, Integer>(instanceCapacity);
        this._remainingTopStateCapacity = new HashMap<String, Integer>(instanceCapacity);
        this._maxPartition = clusterConfig.getMaxPartitionsPerInstance();
        this._currentAssignedReplicaMap = new HashMap<String, Map<String, AssignableReplica>>();
    }

    void assignInitBatch(Collection<AssignableReplica> replicas) {
        HashMap<String, Integer> totalTopStatePartitionCapacity = new HashMap<String, Integer>();
        HashMap<String, Integer> totalPartitionCapacity = new HashMap<String, Integer>();
        for (AssignableReplica replica : replicas) {
            this.addToAssignmentRecord(replica);
            for (Map.Entry<String, Integer> capacity : replica.getCapacity().entrySet()) {
                if (replica.isReplicaTopState()) {
                    totalTopStatePartitionCapacity.compute(capacity.getKey(), (key, totalValue) -> totalValue == null ? (Integer)capacity.getValue() : totalValue + (Integer)capacity.getValue());
                }
                totalPartitionCapacity.compute(capacity.getKey(), (key, totalValue) -> totalValue == null ? (Integer)capacity.getValue() : totalValue + (Integer)capacity.getValue());
            }
        }
        this.updateRemainingCapacity(totalTopStatePartitionCapacity, this._remainingTopStateCapacity, false);
        this.updateRemainingCapacity(totalPartitionCapacity, this._remainingCapacity, false);
    }

    void assign(AssignableReplica assignableReplica) {
        this.addToAssignmentRecord(assignableReplica);
        this.updateRemainingCapacity(assignableReplica.getCapacity(), this._remainingCapacity, false);
        if (assignableReplica.isReplicaTopState()) {
            this.updateRemainingCapacity(assignableReplica.getCapacity(), this._remainingTopStateCapacity, false);
        }
    }

    void release(AssignableReplica replica) throws IllegalArgumentException {
        String resourceName = replica.getResourceName();
        String partitionName = replica.getPartitionName();
        if (!this._currentAssignedReplicaMap.containsKey(resourceName)) {
            LOG.warn("Resource {} is not on node {}. Ignore the release call.", (Object)resourceName, (Object)this.getInstanceName());
            return;
        }
        Map<String, AssignableReplica> partitionMap = this._currentAssignedReplicaMap.get(resourceName);
        if (!partitionMap.containsKey(partitionName) || !partitionMap.get(partitionName).equals(replica)) {
            LOG.warn("Replica {} is not assigned to node {}. Ignore the release call.", (Object)replica.toString(), (Object)this.getInstanceName());
            return;
        }
        AssignableReplica removedReplica = partitionMap.remove(partitionName);
        this.updateRemainingCapacity(removedReplica.getCapacity(), this._remainingCapacity, true);
        if (removedReplica.isReplicaTopState()) {
            this.updateRemainingCapacity(removedReplica.getCapacity(), this._remainingTopStateCapacity, true);
        }
    }

    Set<AssignableReplica> getAssignedReplicas() {
        return this._currentAssignedReplicaMap.values().stream().flatMap(replicaMap -> replicaMap.values().stream()).collect(Collectors.toSet());
    }

    Map<String, Set<String>> getAssignedPartitionsMap() {
        HashMap<String, Set<String>> assignmentMap = new HashMap<String, Set<String>>();
        for (String resourceName : this._currentAssignedReplicaMap.keySet()) {
            assignmentMap.put(resourceName, this._currentAssignedReplicaMap.get(resourceName).keySet());
        }
        return assignmentMap;
    }

    public Set<String> getAssignedPartitionsByResource(String resource) {
        return this._currentAssignedReplicaMap.getOrDefault(resource, Collections.emptyMap()).keySet();
    }

    Set<String> getAssignedTopStatePartitionsByResource(String resource) {
        return this._currentAssignedReplicaMap.getOrDefault(resource, Collections.emptyMap()).entrySet().stream().filter(partitionEntry -> ((AssignableReplica)partitionEntry.getValue()).isReplicaTopState()).map(partitionEntry -> (String)partitionEntry.getKey()).collect(Collectors.toSet());
    }

    public int getAssignedTopStatePartitionsCount() {
        return (int)this._currentAssignedReplicaMap.values().stream().flatMap(replicaMap -> replicaMap.values().stream()).filter(AssignableReplica::isReplicaTopState).count();
    }

    public int getAssignedReplicaCount() {
        return this._currentAssignedReplicaMap.values().stream().mapToInt(Map::size).sum();
    }

    public Map<String, Integer> getRemainingCapacity() {
        return this._remainingCapacity;
    }

    public Map<String, Integer> getMaxCapacity() {
        return this._maxAllowedCapacity;
    }

    public float getGeneralProjectedHighestUtilization(Map<String, Integer> newUsage) {
        return this.getProjectedHighestUtilization(newUsage, this._remainingCapacity);
    }

    public float getTopStateProjectedHighestUtilization(Map<String, Integer> newUsage) {
        return this.getProjectedHighestUtilization(newUsage, this._remainingTopStateCapacity);
    }

    private float getProjectedHighestUtilization(Map<String, Integer> newUsage, Map<String, Integer> remainingCapacity) {
        float highestCapacityUtilization = 0.0f;
        for (String capacityKey : this._maxAllowedCapacity.keySet()) {
            float capacityValue = ((Integer)this._maxAllowedCapacity.get((Object)capacityKey)).intValue();
            float utilization = (capacityValue - (float)remainingCapacity.get(capacityKey).intValue() + (float)newUsage.getOrDefault(capacityKey, 0).intValue()) / capacityValue;
            highestCapacityUtilization = Math.max(highestCapacityUtilization, utilization);
        }
        return highestCapacityUtilization;
    }

    public String getInstanceName() {
        return this._instanceName;
    }

    public Set<String> getInstanceTags() {
        return this._instanceTags;
    }

    public String getFaultZone() {
        return this._faultZone;
    }

    public boolean hasFaultZone() {
        return this._faultZone != null;
    }

    public Map<String, List<String>> getDisabledPartitionsMap() {
        return this._disabledPartitionsMap;
    }

    public int getMaxPartition() {
        return this._maxPartition;
    }

    private String computeFaultZone(ClusterConfig clusterConfig, InstanceConfig instanceConfig) {
        LinkedHashMap<String, String> instanceTopologyMap = Topology.computeInstanceTopologyMap(clusterConfig, instanceConfig.getInstanceName(), instanceConfig, true);
        StringBuilder faultZoneStringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : instanceTopologyMap.entrySet()) {
            faultZoneStringBuilder.append(entry.getValue());
            faultZoneStringBuilder.append('/');
        }
        faultZoneStringBuilder.setLength(faultZoneStringBuilder.length() - 1);
        return faultZoneStringBuilder.toString();
    }

    private void addToAssignmentRecord(AssignableReplica replica) {
        String resourceName = replica.getResourceName();
        String partitionName = replica.getPartitionName();
        if (this._currentAssignedReplicaMap.containsKey(resourceName) && this._currentAssignedReplicaMap.get(resourceName).containsKey(partitionName)) {
            throw new HelixException(String.format("Resource %s already has a replica with state %s from partition %s on node %s", replica.getResourceName(), replica.getReplicaState(), replica.getPartitionName(), this.getInstanceName()));
        }
        this._currentAssignedReplicaMap.computeIfAbsent(resourceName, key -> new HashMap()).put(partitionName, replica);
    }

    private void updateRemainingCapacity(Map<String, Integer> usedCapacity, Map<String, Integer> remainingCapacity, boolean isRelease) {
        int multiplier = isRelease ? -1 : 1;
        usedCapacity.forEach((capacityKey, capacityValue) -> remainingCapacity.compute((String)capacityKey, (key, value) -> value == null ? null : Integer.valueOf(value - multiplier * capacityValue)));
    }

    private Map<String, Integer> fetchInstanceCapacity(ClusterConfig clusterConfig, InstanceConfig instanceConfig) {
        Map<String, Integer> instanceCapacity = WagedValidationUtil.validateAndGetInstanceCapacity(clusterConfig, instanceConfig);
        instanceCapacity.keySet().retainAll(clusterConfig.getInstanceCapacityKeys());
        return instanceCapacity;
    }

    public int hashCode() {
        return this._instanceName.hashCode();
    }

    @Override
    public int compareTo(AssignableNode o) {
        return this._instanceName.compareTo(o.getInstanceName());
    }

    public String toString() {
        return this._instanceName;
    }
}

