/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.ClusterVerifiers;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.manager.zk.GenericZkHelixApiBuilder;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.tools.ClusterVerifiers.HelixClusterVerifier;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkHelixClusterVerifier
implements IZkChildListener,
IZkDataListener,
HelixClusterVerifier,
AutoCloseable {
    private static Logger LOG = LoggerFactory.getLogger(ZkHelixClusterVerifier.class);
    protected static int DEFAULT_TIMEOUT = 300000;
    protected static int DEFAULT_PERIOD = 500;
    protected final RealmAwareZkClient _zkClient;
    private final boolean _usesExternalZkClient;
    protected final String _clusterName;
    protected final HelixDataAccessor _accessor;
    protected final PropertyKey.Builder _keyBuilder;
    private CountDownLatch _countdown;
    protected final int _waitPeriodTillVerify;
    private ExecutorService _verifyTaskThreadPool = Executors.newSingleThreadExecutor(r -> new Thread(r, "ZkHelixClusterVerifier-verify_thread"));

    protected ZkHelixClusterVerifier(RealmAwareZkClient zkClient, String clusterName, boolean usesExternalZkClient, int waitPeriodTillVerify) {
        if (zkClient == null || clusterName == null) {
            throw new IllegalArgumentException("requires zkClient|clusterName");
        }
        this._zkClient = zkClient;
        this._usesExternalZkClient = usesExternalZkClient;
        this._clusterName = clusterName;
        this._accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        this._keyBuilder = this._accessor.keyBuilder();
        this._waitPeriodTillVerify = waitPeriodTillVerify;
    }

    @Deprecated
    public ZkHelixClusterVerifier(String zkAddr, String clusterName, int waitPeriodTillVerify) {
        if (clusterName == null || clusterName.isEmpty()) {
            throw new IllegalArgumentException("ZkHelixClusterVerifier: clusterName is null or empty!");
        }
        if (Boolean.getBoolean("helix.multiZkEnabled") || zkAddr == null) {
            LOG.info("ZkHelixClusterVerifier: zkAddr is null or multi-zk mode is enabled in System Properties. Instantiating in multi-zk mode!");
            try {
                RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder connectionConfigBuilder = new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder();
                connectionConfigBuilder.setZkRealmShardingKey("/" + clusterName);
                RealmAwareZkClient.RealmAwareZkClientConfig clientConfig = new RealmAwareZkClient.RealmAwareZkClientConfig();
                this._zkClient = DedicatedZkClientFactory.getInstance().buildZkClient(connectionConfigBuilder.build(), clientConfig);
            }
            catch (IllegalStateException | InvalidRoutingDataException e) {
                throw new HelixException("ZkHelixClusterVerifier: failed to create ZkClient!", e);
            }
        } else {
            this._zkClient = DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddr));
        }
        this._usesExternalZkClient = false;
        this._zkClient.setZkSerializer(new ZNRecordSerializer());
        this._clusterName = clusterName;
        this._accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        this._keyBuilder = this._accessor.keyBuilder();
        this._waitPeriodTillVerify = waitPeriodTillVerify;
    }

    @Override
    public boolean verify(long timeout) {
        return this.verifyByZkCallback(timeout);
    }

    @Override
    public boolean verify() {
        return this.verify(DEFAULT_TIMEOUT);
    }

    public abstract boolean verifyByZkCallback(long var1);

    public boolean verifyByZkCallback() {
        return this.verifyByZkCallback(DEFAULT_TIMEOUT);
    }

    protected void waitTillVerify() {
        try {
            if (this._waitPeriodTillVerify != 0) {
                Thread.sleep(this._waitPeriodTillVerify);
            }
        }
        catch (InterruptedException e) {
            LOG.error("cooldown in verifyByPolling interrupted");
        }
    }

    public boolean verifyByPolling(long timeout, long period) {
        this.waitTillVerify();
        try {
            long start = System.currentTimeMillis();
            do {
                boolean success;
                if (success = this.verifyState()) {
                    return true;
                }
                TimeUnit.MILLISECONDS.sleep(period);
            } while (System.currentTimeMillis() - start <= timeout);
            LOG.error("verifier timeout out with timeout {}", (Object)timeout);
        }
        catch (Exception e) {
            LOG.error("Exception in verifier", (Throwable)e);
        }
        return false;
    }

    public boolean verifyByPolling() {
        return this.verifyByPolling(DEFAULT_TIMEOUT, DEFAULT_PERIOD);
    }

    @Override
    public void close() {
        if (this._zkClient != null && !this._usesExternalZkClient) {
            this._zkClient.close();
        }
    }

    protected boolean verifyByCallback(long timeout, List<ClusterVerifyTrigger> triggers) {
        this._countdown = new CountDownLatch(1);
        for (ClusterVerifyTrigger trigger : triggers) {
            this.subscribeTrigger(trigger);
        }
        boolean success = false;
        try {
            success = this.verifyState();
            if (!(success || (success = this._countdown.await(timeout, TimeUnit.MILLISECONDS)) || (success = this.verifyState()))) {
                LOG.error("verifyByCallback failed due to timeout {}", (Object)timeout);
            }
        }
        catch (Exception e) {
            LOG.error("Exception in verifier", (Throwable)e);
        }
        this._zkClient.unsubscribeAll();
        this._verifyTaskThreadPool.shutdownNow();
        return success;
    }

    private void subscribeTrigger(ClusterVerifyTrigger trigger) {
        String path = trigger.getTriggerKey().getPath();
        if (trigger.isTriggerOnDataChange()) {
            this._zkClient.subscribeDataChanges(path, this);
        }
        if (trigger.isTriggerOnChildChange()) {
            this._zkClient.subscribeChildChanges(path, this);
        }
        if (trigger.isTriggerOnChildDataChange()) {
            List<String> childs = this._zkClient.getChildren(path);
            for (String child : childs) {
                String childPath = String.format("%s/%s", path, child);
                this._zkClient.subscribeDataChanges(childPath, this);
            }
        }
    }

    protected abstract boolean verifyState() throws Exception;

    @Override
    @PreFetch(enabled=false)
    public void handleDataChange(String dataPath, Object data) throws Exception {
        if (!this._verifyTaskThreadPool.isShutdown()) {
            this._verifyTaskThreadPool.submit(new VerifyStateCallbackTask());
        }
    }

    @Override
    public void handleDataDeleted(String dataPath) throws Exception {
        this._zkClient.unsubscribeDataChanges(dataPath, this);
        if (!this._verifyTaskThreadPool.isShutdown()) {
            this._verifyTaskThreadPool.submit(new VerifyStateCallbackTask());
        }
    }

    @Override
    public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
        for (String child : currentChilds) {
            String childPath = String.format("%s/%s", parentPath, child);
            this._zkClient.subscribeDataChanges(childPath, this);
        }
        if (!this._verifyTaskThreadPool.isShutdown()) {
            this._verifyTaskThreadPool.submit(new VerifyStateCallbackTask());
        }
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public void finalize() {
        this.close();
    }

    protected static abstract class Builder<B extends Builder<B>>
    extends GenericZkHelixApiBuilder<B> {
        protected int _waitPeriodTillVerify;

        public Builder() {
            this.setRealmMode(RealmAwareZkClient.RealmMode.SINGLE_REALM);
        }

        @Deprecated
        public B setZkAddr(String zkAddress) {
            return (B)((Builder)this.setZkAddress(zkAddress));
        }

        public B setWaitTillVerify(int waitPeriod) {
            this._waitPeriodTillVerify = waitPeriod;
            return (B)this;
        }

        public String getClusterName() {
            if (this._realmAwareZkConnectionConfig != null && this._realmAwareZkConnectionConfig.getZkRealmShardingKey() != null && !this._realmAwareZkConnectionConfig.getZkRealmShardingKey().isEmpty()) {
                return this._realmAwareZkConnectionConfig.getZkRealmShardingKey().substring(1);
            }
            throw new HelixException("Failed to get the cluster name! Either RealmAwareZkConnectionConfig is null or its sharding key is null or empty!");
        }

        @Override
        protected void validate() {
            if ((this._zkAddress == null || this._zkAddress.isEmpty()) && (this._realmAwareZkConnectionConfig == null || this._realmAwareZkConnectionConfig.getZkRealmShardingKey() == null || this._realmAwareZkConnectionConfig.getZkRealmShardingKey().isEmpty())) {
                throw new IllegalArgumentException("ZkHelixClusterVerifier: one of either ZkAddress or ZkRealmShardingKey must be set! ZkAddress: " + this._zkAddress + " RealmAwareZkConnectionConfig: " + this._realmAwareZkConnectionConfig);
            }
            this.initializeConfigsIfNull();
        }

        @Override
        protected RealmAwareZkClient createZkClient(RealmAwareZkClient.RealmMode realmMode, RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig clientConfig, String zkAddress) {
            if (Boolean.getBoolean("helix.multiZkEnabled") || zkAddress == null) {
                try {
                    return DedicatedZkClientFactory.getInstance().buildZkClient(connectionConfig, clientConfig);
                }
                catch (IllegalStateException | InvalidRoutingDataException e) {
                    throw new HelixException("ZkHelixClusterVerifier: failed to create ZkClient!", e);
                }
            }
            return DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress));
        }
    }

    class VerifyStateCallbackTask
    implements Runnable {
        VerifyStateCallbackTask() {
        }

        @Override
        public void run() {
            try {
                boolean success = ZkHelixClusterVerifier.this.verifyState();
                if (success) {
                    ZkHelixClusterVerifier.this._countdown.countDown();
                }
            }
            catch (Exception ex) {
                LOG.info("verifyState() throws exception: " + ex);
            }
        }
    }

    protected static class ClusterVerifyTrigger {
        final PropertyKey _triggerKey;
        final boolean _triggerOnDataChange;
        final boolean _triggerOnChildChange;
        final boolean _triggerOnChildDataChange;

        public ClusterVerifyTrigger(PropertyKey triggerKey, boolean triggerOnDataChange, boolean triggerOnChildChange, boolean triggerOnChildDataChange) {
            this._triggerKey = triggerKey;
            this._triggerOnDataChange = triggerOnDataChange;
            this._triggerOnChildChange = triggerOnChildChange;
            this._triggerOnChildDataChange = triggerOnChildDataChange;
        }

        public boolean isTriggerOnDataChange() {
            return this._triggerOnDataChange;
        }

        public PropertyKey getTriggerKey() {
            return this._triggerKey;
        }

        public boolean isTriggerOnChildChange() {
            return this._triggerOnChildChange;
        }

        public boolean isTriggerOnChildDataChange() {
            return this._triggerOnChildDataChange;
        }
    }
}

