/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.api.config.StateTransitionThrottleConfig;
import org.apache.helix.model.ClusterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateTransitionThrottleController {
    private static Logger logger = LoggerFactory.getLogger(StateTransitionThrottleController.class);
    Map<StateTransitionThrottleConfig.RebalanceType, Long> _pendingTransitionAllowedInCluster = new HashMap<StateTransitionThrottleConfig.RebalanceType, Long>();
    Map<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>> _pendingTransitionAllowedPerInstance = new HashMap<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>>();
    Map<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>> _pendingTransitionAllowedPerResource = new HashMap<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>>();
    private boolean _throttleEnabled = false;

    StateTransitionThrottleController(Set<String> resources, ClusterConfig clusterConfig, Set<String> liveInstances) {
        if (clusterConfig == null) {
            logger.warn("Cluster config is not found, no throttle config set!");
            return;
        }
        List<StateTransitionThrottleConfig> throttleConfigs = clusterConfig.getStateTransitionThrottleConfigs();
        if (throttleConfigs == null || throttleConfigs.isEmpty()) {
            logger.info("No throttle config is set!");
            return;
        }
        for (StateTransitionThrottleConfig config : throttleConfigs) {
            switch (config.getThrottleScope()) {
                case CLUSTER: {
                    this._pendingTransitionAllowedInCluster.put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    this._throttleEnabled = true;
                    break;
                }
                case RESOURCE: {
                    for (String resource : resources) {
                        if (!this._pendingTransitionAllowedPerResource.containsKey(resource)) {
                            this._pendingTransitionAllowedPerResource.put(resource, new HashMap());
                        }
                        this._pendingTransitionAllowedPerResource.get(resource).put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    }
                    this._throttleEnabled = true;
                    break;
                }
                case INSTANCE: {
                    for (String instance : liveInstances) {
                        if (!this._pendingTransitionAllowedPerInstance.containsKey(instance)) {
                            this._pendingTransitionAllowedPerInstance.put(instance, new HashMap());
                        }
                        this._pendingTransitionAllowedPerInstance.get(instance).put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    }
                    this._throttleEnabled = true;
                }
            }
        }
    }

    protected boolean isThrottleEnabled() {
        return this._throttleEnabled;
    }

    protected boolean shouldThrottleForCluster(StateTransitionThrottleConfig.RebalanceType rebalanceType) {
        if (this.shouldThrottleForANYType(this._pendingTransitionAllowedInCluster)) {
            return true;
        }
        Long clusterThrottle = this._pendingTransitionAllowedInCluster.get((Object)rebalanceType);
        return clusterThrottle != null && clusterThrottle <= 0L;
    }

    protected boolean shouldThrottleForResource(StateTransitionThrottleConfig.RebalanceType rebalanceType, String resourceName) {
        if (this.shouldThrottleForCluster(rebalanceType)) {
            return true;
        }
        if (this._pendingTransitionAllowedPerResource.containsKey(resourceName)) {
            Long resourceThrottle = this._pendingTransitionAllowedPerResource.get(resourceName).get((Object)rebalanceType);
            if (this.shouldThrottleForANYType(this._pendingTransitionAllowedPerResource.get(resourceName)) || resourceThrottle != null && resourceThrottle <= 0L) {
                return true;
            }
        }
        return false;
    }

    protected boolean shouldThrottleForInstance(StateTransitionThrottleConfig.RebalanceType rebalanceType, String instanceName) {
        if (this.shouldThrottleForCluster(rebalanceType)) {
            return true;
        }
        if (this._pendingTransitionAllowedPerInstance.containsKey(instanceName)) {
            Long instanceThrottle = this._pendingTransitionAllowedPerInstance.get(instanceName).get((Object)rebalanceType);
            if (this.shouldThrottleForANYType(this._pendingTransitionAllowedPerInstance.get(instanceName)) || instanceThrottle != null && instanceThrottle <= 0L) {
                return true;
            }
        }
        return false;
    }

    protected void chargeCluster(StateTransitionThrottleConfig.RebalanceType rebalanceType) {
        this.charge(rebalanceType, this._pendingTransitionAllowedInCluster);
    }

    protected void chargeResource(StateTransitionThrottleConfig.RebalanceType rebalanceType, String resource) {
        this.charge(rebalanceType, this._pendingTransitionAllowedPerResource.getOrDefault(resource, new HashMap()));
    }

    protected void chargeInstance(StateTransitionThrottleConfig.RebalanceType rebalanceType, String instance) {
        this.charge(rebalanceType, this._pendingTransitionAllowedPerInstance.getOrDefault(instance, new HashMap()));
    }

    private void charge(StateTransitionThrottleConfig.RebalanceType rebalanceType, Map<StateTransitionThrottleConfig.RebalanceType, Long> quota) {
        if (StateTransitionThrottleConfig.RebalanceType.NONE.equals((Object)rebalanceType)) {
            logger.error("Wrong rebalance type NONE as parameter");
            return;
        }
        quota.computeIfPresent(StateTransitionThrottleConfig.RebalanceType.ANY, (type, quotaNumber) -> Math.max(0L, quotaNumber - 1L));
        if (!rebalanceType.equals((Object)StateTransitionThrottleConfig.RebalanceType.ANY)) {
            quota.computeIfPresent(rebalanceType, (type, quotaNumber) -> Math.max(0L, quotaNumber - 1L));
        }
    }

    private boolean shouldThrottleForANYType(Map<StateTransitionThrottleConfig.RebalanceType, Long> pendingTransitionAllowed) {
        Long anyTypeThrottle;
        return pendingTransitionAllowed.containsKey((Object)StateTransitionThrottleConfig.RebalanceType.ANY) && (anyTypeThrottle = pendingTransitionAllowed.get((Object)StateTransitionThrottleConfig.RebalanceType.ANY)) != null && anyTypeThrottle <= 0L;
    }
}

