/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(JobResource.class);

    public JobResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation;
        String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
        String jobQueueName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.JOB_QUEUE);
        String jobName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.JOB);
        try {
            presentation = this.getHostedEntitiesRepresentation(clusterName, jobQueueName, jobName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Fail to get job: " + jobName, (Throwable)e);
        }
        return presentation;
    }

    public Representation delete() {
        StringRepresentation representation = null;
        String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
        String jobQueueName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.JOB_QUEUE);
        String jobName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.JOB);
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        TaskDriver driver = new TaskDriver((RealmAwareZkClient)zkClient, clusterName);
        try {
            driver.deleteJob(jobQueueName, jobName);
            this.getResponse().setStatus(Status.SUCCESS_NO_CONTENT);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            representation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Fail to delete job: " + jobName, (Throwable)e);
        }
        return representation;
    }

    StringRepresentation getHostedEntitiesRepresentation(String clusterName, String jobQueueName, String jobName) throws Exception {
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        String namespacedJobName = TaskUtil.getNamespacedJobName((String)jobQueueName, (String)jobName);
        HelixProperty jobConfig = accessor.getProperty(keyBuilder.resourceConfig(namespacedJobName));
        TaskDriver taskDriver = new TaskDriver((RealmAwareZkClient)zkClient, clusterName);
        JobContext ctx = taskDriver.getJobContext(namespacedJobName);
        ZNRecord hostedEntitiesRecord = new ZNRecord(namespacedJobName);
        if (jobConfig != null) {
            hostedEntitiesRecord.merge(jobConfig.getRecord());
        }
        if (ctx != null) {
            hostedEntitiesRecord.merge(ctx.getRecord());
        }
        StringRepresentation representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(hostedEntitiesRecord), MediaType.APPLICATION_JSON);
        return representation;
    }
}

