/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.dialogs.AttributeTypeSelectionDialog;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class NewObjectClassMandatoryAttributesPage
extends WizardPage {
    private List<AttributeType> mandatoryAttributeTypesList;
    private TableViewer mandatoryAttributeTypesTableViewer;
    private Button mandatoryAttributeTypesAddButton;
    private Button mandatoryAttributeTypesRemoveButton;

    protected NewObjectClassMandatoryAttributesPage() {
        super("NewObjectClassMandatoryAttributesPage");
        this.setTitle(Messages.getString("NewObjectClassMandatoryAttributesPage.MandatoryAttributeTypes"));
        this.setDescription(Messages.getString("NewObjectClassMandatoryAttributesPage.SpecifiyMandatoryAttributeTypeForObjectClass"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/object_class_new_wizard.png"));
        this.mandatoryAttributeTypesList = new ArrayList<AttributeType>();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group mandatoryAttributeTypesGroup = new Group(composite, 0);
        mandatoryAttributeTypesGroup.setText(Messages.getString("NewObjectClassMandatoryAttributesPage.MandatoryAttributeTypes"));
        mandatoryAttributeTypesGroup.setLayout((Layout)new GridLayout(2, false));
        mandatoryAttributeTypesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Table mandatoryAttributeTypesTable = new Table((Composite)mandatoryAttributeTypesGroup, 2048);
        GridData mandatoryAttributeTypesTableGridData = new GridData(4, 4, true, true, 1, 2);
        mandatoryAttributeTypesTableGridData.heightHint = 100;
        mandatoryAttributeTypesTable.setLayoutData((Object)mandatoryAttributeTypesTableGridData);
        this.mandatoryAttributeTypesTableViewer = new TableViewer(mandatoryAttributeTypesTable);
        this.mandatoryAttributeTypesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mandatoryAttributeTypesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof AttributeType) {
                    return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof AttributeType) {
                    AttributeType at = (AttributeType)element;
                    List names = at.getNames();
                    if (names != null && names.size() > 0) {
                        return NLS.bind((String)Messages.getString("NewObjectClassMandatoryAttributesPage.AliasOID"), (Object[])new String[]{ViewUtils.concateAliases(names), at.getOid()});
                    }
                    return NLS.bind((String)Messages.getString("NewObjectClassMandatoryAttributesPage.NoneOID"), (Object[])new String[]{at.getOid()});
                }
                return super.getText(element);
            }
        });
        this.mandatoryAttributeTypesTableViewer.setInput(this.mandatoryAttributeTypesList);
        this.mandatoryAttributeTypesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewObjectClassMandatoryAttributesPage.this.mandatoryAttributeTypesRemoveButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.mandatoryAttributeTypesAddButton = new Button((Composite)mandatoryAttributeTypesGroup, 8);
        this.mandatoryAttributeTypesAddButton.setText(Messages.getString("NewObjectClassMandatoryAttributesPage.Add"));
        this.mandatoryAttributeTypesAddButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.mandatoryAttributeTypesAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassMandatoryAttributesPage.this.addMandatoryAttributeType();
            }
        });
        this.mandatoryAttributeTypesRemoveButton = new Button((Composite)mandatoryAttributeTypesGroup, 8);
        this.mandatoryAttributeTypesRemoveButton.setText(Messages.getString("NewObjectClassMandatoryAttributesPage.Remove"));
        this.mandatoryAttributeTypesRemoveButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.mandatoryAttributeTypesRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewObjectClassMandatoryAttributesPage.this.removeMandatoryAttributeType();
            }
        });
        this.mandatoryAttributeTypesRemoveButton.setEnabled(false);
        this.setControl((Control)composite);
    }

    private void addMandatoryAttributeType() {
        AttributeTypeSelectionDialog dialog = new AttributeTypeSelectionDialog();
        ArrayList<AttributeType> hiddenAttributes = new ArrayList<AttributeType>();
        hiddenAttributes.addAll(this.mandatoryAttributeTypesList);
        dialog.setHiddenAttributeTypes(hiddenAttributes);
        if (dialog.open() == 0) {
            this.mandatoryAttributeTypesList.add(dialog.getSelectedAttributeType());
            this.updateMandatoryAttributeTypesTableTable();
        }
    }

    private void removeMandatoryAttributeType() {
        StructuredSelection selection = (StructuredSelection)this.mandatoryAttributeTypesTableViewer.getSelection();
        if (!selection.isEmpty()) {
            this.mandatoryAttributeTypesList.remove(selection.getFirstElement());
            this.updateMandatoryAttributeTypesTableTable();
        }
    }

    private void updateMandatoryAttributeTypesTableTable() {
        Collections.sort(this.mandatoryAttributeTypesList, new Comparator<AttributeType>(){

            @Override
            public int compare(AttributeType o1, AttributeType o2) {
                List at1Names = o1.getNames();
                List at2Names = o2.getNames();
                if (at1Names != null && at2Names != null && at1Names.size() > 0 && at2Names.size() > 0) {
                    return ((String)at1Names.get(0)).compareToIgnoreCase((String)at2Names.get(0));
                }
                return 0;
            }
        });
        this.mandatoryAttributeTypesTableViewer.refresh();
    }

    public List<AttributeType> getMandatoryAttributeTypes() {
        return this.mandatoryAttributeTypesList;
    }

    public List<String> getMandatoryAttributeTypesNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeType at : this.mandatoryAttributeTypesList) {
            names.add(at.getName());
        }
        return names;
    }
}

