/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.common.field.AuthorField;
import org.odftoolkit.simple.common.field.ChapterField;
import org.odftoolkit.simple.common.field.ConditionField;
import org.odftoolkit.simple.common.field.DateField;
import org.odftoolkit.simple.common.field.PageCountField;
import org.odftoolkit.simple.common.field.PageNumberField;
import org.odftoolkit.simple.common.field.ReferenceField;
import org.odftoolkit.simple.common.field.SubjectField;
import org.odftoolkit.simple.common.field.TimeField;
import org.odftoolkit.simple.common.field.TitleField;
import org.odftoolkit.simple.common.field.VariableContainer;
import org.odftoolkit.simple.common.field.VariableField;

public class Fields {
    public static DateField createDateField(OdfElement odfElement) {
        DateField dateField = new DateField(odfElement);
        dateField.setFixed(false);
        return dateField;
    }

    public static DateField createFixedDateField(OdfElement odfElement) {
        return new DateField(odfElement);
    }

    public static TimeField createTimeField(OdfElement odfElement) {
        TimeField timeField = new TimeField(odfElement);
        timeField.setFixed(false);
        return timeField;
    }

    public static TimeField createFixedTimeField(OdfElement odfElement) {
        return new TimeField(odfElement);
    }

    public static PageNumberField createPreviousPageNumberField(OdfElement odfElement) {
        PageNumberField pageNumberField = new PageNumberField(odfElement);
        pageNumberField.setDisplayPage(PageNumberField.DisplayType.PREVIOUS_PAGE);
        return pageNumberField;
    }

    public static PageNumberField createCurrentPageNumberField(OdfElement odfElement) {
        return new PageNumberField(odfElement);
    }

    public static PageNumberField createNextPageNumberField(OdfElement odfElement) {
        PageNumberField pageNumberField = new PageNumberField(odfElement);
        pageNumberField.setDisplayPage(PageNumberField.DisplayType.NEXT_PAGE);
        return pageNumberField;
    }

    public static PageCountField createPageCountField(OdfElement odfElement) {
        return new PageCountField(odfElement);
    }

    public static TitleField createTitleField(OdfElement odfElement) {
        return new TitleField(odfElement);
    }

    public static SubjectField createSubjectField(OdfElement odfElement) {
        return new SubjectField(odfElement);
    }

    public static AuthorField createAuthorNameField(OdfElement odfElement) {
        return new AuthorField(odfElement, false);
    }

    public static AuthorField createAuthorInitialsField(OdfElement odfElement) {
        return new AuthorField(odfElement, true);
    }

    public static ChapterField createChapterField(OdfElement odfElement) {
        return new ChapterField(odfElement);
    }

    public static ReferenceField createReferenceField(OdfElement odfElement, String referenceName) {
        return new ReferenceField(odfElement, referenceName);
    }

    public static VariableField createSimpleVariableField(VariableContainer container, String name) {
        return new VariableField(container, name, VariableField.VariableType.SIMPLE);
    }

    public static VariableField createUserVariableField(VariableContainer container, String name, String value) {
        VariableField field = new VariableField(container, name, VariableField.VariableType.USER);
        field.updateField(value, null);
        return field;
    }

    public static ConditionField createConditionField(OdfElement odfElement, String condition, String trueText, String falseText) {
        return new ConditionField(odfElement, condition, trueText, falseText, false);
    }

    public static ConditionField createHiddenTextField(OdfElement odfElement, String condition, String text) {
        return new ConditionField(odfElement, condition, null, text, true);
    }

    private Fields() {
    }
}

