/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.bind;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSimpleAuth
extends GrammarAction<LdapMessageContainer<BindRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSimpleAuth.class);

    public StoreSimpleAuth() {
        super("Store BindRequest Simple Authentication");
    }

    public void action(LdapMessageContainer<BindRequest> container) {
        BindRequest bindRequestMessage = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        bindRequestMessage.setSimple(true);
        if (tlv.getLength() == 0) {
            bindRequestMessage.setCredentials(Strings.EMPTY_BYTES);
        } else {
            bindRequestMessage.setCredentials(tlv.getValue().getData());
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05119_SIMPLE_CREDENTIAL_DECODED, (Object[])new Object[0]));
        }
    }
}

