/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.daffodil.api.Daffodil;
import org.apache.daffodil.api.infoset.InfosetInputter;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.infoset.IllegalContentWhereEventExpected;
import org.apache.daffodil.runtime1.infoset.InvalidInfosetException;
import org.apache.daffodil.runtime1.infoset.JDOMInfosetInputter$;
import org.apache.daffodil.runtime1.infoset.NonTextFoundInSimpleContentException;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public class JDOMInfosetInputter
extends InfosetInputter {
    private final MStackOf<Tuple2<Element, Iterator<Content>>> stack;
    private boolean doStartEvent;

    /*
     * WARNING - void declaration
     */
    public JDOMInfosetInputter(Document doc) {
        void var2_2;
        MStackOf<Tuple2> s = new MStackOf<Tuple2>();
        Iterator docChildren = doc.getContent().iterator();
        if (!docChildren.hasNext()) {
            throw new InvalidInfosetException("Document does not contain a root element");
        }
        s.push(Tuple2$.MODULE$.apply(null, docChildren));
        this.stack = var2_2;
        this.doStartEvent = true;
    }

    @Override
    public Daffodil.InfosetInputterEventType getEventType() {
        if (this.stack.top()._1() == null) {
            if (this.doStartEvent) {
                return Daffodil.InfosetInputterEventType.StartDocument;
            }
            return Daffodil.InfosetInputterEventType.EndDocument;
        }
        if (this.doStartEvent) {
            return Daffodil.InfosetInputterEventType.StartElement;
        }
        return Daffodil.InfosetInputterEventType.EndElement;
    }

    @Override
    public String getLocalName() {
        return ((Element)this.stack.top()._1()).getName();
    }

    @Override
    public boolean getSupportsNamespaces() {
        return true;
    }

    @Override
    public String getNamespaceURI() {
        return ((Element)this.stack.top()._1()).getNamespace().getURI();
    }

    @Override
    public String getSimpleText(NodeInfo.Kind primType, Map<String, String> runtimeProperties) {
        String string;
        if (((Iterator)this.stack.top()._2()).hasNext()) {
            Content child = (Content)((Iterator)this.stack.top()._2()).next();
            if (((Iterator)this.stack.top()._2()).hasNext()) {
                throw new NonTextFoundInSimpleContentException(((Element)this.stack.top()._1()).getQualifiedName());
            }
            Content content = child;
            if (!(content instanceof Text)) {
                throw new NonTextFoundInSimpleContentException(((Element)this.stack.top()._1()).getQualifiedName());
            }
            Text t = (Text)content;
            String text = t.getText();
            string = primType instanceof NodeInfo.PrimType.StringKind ? XMLUtils$.MODULE$.remapPUAToXMLIllegalCharacters(text) : text;
        } else {
            string = "";
        }
        String text = string;
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean isNilled() {
        Boolean bl;
        String nilAttrValue;
        Element elem;
        block9: {
            block8: {
                elem = (Element)this.stack.top()._1();
                nilAttrValue = elem.getAttributeValue("nil", JDOMInfosetInputter$.MODULE$.JDOM_XSI_NAMESPACE());
                if (nilAttrValue == null) {
                    return null;
                }
                String string = nilAttrValue;
                String string2 = "true";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block8;
                String string3 = nilAttrValue;
                String string4 = "1";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
            }
            bl = Predef$.MODULE$.boolean2Boolean(true);
            return bl;
        }
        String string = nilAttrValue;
        String string5 = "false";
        if (string == null ? string5 != null : !string.equals(string5)) {
            String string6 = nilAttrValue;
            String string7 = "0";
            if (string6 == null) {
                if (string7 != null) {
                    throw new InvalidInfosetException("xsi:nil property is not a valid boolean: '" + nilAttrValue + "' for element " + elem.getQualifiedName());
                }
            } else if (!string6.equals(string7)) throw new InvalidInfosetException("xsi:nil property is not a valid boolean: '" + nilAttrValue + "' for element " + elem.getQualifiedName());
        }
        bl = Predef$.MODULE$.boolean2Boolean(false);
        return bl;
    }

    @Override
    public boolean hasNext() {
        boolean atDocumentEnd = this.stack.top()._1() == null && !this.doStartEvent;
        return !atDocumentEnd;
    }

    @Override
    public void fini() {
        this.stack.clear();
    }

    private boolean tryDescend() {
        boolean descended = false;
        while (((Iterator)this.stack.top()._2()).hasNext() && !descended) {
            Text t;
            Content content = (Content)((Iterator)this.stack.top()._2()).next();
            if (content instanceof Element) {
                Element e = (Element)content;
                this.stack.push((Tuple2<Element, Iterator<Content>>)Tuple2$.MODULE$.apply((Object)e, e.getContent().iterator()));
                descended = true;
                continue;
            }
            if (content instanceof Text && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString((t = (Text)content).getText()), (Function1 & Serializable)_$1 -> RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$1)))) || content instanceof ProcessingInstruction || content instanceof Comment) continue;
            if (content instanceof DocType) {
                DocType dt = (DocType)content;
                throw new IllegalContentWhereEventExpected("DOCTYPE declarations are not allowed.");
            }
            Content c = content;
            throw new IllegalContentWhereEventExpected("Found " + c.getCType().toString());
        }
        return descended;
    }

    @Override
    public void next() {
        if (this.tryDescend()) {
            this.doStartEvent = true;
            return;
        }
        if (this.doStartEvent) {
            this.doStartEvent = false;
            return;
        }
        this.stack.pop();
        if (this.tryDescend()) {
            this.doStartEvent = true;
            return;
        }
    }
}

