/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.utils.StringUtil;
import org.apache.activemq.artemis.utils.sm.SecurityManagerShim;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    public static final String CATCH_ALL_WILDCARD = "*";
    @Deprecated(forRemoval=true)
    public static final String WHITELIST_PROPERTY = "org.apache.activemq.artemis.jms.deserialization.whitelist";
    public static final String ALLOWLIST_PROPERTY = "org.apache.activemq.artemis.jms.deserialization.allowlist";
    @Deprecated(forRemoval=true)
    public static final String BLACKLIST_PROPERTY = "org.apache.activemq.artemis.jms.deserialization.blacklist";
    public static final String DENYLIST_PROPERTY = "org.apache.activemq.artemis.jms.deserialization.denylist";
    private List<String> allowList = new ArrayList<String>();
    private List<String> denyList = new ArrayList<String>();

    public ObjectInputStreamWithClassLoader(InputStream in) throws IOException {
        super(in);
        this.addToAllowList(System.getProperty(WHITELIST_PROPERTY, null));
        this.addToAllowList(System.getProperty(ALLOWLIST_PROPERTY, null));
        this.addToDenyList(System.getProperty(BLACKLIST_PROPERTY, null));
        this.addToDenyList(System.getProperty(DENYLIST_PROPERTY, null));
    }

    public String getAllowList() {
        return StringUtil.joinStringList(this.allowList, (String)",");
    }

    public String getDenyList() {
        return StringUtil.joinStringList(this.denyList, (String)",");
    }

    public void setAllowList(String allowList) {
        this.allowList = StringUtil.splitStringList((String)allowList, (String)",");
    }

    public void addToAllowList(String allowList) {
        this.allowList.addAll(StringUtil.splitStringList((String)allowList, (String)","));
    }

    public void setDenyList(String denyList) {
        this.denyList = StringUtil.splitStringList((String)denyList, (String)",");
    }

    public void addToDenyList(String denyList) {
        this.denyList.addAll(StringUtil.splitStringList((String)denyList, (String)","));
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (!SecurityManagerShim.isSecurityManagerEnabled()) {
            return this.resolveClass0(desc);
        }
        try {
            return (Class)SecurityManagerShim.doPrivileged(() -> this.resolveClass0(desc));
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        if (!SecurityManagerShim.isSecurityManagerEnabled()) {
            return this.resolveProxyClass0(interfaces);
        }
        try {
            return (Class)SecurityManagerShim.doPrivileged(() -> this.resolveProxyClass0(interfaces));
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    private Class resolveClass0(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = Class.forName(name, false, loader);
            if (clazz == null) {
                clazz = super.resolveClass(desc);
            }
            return this.checkSecurity(clazz);
        }
        catch (ClassNotFoundException e) {
            return this.checkSecurity(super.resolveClass(desc));
        }
    }

    private Class resolveProxyClass0(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader latestLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, latestLoader);
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i] = cl;
        }
        try {
            return this.checkSecurity(Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : latestLoader, classObjs));
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    private RuntimeException unwrapException(PrivilegedActionException e) throws IOException, ClassNotFoundException {
        Throwable c = e.getCause();
        if (c instanceof IOException) {
            IOException ioException = (IOException)c;
            throw ioException;
        }
        if (c instanceof ClassNotFoundException) {
            ClassNotFoundException classNotFoundException = (ClassNotFoundException)c;
            throw classNotFoundException;
        }
        if (c instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)c;
            throw runtimeException;
        }
        if (c instanceof Error) {
            Error error = (Error)c;
            throw error;
        }
        throw new RuntimeException(c);
    }

    private Class<?> checkSecurity(Class<?> clazz) throws ClassNotFoundException {
        Class<?> target = clazz;
        while (target.isArray()) {
            target = target.getComponentType();
        }
        while (target.isAnonymousClass() || target.isLocalClass()) {
            target = target.getEnclosingClass();
        }
        if (!target.isPrimitive() && !this.isTrustedType(target)) {
            throw new ClassNotFoundException("Forbidden " + String.valueOf(clazz) + "! This class is not trusted to be deserialized under the current configuration. Please refer to the documentation for more information on how to configure trusted classes.");
        }
        return clazz;
    }

    private boolean isTrustedType(Class<?> clazz) {
        if (clazz == null) {
            return true;
        }
        String className = clazz.getCanonicalName();
        if (className == null) {
            className = clazz.getName();
        }
        for (String entry : this.denyList) {
            if (CATCH_ALL_WILDCARD.equals(entry)) {
                return false;
            }
            if (!this.isClassOrPackageMatch(className, entry)) continue;
            return false;
        }
        for (String entry : this.allowList) {
            if (CATCH_ALL_WILDCARD.equals(entry)) {
                return true;
            }
            if (!this.isClassOrPackageMatch(className, entry)) continue;
            return true;
        }
        return this.allowList.isEmpty();
    }

    private boolean isClassOrPackageMatch(String className, String listEntry) {
        if (className == null) {
            return false;
        }
        if (className.equals(listEntry)) {
            return true;
        }
        int entryLength = listEntry.length();
        return className.length() > entryLength && className.startsWith(listEntry) && '.' == className.charAt(entryLength);
    }
}

