/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BiPredicateSupport {
    private BiPredicateSupport() {
    }

    @Nonnull
    public static <T, U> BiPredicate<T, U> fromBiFunction(final @Nonnull BiFunction<? super T, ? super U, Boolean> function, final @Nonnull BiPredicate<T, U> defValue) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(@Nullable T input1, @Nullable U input2) {
                Boolean result = (Boolean)function.apply(input1, input2);
                return result != null ? result.booleanValue() : defValue.test(input1, input2);
            }
        };
    }

    @Nonnull
    public static <T, U> BiPredicate<T, U> not(@Nonnull BiPredicate<? super T, ? super U> predicate) {
        return predicate.negate()::test;
    }

    @Nonnull
    public static <T, U> BiPredicate<T, U> and(@Nonnull Iterable<? extends BiPredicate<? super T, ? super U>> components) {
        ArrayList<BiPredicate<T, U>> copy = new ArrayList<BiPredicate<T, U>>();
        for (BiPredicate<T, U> biPredicate : components) {
            copy.add(biPredicate);
        }
        return (t, u) -> {
            for (BiPredicate p : copy) {
                if (p.test(t, u)) continue;
                return false;
            }
            return true;
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T, U> BiPredicate<T, U> and(BiPredicate<? super T, ? super U> ... components) {
        ArrayList copy = new ArrayList();
        for (BiPredicate<? super T, ? super U> p : components) {
            copy.add(p);
        }
        return (t, u) -> {
            for (BiPredicate p : copy) {
                if (p.test(t, u)) continue;
                return false;
            }
            return true;
        };
    }

    @Nonnull
    public static <T, U> BiPredicate<T, U> and(@Nonnull BiPredicate<T, U> first, @Nonnull BiPredicate<? super T, ? super U> second) {
        return first.and(second);
    }

    @Nonnull
    public static <T, U> BiPredicate<T, U> or(@Nonnull Iterable<? extends BiPredicate<? super T, ? super U>> components) {
        ArrayList<BiPredicate<T, U>> copy = new ArrayList<BiPredicate<T, U>>();
        for (BiPredicate<T, U> biPredicate : components) {
            copy.add(biPredicate);
        }
        return (t, u) -> {
            for (BiPredicate p : copy) {
                if (!p.test(t, u)) continue;
                return true;
            }
            return false;
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T, U> BiPredicate<T, U> or(BiPredicate<? super T, ? super U> ... components) {
        ArrayList copy = new ArrayList();
        for (BiPredicate<? super T, ? super U> p : components) {
            copy.add(p);
        }
        return (t, u) -> {
            for (BiPredicate p : copy) {
                if (!p.test(t, u)) continue;
                return true;
            }
            return false;
        };
    }

    @Nonnull
    public static <T, U> BiPredicate<T, U> or(@Nonnull BiPredicate<T, U> first, @Nonnull BiPredicate<? super T, ? super U> second) {
        return first.or(second);
    }
}

