/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import jakarta.jms.ConnectionFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractPortableFeature;
import org.apache.cxf.feature.DelegatingFeature;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.jms.JMSConduit;
import org.apache.cxf.transport.jms.JMSDestination;

@NoJSR250Annotations
public class ConnectionFactoryFeature
extends DelegatingFeature<Portable> {
    public ConnectionFactoryFeature(ConnectionFactory cf) {
        super((AbstractPortableFeature)new Portable(cf));
    }

    public static class Portable
    implements AbstractPortableFeature {
        private ConnectionFactory connectionFactory;

        public Portable(ConnectionFactory cf) {
            this.connectionFactory = cf;
        }

        public void initialize(Client client, Bus bus) {
            client.getEndpoint().getOutInterceptors().add(new JMSConduitConfigOutInterceptor());
        }

        public void initialize(InterceptorProvider provider, Bus bus) {
            provider.getOutInterceptors().add(new JMSConduitConfigOutInterceptor());
        }

        public void initialize(Server server, Bus bus) {
            Destination destination = server.getDestination();
            if (destination instanceof JMSDestination) {
                JMSDestination jmsDestination = (JMSDestination)destination;
                jmsDestination.getJmsConfig().setConnectionFactory(this.connectionFactory);
            }
        }

        private class JMSConduitConfigOutInterceptor
        extends AbstractPhaseInterceptor<Message> {
            JMSConduitConfigOutInterceptor() {
                super("prepare-send");
            }

            public void handleMessage(Message message) throws Fault {
                Conduit conduit = message.getExchange().getConduit(message);
                if (conduit instanceof JMSConduit) {
                    JMSConduit jmsConduit = (JMSConduit)conduit;
                    jmsConduit.getJmsConfig().setConnectionFactory(Portable.this.connectionFactory);
                }
            }
        }
    }
}

