/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import java.util.Arrays;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.routines.checkdigit.CheckDigitException;
import org.apache.commons.validator.routines.checkdigit.ModulusCheckDigit;

public final class ModulusTenCheckDigit
extends ModulusCheckDigit {
    private static final long serialVersionUID = -3752929983453368497L;
    private final int[] positionWeight;
    private final boolean useRightPos;
    private final boolean sumWeightedDigits;

    public ModulusTenCheckDigit(int[] positionWeight) {
        this(positionWeight, false, false);
    }

    public ModulusTenCheckDigit(int[] positionWeight, boolean useRightPos) {
        this(positionWeight, useRightPos, false);
    }

    public ModulusTenCheckDigit(int[] positionWeight, boolean useRightPos, boolean sumWeightedDigits) {
        this.positionWeight = Arrays.copyOf(positionWeight, positionWeight.length);
        this.useRightPos = useRightPos;
        this.sumWeightedDigits = sumWeightedDigits;
    }

    @Override
    public boolean isValid(String code) {
        if (GenericValidator.isBlankOrNull(code) || !Character.isDigit(code.charAt(code.length() - 1))) {
            return false;
        }
        return super.isValid(code);
    }

    @Override
    protected int toInt(char character, int leftPos, int rightPos) throws CheckDigitException {
        int num = Character.getNumericValue(character);
        if (num < 0) {
            throw new CheckDigitException("Invalid Character[" + leftPos + "] = '" + character + "'");
        }
        return num;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positionWeight=" + Arrays.toString(this.positionWeight) + ", useRightPos=" + this.useRightPos + ", sumWeightedDigits=" + this.sumWeightedDigits + "]";
    }

    @Override
    protected int weightedValue(int charValue, int leftPos, int rightPos) {
        int pos = this.useRightPos ? rightPos : leftPos;
        int weight = this.positionWeight[(pos - 1) % this.positionWeight.length];
        int weightedValue = charValue * weight;
        if (this.sumWeightedDigits) {
            weightedValue = ModulusTenCheckDigit.sumDigits(weightedValue);
        }
        return weightedValue;
    }
}

