/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import org.apache.commons.configuration2.builder.AutoSaveListener;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileHandlerListener;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestAutoSaveListener {
    private FileBasedConfigurationBuilder<?> builder;
    private AutoSaveListener listener;

    private void fireChangeEvent(boolean before) {
        this.listener.onEvent(new ConfigurationEvent((Object)this, ConfigurationEvent.ADD_PROPERTY, "someProperty", (Object)"someValue", before));
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.builder = (FileBasedConfigurationBuilder)Mockito.mock(FileBasedConfigurationBuilder.class);
        this.listener = new AutoSaveListener(this.builder);
    }

    @Test
    void testConfigurationChangedAfterLoading() throws ConfigurationException {
        FileHandler handler = new FileHandler();
        this.listener.loading(handler);
        this.fireChangeEvent(false);
        this.listener.loaded(handler);
        this.fireChangeEvent(false);
        ((FileBasedConfigurationBuilder)Mockito.verify(this.builder)).save();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    void testConfigurationChangedAutoSave() throws ConfigurationException {
        this.fireChangeEvent(false);
        ((FileBasedConfigurationBuilder)Mockito.verify(this.builder)).save();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    void testConfigurationChangedAutoSaveException() throws ConfigurationException {
        ((FileBasedConfigurationBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ConfigurationException()}).when(this.builder)).save();
        this.fireChangeEvent(false);
        ((FileBasedConfigurationBuilder)Mockito.verify(this.builder)).save();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    void testConfigurationChangedBeforeUpdateNoSave() {
        this.fireChangeEvent(true);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    void testConfigurationChangedWhileLoading() {
        this.listener.loading(new FileHandler());
        this.fireChangeEvent(false);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    void testUpdateFileHandler() {
        FileHandler handler = (FileHandler)Mockito.mock(FileHandler.class);
        FileHandler handler2 = (FileHandler)Mockito.mock(FileHandler.class);
        this.listener.updateFileHandler(handler);
        this.listener.updateFileHandler(handler2);
        ((FileHandler)Mockito.verify((Object)handler)).addFileHandlerListener((FileHandlerListener)this.listener);
        ((FileHandler)Mockito.verify((Object)handler)).removeFileHandlerListener((FileHandlerListener)this.listener);
        ((FileHandler)Mockito.verify((Object)handler2)).addFileHandlerListener((FileHandlerListener)this.listener);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder, handler, handler2});
    }

    @Test
    void testUpdateFileHandlerNull() {
        FileHandler handler = (FileHandler)Mockito.mock(FileHandler.class);
        this.listener.updateFileHandler(handler);
        this.listener.updateFileHandler(null);
        ((FileHandler)Mockito.verify((Object)handler)).addFileHandlerListener((FileHandlerListener)this.listener);
        ((FileHandler)Mockito.verify((Object)handler)).removeFileHandlerListener((FileHandlerListener)this.listener);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder, handler});
    }
}

