/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.AbstractStringEncoderTest;
import org.apache.commons.codec.language.Metaphone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MetaphoneTest
extends AbstractStringEncoderTest<Metaphone> {
    MetaphoneTest() {
    }

    public void assertIsMetaphoneEqual(String source, String[] matches) {
        for (String matche : matches) {
            Assertions.assertTrue((boolean)((Metaphone)this.getStringEncoder()).isMetaphoneEqual(source, matche), (String)("Source: " + source + ", should have same Metaphone as: " + matche));
        }
        for (String matche : matches) {
            for (String matche2 : matches) {
                Assertions.assertTrue((boolean)((Metaphone)this.getStringEncoder()).isMetaphoneEqual(matche, matche2));
            }
        }
    }

    public void assertMetaphoneEqual(String[][] pairs) {
        this.validateFixture(pairs);
        for (String[] pair : pairs) {
            String name0 = pair[0];
            String name1 = pair[1];
            String failMsg = "Expected match between " + name0 + " and " + name1;
            Assertions.assertTrue((boolean)((Metaphone)this.getStringEncoder()).isMetaphoneEqual(name0, name1), (String)failMsg);
            Assertions.assertTrue((boolean)((Metaphone)this.getStringEncoder()).isMetaphoneEqual(name1, name0), (String)failMsg);
        }
    }

    @Override
    protected Metaphone createStringEncoder() {
        return new Metaphone();
    }

    @Test
    void testDiscardOfSCEOrSCIOrSCY() {
        Assertions.assertEquals((Object)"SNS", (Object)((Metaphone)this.getStringEncoder()).metaphone("SCIENCE"));
        Assertions.assertEquals((Object)"SN", (Object)((Metaphone)this.getStringEncoder()).metaphone("SCENE"));
        Assertions.assertEquals((Object)"S", (Object)((Metaphone)this.getStringEncoder()).metaphone("SCY"));
    }

    @Test
    void testDiscardOfSilentGN() {
        Assertions.assertEquals((Object)"N", (Object)((Metaphone)this.getStringEncoder()).metaphone("GNU"));
        Assertions.assertEquals((Object)"SNT", (Object)((Metaphone)this.getStringEncoder()).metaphone("SIGNED"));
    }

    @Test
    void testDiscardOfSilentHAfterG() {
        Assertions.assertEquals((Object)"KNT", (Object)((Metaphone)this.getStringEncoder()).metaphone("GHENT"));
        Assertions.assertEquals((Object)"B", (Object)((Metaphone)this.getStringEncoder()).metaphone("BAUGH"));
    }

    @Test
    void testExceedLength() {
        Assertions.assertEquals((Object)"AKSK", (Object)((Metaphone)this.getStringEncoder()).metaphone("AXEAXE"));
    }

    @Test
    void testIsMetaphoneEqual1() {
        this.assertMetaphoneEqual(new String[][]{{"Case", "case"}, {"CASE", "Case"}, {"caSe", "cAsE"}, {"quick", "cookie"}});
    }

    @Test
    void testIsMetaphoneEqual2() {
        this.assertMetaphoneEqual(new String[][]{{"Lawrence", "Lorenza"}, {"Gary", "Cahra"}});
    }

    @Test
    void testIsMetaphoneEqualAero() {
        this.assertIsMetaphoneEqual("Aero", new String[]{"Eure"});
    }

    @Test
    void testIsMetaphoneEqualAlbert() {
        this.assertIsMetaphoneEqual("Albert", new String[]{"Ailbert", "Alberik", "Albert", "Alberto", "Albrecht"});
    }

    @Test
    void testIsMetaphoneEqualGary() {
        this.assertIsMetaphoneEqual("Gary", new String[]{"Cahra", "Cara", "Carey", "Cari", "Caria", "Carie", "Caro", "Carree", "Carri", "Carrie", "Carry", "Cary", "Cora", "Corey", "Cori", "Corie", "Correy", "Corri", "Corrie", "Corry", "Cory", "Gray", "Kara", "Kare", "Karee", "Kari", "Karia", "Karie", "Karrah", "Karrie", "Karry", "Kary", "Keri", "Kerri", "Kerrie", "Kerry", "Kira", "Kiri", "Kora", "Kore", "Kori", "Korie", "Korrie", "Korry"});
    }

    @Test
    void testIsMetaphoneEqualJohn() {
        this.assertIsMetaphoneEqual("John", new String[]{"Gena", "Gene", "Genia", "Genna", "Genni", "Gennie", "Genny", "Giana", "Gianna", "Gina", "Ginni", "Ginnie", "Ginny", "Jaine", "Jan", "Jana", "Jane", "Janey", "Jania", "Janie", "Janna", "Jany", "Jayne", "Jean", "Jeana", "Jeane", "Jeanie", "Jeanna", "Jeanne", "Jeannie", "Jen", "Jena", "Jeni", "Jenn", "Jenna", "Jennee", "Jenni", "Jennie", "Jenny", "Jinny", "Jo Ann", "Jo-Ann", "Jo-Anne", "Joan", "Joana", "Joane", "Joanie", "Joann", "Joanna", "Joanne", "Joeann", "Johna", "Johnna", "Joni", "Jonie", "Juana", "June", "Junia", "Junie"});
    }

    @Test
    void testIsMetaphoneEqualKnight() {
        this.assertIsMetaphoneEqual("Knight", new String[]{"Hynda", "Nada", "Nadia", "Nady", "Nat", "Nata", "Natty", "Neda", "Nedda", "Nedi", "Netta", "Netti", "Nettie", "Netty", "Nita", "Nydia"});
    }

    @Test
    void testIsMetaphoneEqualMary() {
        this.assertIsMetaphoneEqual("Mary", new String[]{"Mair", "Maire", "Mara", "Mareah", "Mari", "Maria", "Marie", "Mary", "Maura", "Maure", "Meara", "Merrie", "Merry", "Mira", "Moira", "Mora", "Moria", "Moyra", "Muire", "Myra", "Myrah"});
    }

    @Test
    void testIsMetaphoneEqualParis() {
        this.assertIsMetaphoneEqual("Paris", new String[]{"Pearcy", "Perris", "Piercy", "Pierz", "Pryse"});
    }

    @Test
    void testIsMetaphoneEqualPeter() {
        this.assertIsMetaphoneEqual("Peter", new String[]{"Peadar", "Peder", "Pedro", "Peter", "Petr", "Peyter", "Pieter", "Pietro", "Piotr"});
    }

    @Test
    void testIsMetaphoneEqualRay() {
        this.assertIsMetaphoneEqual("Ray", new String[]{"Ray", "Rey", "Roi", "Roy", "Ruy"});
    }

    @Test
    void testIsMetaphoneEqualSusan() {
        this.assertIsMetaphoneEqual("Susan", new String[]{"Siusan", "Sosanna", "Susan", "Susana", "Susann", "Susanna", "Susannah", "Susanne", "Suzann", "Suzanna", "Suzanne", "Zuzana"});
    }

    @Test
    void testIsMetaphoneEqualWhite() {
        this.assertIsMetaphoneEqual("White", new String[]{"Wade", "Wait", "Waite", "Wat", "Whit", "Wiatt", "Wit", "Wittie", "Witty", "Wood", "Woodie", "Woody"});
    }

    @Test
    void testIsMetaphoneEqualWright() {
        this.assertIsMetaphoneEqual("Wright", new String[]{"Rota", "Rudd", "Ryde"});
    }

    @Test
    void testIsMetaphoneEqualXalan() {
        this.assertIsMetaphoneEqual("Xalan", new String[]{"Celene", "Celina", "Celine", "Selena", "Selene", "Selina", "Seline", "Suellen", "Xylina"});
    }

    @Test
    void testMetaphone() {
        Assertions.assertEquals((Object)"HL", (Object)((Metaphone)this.getStringEncoder()).metaphone("howl"));
        Assertions.assertEquals((Object)"TSTN", (Object)((Metaphone)this.getStringEncoder()).metaphone("testing"));
        Assertions.assertEquals((Object)"0", (Object)((Metaphone)this.getStringEncoder()).metaphone("The"));
        Assertions.assertEquals((Object)"KK", (Object)((Metaphone)this.getStringEncoder()).metaphone("quick"));
        Assertions.assertEquals((Object)"BRN", (Object)((Metaphone)this.getStringEncoder()).metaphone("brown"));
        Assertions.assertEquals((Object)"FKS", (Object)((Metaphone)this.getStringEncoder()).metaphone("fox"));
        Assertions.assertEquals((Object)"JMPT", (Object)((Metaphone)this.getStringEncoder()).metaphone("jumped"));
        Assertions.assertEquals((Object)"OFR", (Object)((Metaphone)this.getStringEncoder()).metaphone("over"));
        Assertions.assertEquals((Object)"0", (Object)((Metaphone)this.getStringEncoder()).metaphone("the"));
        Assertions.assertEquals((Object)"LS", (Object)((Metaphone)this.getStringEncoder()).metaphone("lazy"));
        Assertions.assertEquals((Object)"TKS", (Object)((Metaphone)this.getStringEncoder()).metaphone("dogs"));
    }

    @Test
    void testPHTOF() {
        Assertions.assertEquals((Object)"FX", (Object)((Metaphone)this.getStringEncoder()).metaphone("PHISH"));
    }

    @Test
    void testSetMaxLengthWithTruncation() {
        ((Metaphone)this.getStringEncoder()).setMaxCodeLen(6);
        Assertions.assertEquals((Object)"AKSKSK", (Object)((Metaphone)this.getStringEncoder()).metaphone("AXEAXEAXE"));
    }

    @Test
    void testSHAndSIOAndSIAToX() {
        Assertions.assertEquals((Object)"XT", (Object)((Metaphone)this.getStringEncoder()).metaphone("SHOT"));
        Assertions.assertEquals((Object)"OTXN", (Object)((Metaphone)this.getStringEncoder()).metaphone("ODSIAN"));
        Assertions.assertEquals((Object)"PLXN", (Object)((Metaphone)this.getStringEncoder()).metaphone("PULSION"));
    }

    @Test
    void testTCH() {
        Assertions.assertEquals((Object)"RX", (Object)((Metaphone)this.getStringEncoder()).metaphone("RETCH"));
        Assertions.assertEquals((Object)"WX", (Object)((Metaphone)this.getStringEncoder()).metaphone("WATCH"));
    }

    @Test
    void testTIOAndTIAToX() {
        Assertions.assertEquals((Object)"OX", (Object)((Metaphone)this.getStringEncoder()).metaphone("OTIA"));
        Assertions.assertEquals((Object)"PRXN", (Object)((Metaphone)this.getStringEncoder()).metaphone("PORTION"));
    }

    @Test
    void testTranslateOfSCHAndCH() {
        Assertions.assertEquals((Object)"SKTL", (Object)((Metaphone)this.getStringEncoder()).metaphone("SCHEDULE"));
        Assertions.assertEquals((Object)"SKMT", (Object)((Metaphone)this.getStringEncoder()).metaphone("SCHEMATIC"));
        Assertions.assertEquals((Object)"KRKT", (Object)((Metaphone)this.getStringEncoder()).metaphone("CHARACTER"));
        Assertions.assertEquals((Object)"TX", (Object)((Metaphone)this.getStringEncoder()).metaphone("TEACH"));
    }

    @Test
    void testTranslateToJOfDGEOrDGIOrDGY() {
        Assertions.assertEquals((Object)"TJ", (Object)((Metaphone)this.getStringEncoder()).metaphone("DODGY"));
        Assertions.assertEquals((Object)"TJ", (Object)((Metaphone)this.getStringEncoder()).metaphone("DODGE"));
        Assertions.assertEquals((Object)"AJMT", (Object)((Metaphone)this.getStringEncoder()).metaphone("ADGIEMTI"));
    }

    @Test
    void testWhy() {
        Assertions.assertEquals((Object)"", (Object)((Metaphone)this.getStringEncoder()).metaphone("WHY"));
    }

    @Test
    void testWordEndingInMB() {
        Assertions.assertEquals((Object)"KM", (Object)((Metaphone)this.getStringEncoder()).metaphone("COMB"));
        Assertions.assertEquals((Object)"TM", (Object)((Metaphone)this.getStringEncoder()).metaphone("TOMB"));
        Assertions.assertEquals((Object)"WM", (Object)((Metaphone)this.getStringEncoder()).metaphone("WOMB"));
    }

    @Test
    void testWordsWithCIA() {
        Assertions.assertEquals((Object)"XP", (Object)((Metaphone)this.getStringEncoder()).metaphone("CIAPO"));
    }

    public void validateFixture(String[][] pairs) {
        if (pairs.length == 0) {
            Assertions.fail((String)"Test fixture is empty");
        }
        for (int i = 0; i < pairs.length; ++i) {
            if (pairs[i].length == 2) continue;
            Assertions.fail((String)("Error in test fixture in the data array at index " + i));
        }
    }
}

