/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.SortButtonRenderer;

public class TableHeaderListener
extends MouseAdapter {
    private static final int EPSILON = 5;
    private static final Cursor EAST = Cursor.getPredefinedCursor(11);
    private static final Cursor WEST = Cursor.getPredefinedCursor(10);
    private JTableHeader header;
    private SortButtonRenderer renderer;
    private JTable table;
    private TableColumnPreferences tableColumnPreferences;

    public TableHeaderListener(JTableHeader header, SortButtonRenderer renderer) {
        this.header = header;
        this.renderer = renderer;
        this.table = header.getTable();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && this.isResizeCursor()) {
            this.resize(this.getLeftColumn(e.getPoint()));
        } else if (!this.isResizeCursor()) {
            int col = this.header.columnAtPoint(e.getPoint());
            int sortCol = this.table.convertColumnIndexToModel(col);
            if (this.renderer.isSortingEnabled() && ((CayenneTableModel)this.table.getModel()).isColumnSortable(sortCol)) {
                boolean isAscent = 1 != this.renderer.getState(col);
                this.sortByDefinedColumn(col, sortCol, isAscent);
                this.tableColumnPreferences.setSortOrder(isAscent);
                this.tableColumnPreferences.setSortColumn(sortCol);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.header.repaint();
    }

    public void sortByDefinedColumn(int col, int sortCol, boolean order) {
        CayenneTableModel model = (CayenneTableModel)this.table.getModel();
        if (this.renderer.isSortingEnabled() && model.isColumnSortable(sortCol)) {
            this.renderer.setSelectedColumn(col, order);
            this.header.repaint();
            if (this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
            }
            model.sortByColumn(sortCol, order);
        }
    }

    public void setPreferences(TableColumnPreferences tableColumnPreferences) {
        if (this.tableColumnPreferences == null) {
            this.tableColumnPreferences = tableColumnPreferences;
        }
    }

    private boolean isResizeCursor() {
        Cursor cursor = this.table.getTableHeader().getCursor();
        return cursor.equals(EAST) || cursor.equals(WEST);
    }

    private int getLeftColumn(Point pt) {
        pt.x -= 5;
        return this.table.getTableHeader().columnAtPoint(pt);
    }

    private void resize(int col) {
        TableColumnModel tcm = this.table.getColumnModel();
        TableColumn tc = tcm.getColumn(col);
        TableCellRenderer tcr = tc.getHeaderRenderer();
        if (tcr == null) {
            tcr = this.table.getTableHeader().getDefaultRenderer();
        }
        Object obj = tc.getHeaderValue();
        Component comp = tcr.getTableCellRendererComponent(this.table, obj, false, false, 0, 0);
        int maxWidth = comp.getPreferredSize().width;
        int ub = this.table.getRowCount();
        for (int i = 0; i != ub; ++i) {
            tcr = this.table.getCellRenderer(i, col);
            obj = this.table.getValueAt(i, col);
            comp = tcr.getTableCellRendererComponent(this.table, obj, false, false, i, col);
            int w = comp.getPreferredSize().width;
            if (w <= maxWidth) continue;
            maxWidth = w;
        }
        tc.setPreferredWidth(maxWidth += 10);
        tc.setWidth(maxWidth);
    }
}

