/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.PerCatalogAndSchemaLoader;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.SchemaFilter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AttributeLoader
extends PerCatalogAndSchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLoader.class);
    private boolean firstRow = true;
    private boolean supportAutoIncrement = false;

    AttributeLoader(DbAdapter adapter, DbLoaderConfiguration config, DbLoaderDelegate delegate) {
        super(adapter, config, delegate);
    }

    @Override
    protected ResultSet getResultSet(String catalogName, String schemaName, DatabaseMetaData metaData) throws SQLException {
        return metaData.getColumns(catalogName, schemaName, "%", "%");
    }

    @Override
    protected void processResultSetRow(CatalogFilter catalog, SchemaFilter schema, DbLoadDataStore map, ResultSet rs) throws SQLException {
        String tableName;
        DbEntity entity;
        if (this.firstRow) {
            this.supportAutoIncrement = this.checkForAutoIncrement(rs);
            this.firstRow = false;
        }
        if ((entity = map.getDbEntity(tableName = rs.getString("TABLE_NAME"))) == null) {
            return;
        }
        String columnName = rs.getString("COLUMN_NAME");
        PatternFilter columnFilter = schema.tables.getIncludeTableColumnFilter(tableName);
        if (columnFilter == null || !columnFilter.isIncluded(columnName)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skip column '" + tableName + "." + columnName + "' (Path: " + catalog.name + "/" + schema.name + "; Filter: " + columnFilter + ")");
            }
            return;
        }
        DbAttribute attribute = this.createDbAttribute(rs);
        this.addToDbEntity(entity, attribute);
    }

    private boolean checkForAutoIncrement(ResultSet rs) throws SQLException {
        ResultSetMetaData rsMetaData = rs.getMetaData();
        for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
            if (!"IS_AUTOINCREMENT".equals(rsMetaData.getColumnLabel(i))) continue;
            return true;
        }
        return false;
    }

    private void addToDbEntity(DbEntity entity, DbAttribute attribute) {
        attribute.setEntity((Entity)entity);
        if (entity.getAttribute(attribute.getName()) != null) {
            entity.removeAttribute(attribute.getName());
        }
        entity.addAttribute(attribute);
    }

    private DbAttribute createDbAttribute(ResultSet rs) throws SQLException {
        int columnType = rs.getInt("DATA_TYPE");
        int decimalDigits = -1;
        if (TypesMapping.isDecimal((int)columnType)) {
            decimalDigits = rs.getInt("DECIMAL_DIGITS");
            if (rs.wasNull()) {
                decimalDigits = -1;
            }
        }
        DbAttribute attr = this.adapter.buildAttribute(rs.getString("COLUMN_NAME"), rs.getString("TYPE_NAME"), columnType, rs.getInt("COLUMN_SIZE"), decimalDigits, rs.getBoolean("NULLABLE"));
        if (this.supportAutoIncrement && "YES".equals(rs.getString("IS_AUTOINCREMENT"))) {
            attr.setGenerated(true);
        }
        return attr;
    }
}

