/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import org.apache.cayenne.datasource.UnmanagedPoolingDataSource;

class PoolingDataSourceManager
extends Thread {
    private volatile boolean shouldStop;
    private UnmanagedPoolingDataSource dataSource;
    private long managerWakeTime;

    PoolingDataSourceManager(UnmanagedPoolingDataSource dataSource, long managerWakeTime) {
        this.setName("PoolingDataSourceManager-" + dataSource.hashCode());
        this.setDaemon(true);
        this.dataSource = dataSource;
        this.shouldStop = false;
        this.managerWakeTime = managerWakeTime;
    }

    void shutdown() {
        this.shouldStop = true;
        this.dataSource.close();
        this.interrupt();
    }

    UnmanagedPoolingDataSource getDataSource() {
        return this.dataSource;
    }

    boolean isStopped() {
        return this.shouldStop;
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.managerWakeTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.shouldStop) break;
            this.dataSource.managePool();
        }
    }
}

