/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.xml.DataChannelHandler;
import org.apache.cayenne.configuration.xml.DataMapHandler;
import org.apache.cayenne.configuration.xml.DataNodeChildrenHandler;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.configuration.xml.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

final class DataChannelChildrenHandler
extends NamespaceAwareNestedTagHandler {
    private static final Logger logger = LoggerFactory.getLogger(XMLDataChannelDescriptorLoader.class);
    static final String OLD_MAP_TAG = "map";
    static final String NODE_TAG = "node";
    static final String PROPERTY_TAG = "property";
    static final String DATA_MAP_TAG = "data-map";
    static final String DOMAIN_TAG = "domain";
    private XMLDataChannelDescriptorLoader xmlDataChannelDescriptorLoader;
    private DataChannelDescriptor descriptor;
    private DataNodeDescriptor nodeDescriptor;

    DataChannelChildrenHandler(XMLDataChannelDescriptorLoader xmlDataChannelDescriptorLoader, DataChannelHandler parentHandler) {
        super(parentHandler);
        this.xmlDataChannelDescriptorLoader = xmlDataChannelDescriptorLoader;
        this.descriptor = parentHandler.descriptor;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) {
        switch (localName) {
            case "property": {
                this.addProperty(attributes);
                return true;
            }
            case "map": {
                this.addMap(attributes);
                return true;
            }
            case "node": {
                this.addNode(attributes);
                return true;
            }
            case "domain": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
        if (NODE_TAG.equals(localName)) {
            this.nodeDescriptor = new DataNodeDescriptor();
            return new DataNodeChildrenHandler(this.xmlDataChannelDescriptorLoader, this, this.nodeDescriptor);
        }
        if (DATA_MAP_TAG.equals(localName)) {
            return new DataMapHandler(this.loaderContext);
        }
        return super.createChildTagHandler(namespaceURI, localName, name, attributes);
    }

    private void addProperty(Attributes attributes) {
        String key = attributes.getValue("name");
        String value = attributes.getValue("value");
        if (key != null && value != null) {
            this.descriptor.getProperties().put(key, value);
        }
    }

    private void addMap(Attributes attributes) {
        String dataMapName = attributes.getValue("name");
        Resource baseResource = this.descriptor.getConfigurationSource();
        String dataMapLocation = this.xmlDataChannelDescriptorLoader.nameMapper.configurationLocation(DataMap.class, dataMapName);
        Resource dataMapResource = baseResource.getRelativeResource(dataMapLocation);
        logger.info("Loading XML DataMap resource from " + dataMapResource.getURL());
        DataMap dataMap = this.xmlDataChannelDescriptorLoader.dataMapLoader.load(dataMapResource);
        dataMap.setName(dataMapName);
        dataMap.setLocation(dataMapLocation);
        dataMap.setDataChannelDescriptor(this.descriptor);
        this.descriptor.getDataMaps().add(dataMap);
    }

    private void addNode(Attributes attributes) {
        String nodeName = attributes.getValue("name");
        if (nodeName == null) {
            throw new ConfigurationException("Error: <node> without 'name'.", new Object[0]);
        }
        this.nodeDescriptor.setConfigurationSource(this.descriptor.getConfigurationSource());
        this.nodeDescriptor.setName(nodeName);
        this.nodeDescriptor.setAdapterType(attributes.getValue("adapter"));
        this.nodeDescriptor.setParameters(attributes.getValue("parameters"));
        this.nodeDescriptor.setDataSourceFactoryType(attributes.getValue("factory"));
        this.nodeDescriptor.setSchemaUpdateStrategyType(attributes.getValue("schema-update-strategy"));
        this.nodeDescriptor.setDataChannelDescriptor(this.descriptor);
        this.descriptor.getNodeDescriptors().add(this.nodeDescriptor);
    }
}

