/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.ParameterizedQuery;
import org.apache.cayenne.query.Query;

public abstract class AbstractMappedQuery
extends IndirectQuery {
    protected String queryName;
    protected Map<String, Object> params;

    protected AbstractMappedQuery(String queryName) {
        this.queryName = queryName;
    }

    public AbstractMappedQuery name(String queryName) {
        this.queryName = queryName;
        return this;
    }

    protected AbstractMappedQuery params(Map<String, ?> parameters) {
        if (this.params == null) {
            this.params = new HashMap(parameters);
        } else {
            this.params.putAll(parameters);
        }
        this.replacementQuery = null;
        return this;
    }

    public AbstractMappedQuery param(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, value);
        this.replacementQuery = null;
        return this;
    }

    Map<String, ?> normalizedParameters() {
        if (this.params == null || this.params.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> substitutes = new HashMap<String, Object>(this.params);
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Persistent) {
                value = ((Persistent)value).getObjectId();
            }
            substitutes.put(entry.getKey(), value);
        }
        return substitutes;
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        Query query = resolver.getQueryDescriptor(this.queryName).buildQuery();
        if (query instanceof ParameterizedQuery) {
            query = ((ParameterizedQuery)query).createQuery(this.normalizedParameters());
        } else if (query instanceof EJBQLQuery) {
            for (Map.Entry<String, ?> entry : this.normalizedParameters().entrySet()) {
                ((EJBQLQuery)query).setParameter(entry.getKey(), entry.getValue());
            }
        }
        return query;
    }
}

