/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.load;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import java.util.Collection;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.db.DbActionOptionsDialog;
import org.apache.cayenne.modeler.util.NameGeneratorPreferences;

public class DbLoaderOptionsDialog
extends DbActionOptionsDialog {
    private JTextField tableIncludePatternField;
    private JTextField tableExcludePatternField;
    private JTextField meaningfulPk;
    private JTextField procNamePatternField;
    private JComboBox<String> strategyCombo;
    protected String strategy;
    private JCheckBox usePrimitives;
    private JCheckBox useJava7Types;

    public DbLoaderOptionsDialog(Collection<String> catalogs, Collection<String> schemas, String dbCatalog, String currentSchema) {
        super(Application.getFrame(), "Reengineer DB Schema: Select Options", catalogs, schemas, dbCatalog, currentSchema);
    }

    @Override
    protected void initForm(DefaultFormBuilder builder) {
        super.initForm(builder);
        this.tableIncludePatternField = new JTextField();
        this.tableIncludePatternField.setToolTipText("<html>Regular expression to filter table names.<br>Default expression <b>.*</b> includes all tables.</html>");
        this.tableExcludePatternField = new JTextField();
        this.tableExcludePatternField.setToolTipText("<html>Regular expression to filter table names.<br>Empty by default excludes nothing.</html>");
        this.procNamePatternField = new JTextField();
        this.procNamePatternField.setToolTipText("<html>Regular expression to filter stored procedures names.<br>Default expression <b>.*</b> includes all stored procedures.</html>");
        this.meaningfulPk = new JTextField();
        this.meaningfulPk.setToolTipText("<html>Regular expression to filter tables with meaningful primary keys.<br>Multiple expressions divided by comma can be used.<br>Example: <b>^table1|^table2|^prefix.*|table_name</b></html>");
        this.strategyCombo = new JComboBox();
        this.strategyCombo.setEditable(true);
        this.usePrimitives = new JCheckBox();
        this.usePrimitives.setSelected(true);
        this.usePrimitives.setToolTipText("<html>Use primitive types (e.g. int) or Object types (e.g. java.lang.Integer)</html>");
        this.useJava7Types = new JCheckBox();
        this.useJava7Types.setSelected(false);
        this.useJava7Types.setToolTipText("<html>Use <b>java.util.Date</b> for all columns with <i>DATE/TIME/TIMESTAMP</i> types.<br>By default <b>java.time.*</b> types will be used.</html>");
        builder.append("Table Name Include Pattern:", (Component)this.tableIncludePatternField);
        builder.append("Table Name Exclude Pattern:", (Component)this.tableExcludePatternField);
        builder.append("Procedure Name Pattern:", (Component)this.procNamePatternField);
        builder.append("Naming Strategy:", this.strategyCombo);
        builder.append("Tables with Meaningful PK Pattern:", (Component)this.meaningfulPk);
        builder.append("Use Java primitive types:", (Component)this.usePrimitives);
        builder.append("Use old java.util.Date type:", (Component)this.useJava7Types);
    }

    @Override
    protected void initFromModel(Collection<String> catalogs, Collection<String> schemas, String currentCatalog, String currentSchema) {
        super.initFromModel(catalogs, schemas, currentCatalog, currentSchema);
        this.tableIncludePatternField.setText(".*");
        this.procNamePatternField.setText(".*");
        Vector<String> arr = NameGeneratorPreferences.getInstance().getLastUsedStrategies();
        this.strategyCombo.setModel(new DefaultComboBoxModel<String>(arr));
    }

    String getTableIncludePattern() {
        return "".equals(this.tableIncludePatternField.getText()) ? null : this.tableIncludePatternField.getText();
    }

    String getTableExcludePattern() {
        return "".equals(this.tableExcludePatternField.getText()) ? null : this.tableExcludePatternField.getText();
    }

    String getMeaningfulPk() {
        return "".equals(this.meaningfulPk.getText()) ? null : this.meaningfulPk.getText();
    }

    String getProcedureNamePattern() {
        return "".equals(this.procNamePatternField.getText()) ? null : this.procNamePatternField.getText();
    }

    boolean isUsePrimitives() {
        return this.usePrimitives.isSelected();
    }

    boolean isUseJava7Typed() {
        return this.useJava7Types.isSelected();
    }

    String getNamingStrategy() {
        return (String)this.strategyCombo.getSelectedItem();
    }
}

