/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;

abstract class SchemaContainer
extends FilterContainer {
    private final Collection<Schema> schemaCollection = new LinkedList<Schema>();

    SchemaContainer() {
    }

    public Collection<Schema> getSchemas() {
        return this.schemaCollection;
    }

    public void addSchema(Schema schema) {
        this.schemaCollection.add(schema);
    }

    @Override
    public boolean isEmptyContainer() {
        if (!super.isEmptyContainer()) {
            return false;
        }
        if (this.schemaCollection.isEmpty()) {
            return true;
        }
        for (Schema schema : this.schemaCollection) {
            if (schema.isEmptyContainer()) continue;
            return false;
        }
        return true;
    }

    @Override
    public StringBuilder toString(StringBuilder res, String prefix) {
        if (!SchemaContainer.isBlank(this.schemaCollection)) {
            for (Schema schema : this.schemaCollection) {
                schema.toString(res, prefix);
            }
        }
        return super.toString(res, prefix + "  ");
    }
}

