/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.io.InputStream;
import java.net.URL;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class XMLDataMapLoader
implements DataMapLoader {
    private static Logger logger = LoggerFactory.getLogger(XMLDataMapLoader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataMap load(Resource configurationResource) throws CayenneRuntimeException {
        MapLoader mapLoader = new MapLoader();
        URL url = configurationResource.getURL();
        try (InputStream in = url.openStream();){
            DataMap dataMap = mapLoader.loadDataMap(new InputSource(in));
            return dataMap;
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error loading configuration from %s", (Throwable)e, url);
        }
    }
}

