/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.guava;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import javax.annotation.Nullable;

public class TypeTokens {
    public static final Map<Class<?>, TypeToken<?>> COMMON_TYPE_TOKENS = ImmutableMap.builder().put(String.class, (Object)TypeToken.of(String.class)).put(Object.class, (Object)TypeToken.of(Object.class)).put(Integer.class, (Object)TypeToken.of(Integer.class)).put(Boolean.class, (Object)TypeToken.of(Boolean.class)).put(Double.class, (Object)TypeToken.of(Double.class)).put(Long.class, (Object)TypeToken.of(Long.class)).build();

    @Nullable
    public static <T> Class<? super T> getRawTypeIfRaw(@Nullable TypeToken<T> type) {
        if (type == null || !type.equals((Object)TypeToken.of((Class)type.getRawType()))) {
            return null;
        }
        return type.getRawType();
    }

    @Nullable
    public static <T> TypeToken<T> getTypeTokenIfNotRaw(@Nullable TypeToken<T> type) {
        if (type == null || type.equals((Object)TypeToken.of((Class)type.getRawType()))) {
            return null;
        }
        return type;
    }

    public static <T, U extends T> Class<T> getRawType(TypeToken<U> token, Class<T> raw) {
        if (raw != null) {
            return raw;
        }
        if (token != null) {
            return token.getRawType();
        }
        throw new IllegalStateException("Both indicators of type are null");
    }

    public static <T> TypeToken<T> getTypeToken(TypeToken<T> token, Class<? super T> raw) {
        if (token != null) {
            return token;
        }
        if (raw != null) {
            TypeToken result = COMMON_TYPE_TOKENS.get(raw);
            if (result == null) {
                result = TypeToken.of(raw);
            }
            return result;
        }
        throw new IllegalStateException("Both indicators of type are null");
    }

    public static <T> Class<T> getRawRawType(TypeToken<T> token) {
        return token.getRawType();
    }

    public static <T> void checkCompatibleOneNonNull(Class<? super T> type, TypeToken<T> typeToken) {
        if (type == null && typeToken != null || type != null && typeToken == null) {
            return;
        }
        if (type == null && typeToken == null) {
            throw new NullPointerException("Type not set (neither class or type token)");
        }
        if (!type.equals(typeToken.getRawType())) {
            throw new IllegalStateException("Invalid types, token is " + typeToken + " (raw " + typeToken.getRawType() + ") but class is " + type);
        }
    }
}

