/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind;

import java.util.Stack;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.rebind.RebindExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.rebind.RebindContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebindContextLookupContext
implements BrooklynMementoPersister.LookupContext {
    private static final Logger LOG = LoggerFactory.getLogger(RebindContextLookupContext.class);
    protected final Stack<String> description = new Stack();
    @Nullable
    protected final ManagementContext managementContext;
    protected final RebindContextImpl rebindContext;
    protected final RebindExceptionHandler exceptionHandler;

    @Deprecated
    public RebindContextLookupContext(ManagementContext managementContext, RebindContextImpl rebindContext, RebindExceptionHandler exceptionHandler) {
        this("<no-context-description>", managementContext, rebindContext, exceptionHandler);
    }

    public RebindContextLookupContext(String description, ManagementContext managementContext, RebindContextImpl rebindContext, RebindExceptionHandler exceptionHandler) {
        this.description.push(description);
        this.managementContext = managementContext;
        this.rebindContext = rebindContext;
        this.exceptionHandler = exceptionHandler;
    }

    public RebindContextLookupContext(String description, RebindContextLookupContext sourceToCopy) {
        this(description, sourceToCopy.managementContext, sourceToCopy.rebindContext, sourceToCopy.exceptionHandler);
    }

    public String getContextDescription() {
        return this.description.peek();
    }

    public String popContextDescription() {
        return this.description.pop();
    }

    public void pushContextDescription(String description) {
        this.description.push(description);
    }

    public ManagementContext lookupManagementContext() {
        return this.managementContext;
    }

    public Entity lookupEntity(String id) {
        Entity result = this.rebindContext.getEntity(id);
        if (result == null) {
            result = (Entity)this.managementContext.lookup(id, Entity.class);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingEntityRef(id);
        }
        return result;
    }

    public Location lookupLocation(String id) {
        Location result = this.rebindContext.getLocation(id);
        if (result == null) {
            result = (Location)this.managementContext.lookup(id, Location.class);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingLocationRef(id);
        }
        return result;
    }

    public Policy lookupPolicy(String id) {
        Policy result = this.rebindContext.getPolicy(id);
        if (result == null) {
            result = (Policy)this.managementContext.lookup(id, Policy.class);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingPolicyRef(id);
        }
        return result;
    }

    public Enricher lookupEnricher(String id) {
        Enricher result = this.rebindContext.getEnricher(id);
        if (result == null) {
            result = (Enricher)this.managementContext.lookup(id, Enricher.class);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingEnricherRef(id);
        }
        return result;
    }

    public Feed lookupFeed(String id) {
        Feed result = this.rebindContext.getFeed(id);
        if (result == null) {
            result = (Feed)this.managementContext.lookup(id, Feed.class);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingFeedRef(id);
        }
        return result;
    }

    public CatalogItem<?, ?> lookupCatalogItem(String id) {
        CatalogItem result = this.rebindContext.getCatalogItem(id);
        if (result == null) {
            result = CatalogUtils.getCatalogItemOptionalVersion(this.managementContext, id);
        }
        if (result == null) {
            if (this.managementContext.getTypeRegistry().get(id) != null) {
                return null;
            }
            result = this.exceptionHandler.onDanglingCatalogItemRef(id);
        }
        return result;
    }

    public ManagedBundle lookupBundle(String id) {
        ManagedBundle result = this.rebindContext.getBundle(id);
        if (result == null) {
            result = this.exceptionHandler.onDanglingBundleRef(id);
        }
        return result;
    }

    public BrooklynObject lookup(BrooklynObjectType type, String id) {
        if (type == null) {
            BrooklynObject result = this.peek(null, id);
            if (result == null) {
                this.exceptionHandler.onDanglingUntypedItemRef(id);
            }
            type = BrooklynObjectType.of((BrooklynObject)result);
        }
        switch (type) {
            case CATALOG_ITEM: {
                return this.lookupCatalogItem(id);
            }
            case MANAGED_BUNDLE: {
                return this.lookupBundle(id);
            }
            case ENRICHER: {
                return this.lookupEnricher(id);
            }
            case ENTITY: {
                return this.lookupEntity(id);
            }
            case FEED: {
                return this.lookupFeed(id);
            }
            case LOCATION: {
                return this.lookupLocation(id);
            }
            case POLICY: {
                return this.lookupPolicy(id);
            }
            case UNKNOWN: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected type " + type + " / id " + id);
    }

    public BrooklynObject peek(BrooklynObjectType type, String id) {
        if (type == null) {
            for (BrooklynObjectType typeX : BrooklynObjectType.values()) {
                BrooklynObject result = this.peek(typeX, id);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        switch (type) {
            case CATALOG_ITEM: {
                return this.rebindContext.getCatalogItem(id);
            }
            case MANAGED_BUNDLE: {
                return this.rebindContext.getBundle(id);
            }
            case ENRICHER: {
                return this.rebindContext.getEnricher(id);
            }
            case ENTITY: {
                return this.rebindContext.getEntity(id);
            }
            case FEED: {
                return this.rebindContext.getFeed(id);
            }
            case LOCATION: {
                return this.rebindContext.getLocation(id);
            }
            case POLICY: {
                return this.rebindContext.getPolicy(id);
            }
            case UNKNOWN: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected type " + type + " / id " + id);
    }
}

