/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.rebind.RebindContext;
import org.apache.brooklyn.api.mgmt.rebind.mementos.LocationMemento;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.internal.ConfigUtilsInternal;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.mgmt.rebind.AbstractBrooklynObjectRebindSupport;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicLocationMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.MementosGenerators;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLocationRebindSupport
extends AbstractBrooklynObjectRebindSupport<LocationMemento> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicLocationRebindSupport.class);
    private final AbstractLocation location;

    public BasicLocationRebindSupport(AbstractLocation location) {
        super(location);
        this.location = location;
    }

    @Override
    public LocationMemento getMemento() {
        return this.getMementoWithProperties(Collections.emptyMap());
    }

    @Deprecated
    protected LocationMemento getMementoWithProperties(Map<String, ?> props) {
        LocationMemento memento = ((BasicLocationMemento.Builder)MementosGenerators.newLocationMementoBuilder(this.location).customFields(props)).build();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating memento for location: {}", (Object)memento.toVerboseString());
        }
        return memento;
    }

    @Override
    protected void addConfig(RebindContext rebindContext, LocationMemento memento) {
        Collection<ConfigKey<?>> configKeys = this.location.getLocationTypeInternal().getConfigKeys().values();
        for (Map.Entry entry : memento.getLocationConfig().entrySet()) {
            Field field;
            Object value;
            String flagName = (String)entry.getKey();
            Map<?, ?> unused = ConfigUtilsInternal.setAllConfigKeys(MutableMap.of((Object)flagName, value = entry.getValue()), configKeys, this.location);
            if (unused.isEmpty()) continue;
            try {
                field = FlagUtils.findFieldForFlag(flagName, this.location);
            }
            catch (NoSuchElementException e) {
                field = null;
            }
            if (field == null) {
                this.location.config().putAll((Map<?, ?>)MutableMap.of((Object)flagName, value));
                continue;
            }
            Class<?> fieldType = field.getType();
            if (ConfigKey.class.isAssignableFrom(fieldType)) {
                ConfigKey configKey = (ConfigKey)FlagUtils.getField(this.location, field);
                this.location.config().set(configKey, entry.getValue());
                continue;
            }
            value = TypeCoercions.coerce(entry.getValue(), fieldType);
            if (value == null) continue;
            FlagUtils.setFieldFromFlag(this.location, flagName, value);
        }
    }

    @Override
    protected void addCustoms(RebindContext rebindContext, LocationMemento memento) {
        this.setParent(rebindContext, memento);
        this.addChildren(rebindContext, memento);
        this.location.init();
    }

    @Override
    public void addFeeds(RebindContext rebindContext, LocationMemento Memento2) {
        throw new UnsupportedOperationException();
    }

    protected void addChildren(RebindContext rebindContext, LocationMemento memento) {
        for (String childId : memento.getChildren()) {
            Location child = rebindContext.lookup().lookupLocation(childId);
            if (child != null) {
                this.location.addChild(child);
                continue;
            }
            LOG.warn("Ignoring child {} of location {}({}), as cannot be found", new Object[]{childId, memento.getType(), memento.getId()});
        }
    }

    protected void setParent(RebindContext rebindContext, LocationMemento memento) {
        Location parent;
        Location location = parent = memento.getParent() != null ? rebindContext.lookup().lookupLocation(memento.getParent()) : null;
        if (parent != null) {
            this.location.setParent(parent);
        } else if (memento.getParent() != null) {
            LOG.warn("Ignoring parent {} of location {}({}), as cannot be found", new Object[]{memento.getParent(), memento.getType(), memento.getId()});
        }
    }
}

