/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.rest.api.ActivityApi;
import org.apache.brooklyn.rest.domain.TaskSummary;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.TaskTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;

public class ActivityResource
extends AbstractBrooklynRestResource
implements ActivityApi {
    public TaskSummary get(String taskId) {
        Task<?> t = this.findTask(taskId);
        return (TaskSummary)TaskTransformer.fromTask(this.ui.getBaseUriBuilder()).apply(t);
    }

    @Deprecated
    public Map<String, TaskSummary> getAllChildrenAsMap(String taskId) {
        return this.getAllChildrenAsMap(taskId, 200, -1);
    }

    public Map<String, TaskSummary> getAllChildrenAsMap(String taskId, int limit, int maxDepth) {
        Task<?> parentTask = this.findTask(taskId);
        return this.getAllDescendantTasks(parentTask, limit, maxDepth);
    }

    protected Task<?> findTask(String taskId) {
        Task task = this.mgmt().getExecutionManager().getTask(taskId);
        if (task == null) {
            throw WebResourceUtils.notFound("Cannot find task '%s' - possibly garbage collected to save memory", taskId);
        }
        this.checkEntityEntitled(task);
        return task;
    }

    private LinkedHashMap<String, TaskSummary> getAllDescendantTasks(Task<?> parentTask, int limit, int maxDepth) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (!(parentTask instanceof HasTaskChildren)) {
            return result;
        }
        MutableSet nextLayer = MutableSet.copyOf((Iterable)((HasTaskChildren)parentTask).getChildren());
        block0: while (limit != 0 && !nextLayer.isEmpty() && maxDepth-- != 0) {
            MutableSet thisLayer = nextLayer;
            nextLayer = MutableSet.of();
            for (Task childTask : thisLayer) {
                TaskSummary wasThere = (TaskSummary)result.put(childTask.getId(), TaskTransformer.fromTask(this.ui.getBaseUriBuilder()).apply((Object)childTask));
                if (wasThere != null) continue;
                if (--limit == 0) break block0;
                if (!(childTask instanceof HasTaskChildren)) continue;
                Iterables.addAll((Collection)nextLayer, (Iterable)((HasTaskChildren)childTask).getChildren());
            }
        }
        return result;
    }

    public List<TaskSummary> children(String taskId, Boolean includeBackground) {
        Task<?> t = this.findTask(taskId);
        MutableSet result = MutableSet.copyOf(this.getSubTaskChildren(t));
        if (Boolean.TRUE.equals(includeBackground)) {
            result.addAll(this.getBackgroundedChildren(t));
        }
        return MutableList.copyOf((Iterable)result);
    }

    private Collection<? extends TaskSummary> getBackgroundedChildren(Task<?> t) {
        Entity entity = BrooklynTaskTags.getContextEntity(t);
        MutableList result = MutableList.of();
        if (entity != null) {
            Set tasks = BrooklynTaskTags.getTasksInEntityContext((ExecutionManager)this.mgmt().getExecutionManager(), (Entity)entity);
            for (Task ti : tasks) {
                if (!t.equals((Object)ti.getSubmittedByTask())) continue;
                result.add(TaskTransformer.fromTask(this.ui.getBaseUriBuilder()).apply((Object)ti));
            }
        }
        return result;
    }

    private List<TaskSummary> getSubTaskChildren(Task<?> t) {
        if (!(t instanceof HasTaskChildren)) {
            return Collections.emptyList();
        }
        return new LinkedList<TaskSummary>(Collections2.transform((Collection)Lists.newArrayList((Iterable)((HasTaskChildren)t).getChildren()), TaskTransformer.fromTask(this.ui.getBaseUriBuilder())));
    }

    public String stream(String taskId, String streamId) {
        Task<?> t = this.findTask(taskId);
        this.checkStreamEntitled(t, streamId);
        BrooklynTaskTags.WrappedStream stream = BrooklynTaskTags.stream(t, (String)streamId);
        if (stream == null) {
            throw WebResourceUtils.notFound("Cannot find stream '%s' in task '%s'", streamId, taskId);
        }
        return (String)stream.streamContents.get();
    }

    protected void checkEntityEntitled(Task<?> task) {
        Entity entity = BrooklynTaskTags.getContextEntity(task);
        if (entity != null && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see activity of entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
    }

    protected void checkStreamEntitled(Task<?> task, String streamId) {
        Entity entity = BrooklynTaskTags.getContextEntity(task);
        Entitlements.TaskAndItem item = new Entitlements.TaskAndItem(task, (Object)streamId);
        if (entity != null && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ACTIVITY_STREAMS, (Object)item)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see activity stream of entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
    }
}

