/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.logging.Logger;
import org.jclouds.softlayer.compute.functions.OperatingSystemToImage;
import org.jclouds.softlayer.domain.VirtualGuest;

@Singleton
public class VirtualGuestToImage
implements Function<VirtualGuest, Image> {
    private static final String UNRECOGNIZED = "UNRECOGNIZED";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final OperatingSystemToImage operatingSystemToImage;

    @Inject
    protected VirtualGuestToImage(OperatingSystemToImage operatingSystemToImage) {
        this.operatingSystemToImage = (OperatingSystemToImage)Preconditions.checkNotNull((Object)operatingSystemToImage, (Object)"operatingSystemToImage");
    }

    public Image apply(VirtualGuest from) {
        Preconditions.checkNotNull((Object)from, (Object)"from");
        if (from.getOperatingSystem() == null) {
            return new ImageBuilder().ids(this.getReferenceCodeOrId(from)).name(from.getHostname()).status(Image.Status.UNRECOGNIZED).operatingSystem(OperatingSystem.builder().family(OsFamily.UNRECOGNIZED).version(UNRECOGNIZED).description(UNRECOGNIZED).build()).build();
        }
        return this.operatingSystemToImage.apply(from.getOperatingSystem());
    }

    public String getReferenceCodeOrId(VirtualGuest from) {
        String val = from.getSoftwareLicense() != null && from.getSoftwareLicense().getSoftwareDescription() != null ? from.getSoftwareLicense().getSoftwareDescription().getReferenceCode() : from.getId() + "";
        return val;
    }
}

