/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.exceptions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.util.ErrorMessageUtil;

public class Warning
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String component;
    private final SourceLocation srcLocation;
    private final int code;
    private final String message;

    private Warning(String component, SourceLocation srcLocation, int code, String message) {
        this.component = component;
        this.srcLocation = srcLocation;
        this.code = code;
        this.message = message;
    }

    public static Warning of(String component, SourceLocation srcLocation, int code, String message) {
        return new Warning(component, srcLocation, code, message);
    }

    public static Warning forHyracks(SourceLocation srcLocation, int code, Serializable ... params) {
        return Warning.of("HYR", srcLocation, code, ErrorMessageUtil.formatMessage("HYR", code, ErrorCode.getErrorMessage(code), srcLocation, params));
    }

    public String getComponent() {
        return this.component;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public SourceLocation getSourceLocation() {
        return this.srcLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Warning warning = (Warning)o;
        return Objects.equals(this.message, warning.message);
    }

    public int hashCode() {
        return Objects.hash(this.message);
    }

    public void writeFields(DataOutput output) throws IOException {
        output.writeUTF(this.component);
        output.writeInt(this.code);
        output.writeUTF(this.message);
        SourceLocation.writeFields(this.srcLocation, output);
    }

    public static Warning create(DataInput input) throws IOException {
        String comp = input.readUTF();
        int code = input.readInt();
        String msg = input.readUTF();
        return new Warning(comp, SourceLocation.create(input), code, msg);
    }

    public String toString() {
        return "Warning{component='" + this.component + '\'' + ", srcLocation=" + this.srcLocation + ", code=" + this.code + ", message='" + this.message + '\'' + '}';
    }
}

