/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jobgen;

import java.util.List;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.functions.FunctionDescriptorTag;
import org.apache.asterix.external.library.ExternalFunctionDescriptorProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionManager;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ILogicalExpressionJobGen;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.ISerializedAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.ColumnAccessEvalFactory;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class QueryLogicalExpressionJobGen
implements ILogicalExpressionJobGen {
    private final IFunctionManager functionManager;

    public QueryLogicalExpressionJobGen(IFunctionManager functionManager) {
        this.functionManager = functionManager;
    }

    public IAggregateEvaluatorFactory createAggregateFunctionFactory(AggregateFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory[] args = this.codegenArguments((AbstractFunctionCallExpression)expr, env, inputSchemas, context);
        IFunctionDescriptor fd = this.resolveFunction((AbstractFunctionCallExpression)expr, env, context);
        switch (fd.getFunctionDescriptorTag()) {
            case SERIALAGGREGATE: {
                return null;
            }
            case AGGREGATE: {
                return fd.createAggregateEvaluatorFactory(args);
            }
        }
        throw new IllegalStateException("Invalid function descriptor " + fd.getFunctionDescriptorTag() + " expected " + FunctionDescriptorTag.SERIALAGGREGATE + " or " + FunctionDescriptorTag.AGGREGATE);
    }

    public IRunningAggregateEvaluatorFactory createRunningAggregateFunctionFactory(StatefulFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory[] args = this.codegenArguments((AbstractFunctionCallExpression)expr, env, inputSchemas, context);
        return this.resolveFunction((AbstractFunctionCallExpression)expr, env, context).createRunningAggregateEvaluatorFactory(args);
    }

    public IUnnestingEvaluatorFactory createUnnestingFunctionFactory(UnnestingFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory[] args = this.codegenArguments((AbstractFunctionCallExpression)expr, env, inputSchemas, context);
        return this.resolveFunction((AbstractFunctionCallExpression)expr, env, context).createUnnestingEvaluatorFactory(args);
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(ILogicalExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        switch (expr.getExpressionTag()) {
            case VARIABLE: {
                VariableReferenceExpression v = (VariableReferenceExpression)expr;
                IScalarEvaluatorFactory copyEvaluatorFactory = this.createVariableEvaluatorFactory(v, inputSchemas);
                return copyEvaluatorFactory;
            }
            case CONSTANT: {
                ConstantExpression c = (ConstantExpression)expr;
                IScalarEvaluatorFactory copyEvaluatorFactory = this.createConstantEvaluatorFactory(c, context);
                return copyEvaluatorFactory;
            }
            case FUNCTION_CALL: {
                IScalarEvaluatorFactory copyEvaluatorFactory = this.createScalarFunctionEvaluatorFactory((AbstractFunctionCallExpression)expr, env, inputSchemas, context);
                return copyEvaluatorFactory;
            }
        }
        throw new IllegalStateException();
    }

    private IScalarEvaluatorFactory createVariableEvaluatorFactory(VariableReferenceExpression expr, IOperatorSchema[] inputSchemas) throws AlgebricksException {
        LogicalVariable variable = expr.getVariableReference();
        for (IOperatorSchema scm : inputSchemas) {
            int pos = scm.findVariable(variable);
            if (pos < 0) continue;
            return new ColumnAccessEvalFactory(pos);
        }
        throw new AlgebricksException("Variable " + variable + " could not be found in any input schema.");
    }

    private IScalarEvaluatorFactory createScalarFunctionEvaluatorFactory(AbstractFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory[] args = this.codegenArguments(expr, env, inputSchemas, context);
        IFunctionDescriptor fd = null;
        if (expr.getFunctionInfo() instanceof IExternalFunctionInfo) {
            fd = ExternalFunctionDescriptorProvider.getExternalFunctionDescriptor((IExternalFunctionInfo)((IExternalFunctionInfo)expr.getFunctionInfo()));
            CompilerProperties props = ((IApplicationContext)context.getAppContext()).getCompilerProperties();
            FunctionTypeInferers.SET_ARGUMENTS_TYPE.infer((ILogicalExpression)expr, fd, env, props);
        } else {
            fd = this.resolveFunction(expr, env, context);
        }
        return fd.createEvaluatorFactory(args);
    }

    private IScalarEvaluatorFactory createConstantEvaluatorFactory(ConstantExpression expr, JobGenContext context) throws AlgebricksException {
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        return metadataProvider.getDataFormat().getConstantEvalFactory(expr.getValue());
    }

    private IScalarEvaluatorFactory[] codegenArguments(AbstractFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        List arguments = expr.getArguments();
        int n = arguments.size();
        IScalarEvaluatorFactory[] args = new IScalarEvaluatorFactory[n];
        int i = 0;
        for (Mutable a : arguments) {
            args[i++] = this.createEvaluatorFactory((ILogicalExpression)a.getValue(), env, inputSchemas, context);
        }
        return args;
    }

    public ISerializedAggregateEvaluatorFactory createSerializableAggregateFunctionFactory(AggregateFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        IScalarEvaluatorFactory[] args = this.codegenArguments((AbstractFunctionCallExpression)expr, env, inputSchemas, context);
        IFunctionDescriptor fd = this.resolveFunction((AbstractFunctionCallExpression)expr, env, context);
        switch (fd.getFunctionDescriptorTag()) {
            case AGGREGATE: {
                if (BuiltinFunctions.isAggregateFunctionSerializable((FunctionIdentifier)fd.getIdentifier())) {
                    AggregateFunctionCallExpression serialAggExpr = BuiltinFunctions.makeSerializableAggregateFunctionExpression((FunctionIdentifier)fd.getIdentifier(), (List)expr.getArguments());
                    IFunctionDescriptor afdd = this.resolveFunction((AbstractFunctionCallExpression)serialAggExpr, env, context);
                    return afdd.createSerializableAggregateEvaluatorFactory(args);
                }
                throw new AlgebricksException("Trying to create a serializable aggregate from a non-serializable aggregate function descriptor. (fi=" + expr.getFunctionIdentifier() + ")");
            }
            case SERIALAGGREGATE: {
                return fd.createSerializableAggregateEvaluatorFactory(args);
            }
        }
        throw new IllegalStateException("Invalid function descriptor " + fd.getFunctionDescriptorTag() + " expected " + FunctionDescriptorTag.SERIALAGGREGATE + " or " + FunctionDescriptorTag.AGGREGATE);
    }

    private IFunctionDescriptor resolveFunction(AbstractFunctionCallExpression expr, IVariableTypeEnvironment env, JobGenContext context) throws AlgebricksException {
        FunctionIdentifier fnId = expr.getFunctionIdentifier();
        SourceLocation sourceLocation = expr.getSourceLocation();
        IFunctionDescriptor fd = this.functionManager.lookupFunction(fnId, sourceLocation);
        fd.setSourceLocation(sourceLocation);
        IFunctionTypeInferer fnTypeInfer = this.functionManager.lookupFunctionTypeInferer(fnId);
        if (fnTypeInfer != null) {
            CompilerProperties compilerProps = ((IApplicationContext)context.getAppContext()).getCompilerProperties();
            fnTypeInfer.infer((ILogicalExpression)expr, fd, env, compilerProps);
        }
        return fd;
    }
}

