/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;

public abstract class AbstractFunctionCallExpression
extends AbstractLogicalExpression {
    protected IFunctionInfo finfo;
    private final List<Mutable<ILogicalExpression>> arguments;
    private Object[] opaqueParameters;
    private final FunctionKind kind;
    private final Map<Object, IExpressionAnnotation> annotationMap = new HashMap<Object, IExpressionAnnotation>();

    public AbstractFunctionCallExpression(FunctionKind kind, IFunctionInfo finfo, List<Mutable<ILogicalExpression>> arguments) {
        this.kind = Objects.requireNonNull(kind);
        this.finfo = Objects.requireNonNull(finfo);
        this.arguments = Objects.requireNonNull(arguments);
    }

    public AbstractFunctionCallExpression(FunctionKind kind, IFunctionInfo finfo) {
        this(kind, finfo, new ArrayList<Mutable<ILogicalExpression>>());
    }

    public AbstractFunctionCallExpression(FunctionKind kind, IFunctionInfo finfo, Mutable<ILogicalExpression> ... expressions) {
        this(kind, finfo);
        Collections.addAll(this.arguments, expressions);
    }

    public void setOpaqueParameters(Object[] opaqueParameters) {
        this.opaqueParameters = opaqueParameters;
    }

    public Object[] getOpaqueParameters() {
        return this.opaqueParameters;
    }

    public FunctionKind getKind() {
        return this.kind;
    }

    protected List<Mutable<ILogicalExpression>> cloneArguments() {
        ArrayList<Mutable<ILogicalExpression>> clonedArgs = new ArrayList<Mutable<ILogicalExpression>>(this.arguments.size());
        for (Mutable<ILogicalExpression> e : this.arguments) {
            ILogicalExpression e2 = ((ILogicalExpression)e.getValue()).cloneExpression();
            clonedArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)e2));
        }
        return clonedArgs;
    }

    public FunctionIdentifier getFunctionIdentifier() {
        return this.finfo.getFunctionIdentifier();
    }

    public IFunctionInfo getFunctionInfo() {
        return this.finfo;
    }

    public void setFunctionInfo(IFunctionInfo finfo) {
        this.finfo = finfo;
    }

    public List<Mutable<ILogicalExpression>> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return this.finfo.display(this.arguments);
    }

    @Override
    public LogicalExpressionTag getExpressionTag() {
        return LogicalExpressionTag.FUNCTION_CALL;
    }

    @Override
    public void getUsedVariables(Collection<LogicalVariable> vars) {
        for (Mutable<ILogicalExpression> arg : this.arguments) {
            ((ILogicalExpression)arg.getValue()).getUsedVariables(vars);
        }
    }

    @Override
    public void substituteVar(LogicalVariable v1, LogicalVariable v2) {
        for (Mutable<ILogicalExpression> arg : this.arguments) {
            ((ILogicalExpression)arg.getValue()).substituteVar(v1, v2);
        }
    }

    @Override
    public void getConstraintsAndEquivClasses(Collection<FunctionalDependency> fds, Map<LogicalVariable, EquivalenceClass> equivClasses) {
        FunctionIdentifier funId = this.getFunctionIdentifier();
        if (funId.equals(AlgebricksBuiltinFunctions.AND)) {
            for (Mutable<ILogicalExpression> a : this.arguments) {
                ((ILogicalExpression)a.getValue()).getConstraintsAndEquivClasses(fds, equivClasses);
            }
        } else if (funId.equals(AlgebricksBuiltinFunctions.EQ)) {
            ILogicalExpression opLeft = (ILogicalExpression)this.arguments.get(0).getValue();
            ILogicalExpression opRight = (ILogicalExpression)this.arguments.get(1).getValue();
            if (opLeft.getExpressionTag() == LogicalExpressionTag.CONSTANT && opRight.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                ConstantExpression op1 = (ConstantExpression)opLeft;
                VariableReferenceExpression op2 = (VariableReferenceExpression)opRight;
                AbstractFunctionCallExpression.getFDsAndEquivClassesForEqWithConstant(op1, op2, fds, equivClasses);
            } else if (opLeft.getExpressionTag() == LogicalExpressionTag.VARIABLE && opRight.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                VariableReferenceExpression op1 = (VariableReferenceExpression)opLeft;
                VariableReferenceExpression op2 = (VariableReferenceExpression)opRight;
                AbstractFunctionCallExpression.getFDsAndEquivClassesForColumnEq(op1, op2, fds, equivClasses);
            }
        }
    }

    @Override
    public void getConstraintsForOuterJoin(Collection<FunctionalDependency> fds, Collection<LogicalVariable> outerVars) {
        FunctionIdentifier funId = this.getFunctionIdentifier();
        if (funId.equals(AlgebricksBuiltinFunctions.AND)) {
            for (Mutable<ILogicalExpression> a : this.arguments) {
                ((ILogicalExpression)a.getValue()).getConstraintsForOuterJoin(fds, outerVars);
            }
        } else if (funId.equals(AlgebricksBuiltinFunctions.EQ)) {
            ILogicalExpression opLeft = (ILogicalExpression)this.arguments.get(0).getValue();
            ILogicalExpression opRight = (ILogicalExpression)this.arguments.get(1).getValue();
            if (opLeft.getExpressionTag() == LogicalExpressionTag.VARIABLE && opRight.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                LogicalVariable var1 = ((VariableReferenceExpression)opLeft).getVariableReference();
                LogicalVariable var2 = ((VariableReferenceExpression)opRight).getVariableReference();
                if (outerVars.contains(var1)) {
                    AbstractFunctionCallExpression.addFD(fds, var1, var2);
                }
                if (outerVars.contains(var2)) {
                    AbstractFunctionCallExpression.addFD(fds, var2, var1);
                }
            }
        }
    }

    public boolean equals(Object obj) {
        List<Mutable<ILogicalExpression>> fceArguments;
        if (!(obj instanceof AbstractFunctionCallExpression)) {
            return false;
        }
        AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)obj;
        boolean equal = this.getFunctionIdentifier().equals(fce.getFunctionIdentifier());
        if (!equal) {
            return false;
        }
        int argumentCount = this.arguments.size();
        if (argumentCount != (fceArguments = fce.getArguments()).size()) {
            return false;
        }
        for (int i = 0; i < argumentCount; ++i) {
            ILogicalExpression fceArgument;
            ILogicalExpression argument = (ILogicalExpression)this.arguments.get(i).getValue();
            if (argument.equals(fceArgument = (ILogicalExpression)fceArguments.get(i).getValue())) continue;
            return false;
        }
        return Arrays.deepEquals(this.opaqueParameters, fce.opaqueParameters);
    }

    public int hashCode() {
        int h = this.getFunctionIdentifier().hashCode();
        for (Mutable<ILogicalExpression> e : this.arguments) {
            h = h * 41 + ((ILogicalExpression)e.getValue()).hashCode();
        }
        if (this.opaqueParameters != null) {
            h = h * 31 + Arrays.deepHashCode(this.opaqueParameters);
        }
        return h;
    }

    @Override
    public boolean splitIntoConjuncts(List<Mutable<ILogicalExpression>> conjs) {
        if (!this.getFunctionIdentifier().equals(AlgebricksBuiltinFunctions.AND) || this.arguments.size() <= 1) {
            return false;
        }
        conjs.addAll(this.arguments);
        return true;
    }

    public Map<Object, IExpressionAnnotation> getAnnotations() {
        return this.annotationMap;
    }

    protected Map<Object, IExpressionAnnotation> cloneAnnotations() {
        HashMap<Object, IExpressionAnnotation> m = new HashMap<Object, IExpressionAnnotation>();
        for (Object k : this.annotationMap.keySet()) {
            IExpressionAnnotation annot2 = this.annotationMap.get(k).copy();
            m.put(k, annot2);
        }
        return m;
    }

    private static final void addFD(Collection<FunctionalDependency> fds, LogicalVariable var1, LogicalVariable var2) {
        LinkedList<LogicalVariable> set1 = new LinkedList<LogicalVariable>();
        set1.add(var1);
        LinkedList<LogicalVariable> set2 = new LinkedList<LogicalVariable>();
        set2.add(var2);
        FunctionalDependency fd1 = new FunctionalDependency(set1, set2);
        fds.add(fd1);
    }

    private static final void getFDsAndEquivClassesForEqWithConstant(ConstantExpression c, VariableReferenceExpression v, Collection<FunctionalDependency> fds, Map<LogicalVariable, EquivalenceClass> equivClasses) {
        LogicalVariable var = v.getVariableReference();
        LinkedList<LogicalVariable> head = new LinkedList<LogicalVariable>();
        LinkedList<LogicalVariable> tail = new LinkedList<LogicalVariable>();
        tail.add(var);
        FunctionalDependency fd = new FunctionalDependency(head, tail);
        fds.add(fd);
        EquivalenceClass ec = equivClasses.get(var);
        if (ec == null) {
            LinkedList<LogicalVariable> members = new LinkedList<LogicalVariable>();
            members.add(var);
            EquivalenceClass eclass = new EquivalenceClass(members, c);
            equivClasses.put(var, eclass);
        } else {
            ILogicalExpression c1;
            if (ec.representativeIsConst() && !(c1 = ec.getConstRepresentative()).equals(c)) {
                return;
            }
            ec.setConstRepresentative(c);
        }
    }

    private static final void getFDsAndEquivClassesForColumnEq(VariableReferenceExpression v1, VariableReferenceExpression v2, Collection<FunctionalDependency> fds, Map<LogicalVariable, EquivalenceClass> equivClasses) {
        LogicalVariable var1 = v1.getVariableReference();
        LogicalVariable var2 = v2.getVariableReference();
        LinkedList<LogicalVariable> set1 = new LinkedList<LogicalVariable>();
        set1.add(var1);
        LinkedList<LogicalVariable> set2 = new LinkedList<LogicalVariable>();
        set2.add(var2);
        FunctionalDependency fd1 = new FunctionalDependency(set1, set2);
        FunctionalDependency fd2 = new FunctionalDependency(set2, set1);
        fds.add(fd1);
        fds.add(fd2);
        EquivalenceClass ec1 = equivClasses.get(var1);
        EquivalenceClass ec2 = equivClasses.get(var2);
        if (ec1 == null && ec2 == null) {
            LinkedList<LogicalVariable> members = new LinkedList<LogicalVariable>();
            members.add(var1);
            members.add(var2);
            EquivalenceClass ec = new EquivalenceClass(members, var1);
            equivClasses.put(var1, ec);
            equivClasses.put(var2, ec);
        } else if (ec1 == null && ec2 != null) {
            ec2.addMember(var1);
            equivClasses.put(var1, ec2);
        } else if (ec2 == null && ec1 != null) {
            ec1.addMember(var2);
            equivClasses.put(var2, ec1);
        } else {
            ec1.merge(ec2);
            for (LogicalVariable w : equivClasses.keySet()) {
                if (!ec2.getMembers().contains(w)) continue;
                equivClasses.put(w, ec1);
            }
        }
    }

    @Override
    public boolean isFunctional() {
        if (!this.finfo.isFunctional()) {
            return false;
        }
        for (Mutable<ILogicalExpression> e : this.arguments) {
            if (((ILogicalExpression)e.getValue()).isFunctional()) continue;
            return false;
        }
        return true;
    }

    public static enum FunctionKind {
        SCALAR,
        STATEFUL,
        AGGREGATE,
        UNNEST;

    }
}

