/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.IActivityClusterGraphGenerator;
import org.apache.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobIdFactory;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.application.CCServiceContext;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class JobStartWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final byte[] acggfBytes;
    private final Set<JobFlag> jobFlags;
    private final DeploymentId deploymentId;
    private final IResultCallback<JobId> callback;
    private final JobIdFactory jobIdFactory;
    private final DeployedJobSpecId deployedJobSpecId;
    private final Map<byte[], byte[]> jobParameters;

    public JobStartWork(ClusterControllerService ccs, DeploymentId deploymentId, byte[] acggfBytes, Set<JobFlag> jobFlags, JobIdFactory jobIdFactory, Map<byte[], byte[]> jobParameters, IResultCallback<JobId> callback, DeployedJobSpecId deployedJobSpecId) {
        this.deploymentId = deploymentId;
        this.ccs = ccs;
        this.acggfBytes = acggfBytes;
        this.jobFlags = jobFlags;
        this.callback = callback;
        this.deployedJobSpecId = deployedJobSpecId;
        this.jobParameters = jobParameters;
        this.jobIdFactory = jobIdFactory;
    }

    protected void doRun() throws Exception {
        IJobManager jobManager = this.ccs.getJobManager();
        try {
            JobRun run;
            CCServiceContext ccServiceCtx = this.ccs.getContext();
            JobId jobId = this.jobIdFactory.create();
            if (this.deployedJobSpecId == null) {
                IActivityClusterGraphGeneratorFactory acggf = (IActivityClusterGraphGeneratorFactory)DeploymentUtils.deserialize((byte[])this.acggfBytes, (DeploymentId)this.deploymentId, (IServiceContext)ccServiceCtx);
                IActivityClusterGraphGenerator acgg = acggf.createActivityClusterGraphGenerator((ICCServiceContext)ccServiceCtx, this.jobFlags);
                run = new JobRun(this.ccs, this.deploymentId, jobId, acggf, acgg, this.jobFlags);
            } else {
                run = new JobRun(this.ccs, this.deploymentId, jobId, this.jobFlags, this.ccs.getDeployedJobSpecStore().getDeployedJobSpecDescriptor(this.deployedJobSpecId), this.jobParameters, this.deployedJobSpecId);
            }
            jobManager.add(run);
            this.callback.setValue((Object)jobId);
        }
        catch (Exception e) {
            this.callback.setException(e);
        }
    }
}

