/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.UnitOfWorkHelper;

public class BridgeExceptionHandlerToErrorHandler
implements ExceptionHandler {
    private final LoggingExceptionHandler fallback;
    private final DefaultConsumer consumer;
    private final Processor bridge;

    public BridgeExceptionHandlerToErrorHandler(DefaultConsumer consumer) {
        this.consumer = consumer;
        this.fallback = new LoggingExceptionHandler(consumer.getEndpoint().getCamelContext(), ((Object)((Object)consumer)).getClass());
        this.bridge = consumer.getProcessor();
    }

    public void handleException(Throwable exception) {
        this.handleException(null, exception);
    }

    public void handleException(String message, Throwable exception) {
        this.handleException(message, null, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(String message, Exchange exchange, Throwable exception) {
        Exchange copy = exchange == null ? this.consumer.getEndpoint().createExchange() : ExchangeHelper.createCorrelatedCopy(exchange, false);
        copy.setException(exception);
        copy.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)exception);
        copy.getIn().setBody((Object)message);
        copy.setProperty(ExchangePropertyKey.ERRORHANDLER_BRIDGE, (Object)true);
        copy.getExchangeExtension().setRedeliveryExhausted(true);
        UnitOfWork uow = null;
        try {
            uow = this.consumer.createUoW(copy);
            this.bridge.process(copy);
        }
        catch (Exception e) {
            this.fallback.handleException("Error bridge handling existing exception " + exception.getMessage() + " due to: " + e.getMessage(), copy, e);
        }
        finally {
            UnitOfWorkHelper.doneUow(uow, copy);
        }
    }
}

