/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.opengl;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.nio.FloatBuffer;

public final class VBORegionSPES2
extends GLRegion {
    private final RenderState.ProgramLocal rsLocal = new RenderState.ProgramLocal();
    private final GLUniformData gcu_ColorTexUnit;
    private final float[] colorTexBBox;
    private final GLUniformData gcu_ColorTexBBox;
    private ShaderProgram spPass1 = null;
    private static final boolean throwOnError = false;

    public VBORegionSPES2(GLProfile gLProfile, int n, TextureSequence textureSequence, int n2, int n3) {
        super(gLProfile, n, textureSequence);
        this.initBuffer(n2, n3);
        if (this.hasColorTexture()) {
            this.gcu_ColorTexUnit = new GLUniformData("gcu_ColorTexUnit", textureSequence.getTextureUnit());
            this.colorTexBBox = new float[4];
            this.gcu_ColorTexBBox = new GLUniformData("gcu_ColorTexBBox", 4, FloatBuffer.wrap(this.colorTexBBox));
        } else {
            this.gcu_ColorTexUnit = null;
            this.colorTexBBox = null;
            this.gcu_ColorTexBBox = null;
        }
    }

    @Override
    public void setTextureUnit(int n) {
    }

    @Override
    protected final void clearImpl(GL2ES2 gL2ES2) {
    }

    @Override
    protected void updateImpl(GL2ES2 gL2ES2, int n) {
        boolean bl = Region.hasColorChannel(n);
        boolean bl2 = Region.hasColorTexture(n);
        this.vpc_ileave.seal(gL2ES2, true);
        this.vpc_ileave.enableBuffer(gL2ES2, false);
        if (bl2 && null != this.gcu_ColorTexUnit && this.colorTexSeq.isTextureAvailable()) {
            TextureSequence.TextureFrame textureFrame = this.colorTexSeq.getLastTexture();
            Texture texture = textureFrame.getTexture();
            TextureCoords textureCoords = texture.getImageTexCoords();
            float f = 1.0f / (textureCoords.right() - textureCoords.left());
            this.colorTexBBox[0] = this.box.getMinX() * f;
            this.colorTexBBox[2] = this.box.getMaxX() * f;
            if (texture.getMustFlipVertically()) {
                float f2 = 1.0f / (textureCoords.bottom() - textureCoords.top());
                this.colorTexBBox[1] = this.box.getMaxY() * f2;
                this.colorTexBBox[3] = this.box.getMinY() * f2;
            } else {
                float f3 = 1.0f / (textureCoords.top() - textureCoords.bottom());
                this.colorTexBBox[1] = this.box.getMinY() * f3;
                this.colorTexBBox[3] = this.box.getMaxY() * f3;
            }
        }
        this.indicesBuffer.seal(gL2ES2, true);
        this.indicesBuffer.enableBuffer(gL2ES2, false);
        if (DEBUG_INSTANCE) {
            System.err.println("VBORegionSPES2 idx " + this.indicesBuffer);
            System.err.println("VBORegionSPES2 vpc " + this.vpc_ileave);
        }
    }

    public void useShaderProgram(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int n, int n2) {
        boolean bl = Region.hasColorChannel(n);
        boolean bl2 = Region.hasColorTexture(n) && null != this.colorTexSeq;
        RenderState renderState = regionRenderer.getRenderState();
        boolean bl3 = regionRenderer.useShaderProgram(gL2ES2, n, true, n2, 0, this.colorTexSeq);
        ShaderProgram shaderProgram = regionRenderer.getRenderState().getShaderProgram();
        boolean bl4 = !shaderProgram.equals(this.spPass1);
        this.spPass1 = shaderProgram;
        if (DEBUG) {
            System.err.println("XXX changedSP.p1 updateLocation loc " + bl4 + " / glob " + bl3);
        }
        if (bl4) {
            renderState.updateAttributeLoc(gL2ES2, true, this.gca_VerticesAttr, false);
            renderState.updateAttributeLoc(gL2ES2, true, this.gca_CurveParamsAttr, false);
            if (bl && null != this.gca_ColorsAttr) {
                renderState.updateAttributeLoc(gL2ES2, true, this.gca_ColorsAttr, false);
            }
        }
        this.rsLocal.update(gL2ES2, renderState, bl4, n, true, false);
        if (bl2 && null != this.gcu_ColorTexUnit) {
            renderState.updateUniformLoc(gL2ES2, bl4, this.gcu_ColorTexUnit, false);
            renderState.updateUniformLoc(gL2ES2, bl4, this.gcu_ColorTexBBox, false);
        }
    }

    @Override
    protected void drawImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int n, int[] nArray) {
        boolean bl = Region.hasColorChannel(n);
        boolean bl2 = Region.hasColorTexture(n);
        this.useShaderProgram(gL2ES2, regionRenderer, n, this.getQuality());
        if (0 >= this.indicesBuffer.getElemCount()) {
            if (DEBUG_INSTANCE) {
                System.err.printf("VBORegionSPES2.drawImpl: Empty%n", new Object[0]);
            }
            return;
        }
        this.vpc_ileave.enableBuffer(gL2ES2, true);
        this.indicesBuffer.bindBuffer(gL2ES2, true);
        if (regionRenderer.getRenderState().isHintMaskSet(1)) {
            gL2ES2.glBlendFunc(770, 771);
        }
        if (bl2 && null != this.gcu_ColorTexUnit && this.colorTexSeq.isTextureAvailable()) {
            TextureSequence.TextureFrame textureFrame = this.colorTexSeq.getNextTexture(gL2ES2);
            gL2ES2.glActiveTexture(33984 + this.colorTexSeq.getTextureUnit());
            Texture texture = textureFrame.getTexture();
            texture.bind(gL2ES2);
            texture.enable(gL2ES2);
            this.gcu_ColorTexUnit.setData(this.colorTexSeq.getTextureUnit());
            gL2ES2.glUniform(this.gcu_ColorTexUnit);
            gL2ES2.glUniform(this.gcu_ColorTexBBox);
            gL2ES2.glDrawElements(4, this.indicesBuffer.getElemCount() * this.indicesBuffer.getCompsPerElem(), this.glIdxType(), 0L);
            texture.disable(gL2ES2);
        } else {
            gL2ES2.glDrawElements(4, this.indicesBuffer.getElemCount() * this.indicesBuffer.getCompsPerElem(), this.glIdxType(), 0L);
        }
        this.indicesBuffer.bindBuffer(gL2ES2, false);
        this.vpc_ileave.enableBuffer(gL2ES2, false);
    }

    @Override
    protected void destroyImpl(GL2ES2 gL2ES2) {
        if (DEBUG_INSTANCE) {
            System.err.println("VBORegionSPES2 Destroy: " + this);
        }
        this.spPass1 = null;
    }
}

