/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.Level;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.nodes.NodesStatsResponse;
import org.opensearch.client.opensearch.nodes.stats.NodesStatsIndexMetric;
import org.opensearch.client.opensearch.nodes.stats.NodesStatsMetric;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class NodesStatsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, NodesStatsRequest> {
    @Nonnull
    private final List<String> completionFields;
    @Nonnull
    private final List<String> fielddataFields;
    @Nonnull
    private final List<String> fields;
    @Nonnull
    private final List<String> groups;
    @Nullable
    private final Boolean includeSegmentFileSizes;
    @Nonnull
    private final List<NodesStatsIndexMetric> indexMetric;
    @Nullable
    private final Level level;
    @Nonnull
    private final List<NodesStatsMetric> metric;
    @Nonnull
    private final List<String> nodeId;
    @Nullable
    private final Time timeout;
    @Nonnull
    private final List<String> types;
    public static final Endpoint<NodesStatsRequest, NodesStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<NodesStatsRequest, NodesStatsResponse>(request -> "GET", request -> {
        boolean _indexMetric = true;
        int _metric = 2;
        int _nodeId = 4;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.indexMetric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 2;
        }
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= 4;
        }
        if (propsSet == 0) {
            return "/_nodes/stats";
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/stats/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/stats/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexMetric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 4) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet == 6) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            buf.append("/stats/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            buf.append("/stats/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexMetric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, NodesStatsResponse._DESERIALIZER);

    private NodesStatsRequest(Builder builder) {
        super(builder);
        this.completionFields = ApiTypeHelper.unmodifiable(builder.completionFields);
        this.fielddataFields = ApiTypeHelper.unmodifiable(builder.fielddataFields);
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.groups = ApiTypeHelper.unmodifiable(builder.groups);
        this.includeSegmentFileSizes = builder.includeSegmentFileSizes;
        this.indexMetric = ApiTypeHelper.unmodifiable(builder.indexMetric);
        this.level = builder.level;
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.timeout = builder.timeout;
        this.types = ApiTypeHelper.unmodifiable(builder.types);
    }

    public static NodesStatsRequest of(Function<Builder, ObjectBuilder<NodesStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> completionFields() {
        return this.completionFields;
    }

    @Nonnull
    public final List<String> fielddataFields() {
        return this.fielddataFields;
    }

    @Nonnull
    public final List<String> fields() {
        return this.fields;
    }

    @Nonnull
    public final List<String> groups() {
        return this.groups;
    }

    @Nullable
    public final Boolean includeSegmentFileSizes() {
        return this.includeSegmentFileSizes;
    }

    @Nonnull
    public final List<NodesStatsIndexMetric> indexMetric() {
        return this.indexMetric;
    }

    @Nullable
    public final Level level() {
        return this.level;
    }

    @Nonnull
    public final List<NodesStatsMetric> metric() {
        return this.metric;
    }

    @Nonnull
    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nonnull
    public final List<String> types() {
        return this.types;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (ApiTypeHelper.isDefined(this.completionFields)) {
            params.put("completion_fields", String.join((CharSequence)",", this.completionFields));
        }
        if (ApiTypeHelper.isDefined(this.fielddataFields)) {
            params.put("fielddata_fields", String.join((CharSequence)",", this.fielddataFields));
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            params.put("fields", String.join((CharSequence)",", this.fields));
        }
        if (ApiTypeHelper.isDefined(this.groups)) {
            params.put("groups", String.join((CharSequence)",", this.groups));
        }
        if (this.includeSegmentFileSizes != null) {
            params.put("include_segment_file_sizes", String.valueOf(this.includeSegmentFileSizes));
        }
        if (this.level != null) {
            params.put("level", this.level.jsonValue());
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(this.types)) {
            params.put("types", String.join((CharSequence)",", this.types));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.completionFields);
        result = 31 * result + Objects.hashCode(this.fielddataFields);
        result = 31 * result + Objects.hashCode(this.fields);
        result = 31 * result + Objects.hashCode(this.groups);
        result = 31 * result + Objects.hashCode(this.includeSegmentFileSizes);
        result = 31 * result + Objects.hashCode(this.indexMetric);
        result = 31 * result + Objects.hashCode(this.level);
        result = 31 * result + Objects.hashCode(this.metric);
        result = 31 * result + Objects.hashCode(this.nodeId);
        result = 31 * result + Objects.hashCode(this.timeout);
        result = 31 * result + Objects.hashCode(this.types);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodesStatsRequest other = (NodesStatsRequest)o;
        return Objects.equals(this.completionFields, other.completionFields) && Objects.equals(this.fielddataFields, other.fielddataFields) && Objects.equals(this.fields, other.fields) && Objects.equals(this.groups, other.groups) && Objects.equals(this.includeSegmentFileSizes, other.includeSegmentFileSizes) && Objects.equals(this.indexMetric, other.indexMetric) && Objects.equals(this.level, other.level) && Objects.equals(this.metric, other.metric) && Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.types, other.types);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NodesStatsRequest> {
        @Nullable
        private List<String> completionFields;
        @Nullable
        private List<String> fielddataFields;
        @Nullable
        private List<String> fields;
        @Nullable
        private List<String> groups;
        @Nullable
        private Boolean includeSegmentFileSizes;
        @Nullable
        private List<NodesStatsIndexMetric> indexMetric;
        @Nullable
        private Level level;
        @Nullable
        private List<NodesStatsMetric> metric;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Time timeout;
        @Nullable
        private List<String> types;

        public Builder() {
        }

        private Builder(NodesStatsRequest o) {
            super(o);
            this.completionFields = Builder._listCopy(o.completionFields);
            this.fielddataFields = Builder._listCopy(o.fielddataFields);
            this.fields = Builder._listCopy(o.fields);
            this.groups = Builder._listCopy(o.groups);
            this.includeSegmentFileSizes = o.includeSegmentFileSizes;
            this.indexMetric = Builder._listCopy(o.indexMetric);
            this.level = o.level;
            this.metric = Builder._listCopy(o.metric);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.timeout = o.timeout;
            this.types = Builder._listCopy(o.types);
        }

        private Builder(Builder o) {
            super(o);
            this.completionFields = Builder._listCopy(o.completionFields);
            this.fielddataFields = Builder._listCopy(o.fielddataFields);
            this.fields = Builder._listCopy(o.fields);
            this.groups = Builder._listCopy(o.groups);
            this.includeSegmentFileSizes = o.includeSegmentFileSizes;
            this.indexMetric = Builder._listCopy(o.indexMetric);
            this.level = o.level;
            this.metric = Builder._listCopy(o.metric);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.timeout = o.timeout;
            this.types = Builder._listCopy(o.types);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder completionFields(List<String> list) {
            this.completionFields = Builder._listAddAll(this.completionFields, list);
            return this;
        }

        @Nonnull
        public final Builder completionFields(String value, String ... values) {
            this.completionFields = Builder._listAdd(this.completionFields, value, values);
            return this;
        }

        @Nonnull
        public final Builder fielddataFields(List<String> list) {
            this.fielddataFields = Builder._listAddAll(this.fielddataFields, list);
            return this;
        }

        @Nonnull
        public final Builder fielddataFields(String value, String ... values) {
            this.fielddataFields = Builder._listAdd(this.fielddataFields, value, values);
            return this;
        }

        @Nonnull
        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        @Nonnull
        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Nonnull
        public final Builder groups(List<String> list) {
            this.groups = Builder._listAddAll(this.groups, list);
            return this;
        }

        @Nonnull
        public final Builder groups(String value, String ... values) {
            this.groups = Builder._listAdd(this.groups, value, values);
            return this;
        }

        @Nonnull
        public final Builder includeSegmentFileSizes(@Nullable Boolean value) {
            this.includeSegmentFileSizes = value;
            return this;
        }

        @Nonnull
        public final Builder indexMetric(List<NodesStatsIndexMetric> list) {
            this.indexMetric = Builder._listAddAll(this.indexMetric, list);
            return this;
        }

        @Nonnull
        public final Builder indexMetric(NodesStatsIndexMetric value, NodesStatsIndexMetric ... values) {
            this.indexMetric = Builder._listAdd(this.indexMetric, value, values);
            return this;
        }

        @Nonnull
        public final Builder level(@Nullable Level value) {
            this.level = value;
            return this;
        }

        @Nonnull
        public final Builder metric(List<NodesStatsMetric> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        @Nonnull
        public final Builder metric(NodesStatsMetric value, NodesStatsMetric ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        @Nonnull
        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        @Nonnull
        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder types(List<String> list) {
            this.types = Builder._listAddAll(this.types, list);
            return this;
        }

        @Nonnull
        public final Builder types(String value, String ... values) {
            this.types = Builder._listAdd(this.types, value, values);
            return this;
        }

        @Override
        @Nonnull
        public NodesStatsRequest build() {
            this._checkSingleUse();
            return new NodesStatsRequest(this);
        }
    }
}

