/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.info;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opensearch.neuralsearch.processor.rerank.RerankType;
import org.opensearch.neuralsearch.settings.NeuralSearchSettingsAccessor;
import org.opensearch.neuralsearch.stats.common.StatSnapshot;
import org.opensearch.neuralsearch.stats.info.CountableInfoStatSnapshot;
import org.opensearch.neuralsearch.stats.info.InfoStatName;
import org.opensearch.neuralsearch.stats.info.InfoStatType;
import org.opensearch.neuralsearch.stats.info.SettableInfoStatSnapshot;
import org.opensearch.neuralsearch.util.NeuralSearchClusterUtil;
import org.opensearch.neuralsearch.util.PipelineServiceUtil;

public class InfoStatsManager {
    public static final String PROCESSORS_KEY = "processors";
    public static final String REQUEST_PROCESSORS_KEY = "request_processors";
    public static final String RESPONSE_PROCESSORS_KEY = "response_processors";
    public static final String PHASE_PROCESSORS_KEY = "phase_results_processors";
    private final NeuralSearchClusterUtil neuralSearchClusterUtil;
    private final NeuralSearchSettingsAccessor settingsAccessor;
    private final PipelineServiceUtil pipelineServiceUtil;
    private static final Map<String, Consumer<Map<InfoStatName, CountableInfoStatSnapshot>>> chunkingAlgorithmIncrementers = Map.of("delimiter", stats -> InfoStatsManager.increment(stats, InfoStatName.TEXT_CHUNKING_DELIMITER_PROCESSORS), "fixed_token_length", stats -> InfoStatsManager.increment(stats, InfoStatName.TEXT_CHUNKING_FIXED_TOKEN_LENGTH_PROCESSORS), "fixed_char_length", stats -> InfoStatsManager.increment(stats, InfoStatName.TEXT_CHUNKING_FIXED_CHAR_LENGTH_PROCESSORS));
    private static final Map<String, Consumer<Map<InfoStatName, CountableInfoStatSnapshot>>> normTechniqueIncrementers = Map.of("l2", stats -> InfoStatsManager.increment(stats, InfoStatName.NORM_TECHNIQUE_L2_PROCESSORS), "min_max", stats -> InfoStatsManager.increment(stats, InfoStatName.NORM_TECHNIQUE_MINMAX_PROCESSORS), "z_score", stats -> InfoStatsManager.increment(stats, InfoStatName.NORM_TECHNIQUE_ZSCORE_PROCESSORS));
    private static final Map<String, Consumer<Map<InfoStatName, CountableInfoStatSnapshot>>> combTechniqueIncrementers = Map.of("arithmetic_mean", stats -> InfoStatsManager.increment(stats, InfoStatName.COMB_TECHNIQUE_ARITHMETIC_PROCESSORS), "harmonic_mean", stats -> InfoStatsManager.increment(stats, InfoStatName.COMB_TECHNIQUE_HARMONIC_PROCESSORS), "geometric_mean", stats -> InfoStatsManager.increment(stats, InfoStatName.COMB_TECHNIQUE_GEOMETRIC_PROCESSORS), "rrf", stats -> InfoStatsManager.increment(stats, InfoStatName.COMB_TECHNIQUE_RRF_PROCESSORS));

    public InfoStatsManager(NeuralSearchClusterUtil neuralSearchClusterUtil, NeuralSearchSettingsAccessor settingsAccessor, PipelineServiceUtil pipelineServiceUtil) {
        this.neuralSearchClusterUtil = neuralSearchClusterUtil;
        this.settingsAccessor = settingsAccessor;
        this.pipelineServiceUtil = pipelineServiceUtil;
    }

    public Map<InfoStatName, StatSnapshot<?>> getStats(EnumSet<InfoStatName> statsToRetrieve) {
        Map<InfoStatName, CountableInfoStatSnapshot> countableInfoStats = this.getCountableStats();
        Map<InfoStatName, SettableInfoStatSnapshot<?>> settableInfoStats = this.getSettableStats();
        HashMap<InfoStatName, StatSnapshot<Long>> prefilteredStats = new HashMap<InfoStatName, StatSnapshot<Long>>();
        prefilteredStats.putAll(countableInfoStats);
        prefilteredStats.putAll(settableInfoStats);
        Map<InfoStatName, StatSnapshot<?>> filteredStats = prefilteredStats.entrySet().stream().filter(entry -> statsToRetrieve.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return filteredStats;
    }

    private Map<InfoStatName, CountableInfoStatSnapshot> getCountableStats() {
        HashMap<InfoStatName, CountableInfoStatSnapshot> countableInfoStats = new HashMap<InfoStatName, CountableInfoStatSnapshot>();
        for (InfoStatName stat : EnumSet.allOf(InfoStatName.class)) {
            if (stat.getStatType() != InfoStatType.INFO_COUNTER) continue;
            countableInfoStats.put(stat, new CountableInfoStatSnapshot(stat));
        }
        this.addIngestProcessorStats(countableInfoStats);
        this.addSearchProcessorStats(countableInfoStats);
        return countableInfoStats;
    }

    private Map<InfoStatName, SettableInfoStatSnapshot<?>> getSettableStats() {
        HashMap settableInfoStats = new HashMap();
        for (InfoStatName statName : EnumSet.allOf(InfoStatName.class)) {
            switch (statName.getStatType()) {
                case INFO_BOOLEAN: {
                    settableInfoStats.put(statName, new SettableInfoStatSnapshot(statName));
                    break;
                }
                case INFO_STRING: {
                    settableInfoStats.put(statName, new SettableInfoStatSnapshot(statName));
                }
            }
        }
        this.addClusterVersionStat(settableInfoStats);
        return settableInfoStats;
    }

    private void addClusterVersionStat(Map<InfoStatName, SettableInfoStatSnapshot<?>> stats) {
        InfoStatName infoStatName = InfoStatName.CLUSTER_VERSION;
        String version = this.neuralSearchClusterUtil.getClusterMinVersion().toString();
        stats.put(infoStatName, new SettableInfoStatSnapshot<String>(infoStatName, version));
    }

    private void addSearchProcessorStats(Map<InfoStatName, CountableInfoStatSnapshot> stats) {
        List<Map<String, Object>> pipelineConfigs = this.pipelineServiceUtil.getSearchPipelineConfigs();
        for (Map<String, Object> pipelineConfig : pipelineConfigs) {
            List<Map<String, Object>> list;
            List<Map<String, Object>> phaseResultsProcessors;
            List<Map<String, Object>> requestProcessors = this.asListOfMaps(pipelineConfig.get(REQUEST_PROCESSORS_KEY));
            if (requestProcessors != null) {
                for (Map<String, Object> map : requestProcessors) {
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        String processorType = entry.getKey();
                        Map<String, Object> processorConfig = this.asMap(entry.getValue());
                        switch (processorType) {
                            case "neural_query_enricher": {
                                InfoStatsManager.increment(stats, InfoStatName.NEURAL_QUERY_ENRICHER_PROCESSORS);
                                break;
                            }
                            case "neural_sparse_two_phase_processor": {
                                InfoStatsManager.increment(stats, InfoStatName.NEURAL_SPARSE_TWO_PHASE_PROCESSORS);
                                break;
                            }
                            case "agentic_query_translator": {
                                InfoStatsManager.increment(stats, InfoStatName.AGENTIC_QUERY_TRANSLATOR_PROCESSORS);
                            }
                        }
                    }
                }
            }
            if ((phaseResultsProcessors = this.asListOfMaps(pipelineConfig.get(PHASE_PROCESSORS_KEY))) != null) {
                for (Map<String, Object> phaseResultsProcessor : phaseResultsProcessors) {
                    for (Map.Entry<String, Object> entry2 : phaseResultsProcessor.entrySet()) {
                        String processorType = entry2.getKey();
                        Map<String, Object> processorConfig = this.asMap(entry2.getValue());
                        switch (processorType) {
                            case "normalization-processor": {
                                this.countNormalizationProcessorStats(stats, processorConfig);
                                break;
                            }
                            case "score-ranker-processor": {
                                this.countRRFProcessorStats(stats, processorConfig);
                            }
                        }
                    }
                }
            }
            if ((list = this.asListOfMaps(pipelineConfig.get(RESPONSE_PROCESSORS_KEY))) == null) continue;
            for (Map map : list) {
                for (Map.Entry entry : map.entrySet()) {
                    String processorType = (String)entry.getKey();
                    Map<String, Object> processorConfig = this.asMap(entry.getValue());
                    switch (processorType) {
                        case "rerank": {
                            this.countRerankProcessorStats(stats, processorConfig);
                            break;
                        }
                        case "agentic_context": {
                            InfoStatsManager.increment(stats, InfoStatName.AGENTIC_CONTEXT_PROCESSORS);
                        }
                    }
                }
            }
        }
    }

    private void addIngestProcessorStats(Map<InfoStatName, CountableInfoStatSnapshot> stats) {
        List<Map<String, Object>> pipelineConfigs = this.pipelineServiceUtil.getIngestPipelineConfigs();
        for (Map<String, Object> pipelineConfig : pipelineConfigs) {
            List<Map<String, Object>> ingestProcessors = this.asListOfMaps(pipelineConfig.get(PROCESSORS_KEY));
            if (ingestProcessors == null) continue;
            for (Map<String, Object> ingestProcessor : ingestProcessors) {
                for (Map.Entry<String, Object> entry : ingestProcessor.entrySet()) {
                    String processorType = entry.getKey();
                    Map<String, Object> processorConfig = this.asMap(entry.getValue());
                    switch (processorType) {
                        case "text_embedding": {
                            this.countTextEmbeddingProcessorStats(stats, processorConfig);
                            break;
                        }
                        case "text_image_embedding": {
                            this.countTextImageEmbeddingProcessorStats(stats, processorConfig);
                            break;
                        }
                        case "text_chunking": {
                            this.countTextChunkingProcessorStats(stats, processorConfig);
                            break;
                        }
                        case "sparse_encoding": {
                            this.countSparseEncodingProcessorStats(stats, processorConfig);
                        }
                    }
                }
            }
        }
    }

    private void countTextEmbeddingProcessorStats(Map<InfoStatName, CountableInfoStatSnapshot> stats, Map<String, Object> processorConfig) {
        InfoStatsManager.increment(stats, InfoStatName.TEXT_EMBEDDING_PROCESSORS);
        Object skipExisting = processorConfig.get("skip_existing");
        if (Objects.nonNull(skipExisting) && skipExisting.equals(Boolean.TRUE)) {
            InfoStatsManager.increment(stats, InfoStatName.SKIP_EXISTING_PROCESSORS);
        }
    }

    private void countTextImageEmbeddingProcessorStats(Map<InfoStatName, CountableInfoStatSnapshot> stats, Map<String, Object> processorConfig) {
        InfoStatsManager.increment(stats, InfoStatName.TEXT_IMAGE_EMBEDDING_PROCESSORS);
        Object skipExisting = processorConfig.get("skip_existing");
        if (Objects.nonNull(skipExisting) && skipExisting.equals(Boolean.TRUE)) {
            InfoStatsManager.increment(stats, InfoStatName.SKIP_EXISTING_PROCESSORS);
        }
    }

    private void countSparseEncodingProcessorStats(Map<InfoStatName, CountableInfoStatSnapshot> stats, Map<String, Object> processorConfig) {
        InfoStatsManager.increment(stats, InfoStatName.SPARSE_ENCODING_PROCESSORS);
        Object skipExisting = processorConfig.get("skip_existing");
        if (Objects.nonNull(skipExisting) && skipExisting.equals(Boolean.TRUE)) {
            InfoStatsManager.increment(stats, InfoStatName.SKIP_EXISTING_PROCESSORS);
        }
    }

    private void countTextChunkingProcessorStats(Map<InfoStatName, CountableInfoStatSnapshot> stats, Map<String, Object> processorConfig) {
        InfoStatsManager.increment(stats, InfoStatName.TEXT_CHUNKING_PROCESSORS);
        Map<String, Object> algorithmMap = this.asMap(processorConfig.get("algorithm"));
        Map.Entry<String, Object> algorithmEntry = algorithmMap.entrySet().iterator().next();
        String algorithmKey = algorithmEntry.getKey();
        if (!chunkingAlgorithmIncrementers.containsKey(algorithmKey)) {
            InfoStatsManager.increment(stats, InfoStatName.TEXT_CHUNKING_FIXED_TOKEN_LENGTH_PROCESSORS);
        } else {
            chunkingAlgorithmIncrementers.get(algorithmKey).accept(stats);
        }
    }

    private void countNormalizationProcessorStats(Map<InfoStatName, CountableInfoStatSnapshot> stats, Map<String, Object> processorConfig) {
        InfoStatsManager.increment(stats, InfoStatName.NORMALIZATION_PROCESSORS);
        String normalizationTechnique = this.asString(this.asMap(processorConfig.get("normalization")).get("technique"));
        String combinationTechnique = this.asString(this.asMap(processorConfig.get("combination")).get("technique"));
        this.callNullableIncrementer(stats, normTechniqueIncrementers.get(normalizationTechnique));
        this.callNullableIncrementer(stats, combTechniqueIncrementers.get(combinationTechnique));
    }

    private void countRRFProcessorStats(Map<InfoStatName, CountableInfoStatSnapshot> stats, Map<String, Object> processorConfig) {
        InfoStatsManager.increment(stats, InfoStatName.RRF_PROCESSORS);
        String combinationTechnique = this.asString(this.asMap(processorConfig.get("combination")).get("technique"));
        this.callNullableIncrementer(stats, combTechniqueIncrementers.get(combinationTechnique));
    }

    private void countRerankProcessorStats(Map<InfoStatName, CountableInfoStatSnapshot> stats, Map<String, Object> processorConfig) {
        if (processorConfig.containsKey(RerankType.ML_OPENSEARCH.getLabel())) {
            InfoStatsManager.increment(stats, InfoStatName.RERANK_ML_PROCESSORS);
        } else if (processorConfig.containsKey(RerankType.BY_FIELD.getLabel())) {
            InfoStatsManager.increment(stats, InfoStatName.RERANK_BY_FIELD_PROCESSORS);
        }
    }

    @VisibleForTesting
    protected static void increment(Map<InfoStatName, CountableInfoStatSnapshot> stats, InfoStatName infoStatName) {
        InfoStatsManager.incrementBy(stats, infoStatName, 1L);
    }

    private static void incrementBy(Map<InfoStatName, CountableInfoStatSnapshot> stats, InfoStatName statName, Long amount) {
        if (stats.containsKey(statName)) {
            stats.get(statName).incrementBy(amount);
        }
    }

    @VisibleForTesting
    protected void callNullableIncrementer(Map<InfoStatName, CountableInfoStatSnapshot> stats, Consumer<Map<InfoStatName, CountableInfoStatSnapshot>> incrementer) {
        Optional.ofNullable(incrementer).ifPresent(consumer -> consumer.accept(stats));
    }

    private <T> T getValue(Map<String, Object> map, String key, Class<T> clazz) {
        if (map == null || key == null) {
            return null;
        }
        Object value = map.get(key);
        return clazz.isInstance(value) ? (T)clazz.cast(value) : null;
    }

    private Map<String, Object> asMap(Object value) {
        return value instanceof Map ? (Map)value : null;
    }

    private String asString(Object value) {
        return value instanceof String ? (String)value : null;
    }

    private List<Map<String, Object>> asListOfMaps(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            for (Object item : list) {
                if (item instanceof Map) continue;
                return null;
            }
            return (List)value;
        }
        return null;
    }
}

