/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.musicbrainz.search.index.ArtistIndexField;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.servlet.AbstractSearchServer;
import org.musicbrainz.search.servlet.ArtistQueryParser;
import org.musicbrainz.search.servlet.ResourceType;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd1.ArtistMmd1XmlWriter;
import org.musicbrainz.search.servlet.mmd2.ArtistWriter;

public class ArtistSearch
extends AbstractSearchServer {
    protected void setupDefaultFields() {
        this.defaultFields = new ArrayList();
        this.defaultFields.add(ArtistIndexField.ARTIST.getName());
        this.defaultFields.add(ArtistIndexField.ALIAS.getName());
        this.defaultFields.add(ArtistIndexField.SORTNAME.getName());
    }

    private ArtistSearch() throws Exception {
        this.resultsWriter = new ArtistWriter();
        this.mmd1Writer = new ArtistMmd1XmlWriter();
        this.setupDefaultFields();
        this.analyzer = DatabaseIndex.getAnalyzer(ArtistIndexField.class);
    }

    public ArtistSearch(SearcherManager searcherManager) throws Exception {
        this();
        this.searcherManager = searcherManager;
        this.setLastServerUpdatedDate();
        this.resultsWriter.setLastServerUpdatedDate(this.getServerLastUpdatedDate());
    }

    protected Results processResults(IndexSearcher searcher, TopDocs topDocs, int offset) throws IOException {
        Results results = super.processResults(searcher, topDocs, offset);
        results.setResourceType(ResourceType.ARTIST);
        return results;
    }

    public QueryParser getParser() {
        return new ArtistQueryParser(this.defaultFields.toArray(new String[0]), this.analyzer);
    }

    protected String printExplainHeader(Document doc) throws IOException, ParseException {
        return doc.get(ArtistIndexField.ARTIST_ID.getName()) + ':' + doc.get(ArtistIndexField.ARTIST.getName()) + '\n';
    }
}

